/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.special;

import org.apache.commons.math.MathException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.util.ContinuedFraction;
import org.apache.commons.math.util.FastMath;

public class Gamma {
    public static final double GAMMA = 0.5772156649015329;
    private static final double DEFAULT_EPSILON = 1.0E-14;
    private static final double[] LANCZOS = new double[]{0.9999999999999971, 57.15623566586292, -59.59796035547549, 14.136097974741746, -0.4919138160976202, 3.399464998481189E-5, 4.652362892704858E-5, -9.837447530487956E-5, 1.580887032249125E-4, -2.1026444172410488E-4, 2.1743961811521265E-4, -1.643181065367639E-4, 8.441822398385275E-5, -2.6190838401581408E-5, 3.6899182659531625E-6};
    private static final double HALF_LOG_2_PI = 0.5 * FastMath.log(Math.PI * 2);
    private static final double C_LIMIT = 49.0;
    private static final double S_LIMIT = 1.0E-5;

    private Gamma() {
    }

    public static double logGamma(double x2) {
        double ret;
        if (Double.isNaN(x2) || x2 <= 0.0) {
            ret = Double.NaN;
        } else {
            double g2 = 4.7421875;
            double sum = 0.0;
            for (int i2 = LANCZOS.length - 1; i2 > 0; --i2) {
                sum += LANCZOS[i2] / (x2 + (double)i2);
            }
            double tmp = x2 + g2 + 0.5;
            ret = (x2 + 0.5) * FastMath.log(tmp) - tmp + HALF_LOG_2_PI + FastMath.log((sum += LANCZOS[0]) / x2);
        }
        return ret;
    }

    public static double regularizedGammaP(double a2, double x2) throws MathException {
        return Gamma.regularizedGammaP(a2, x2, 1.0E-14, Integer.MAX_VALUE);
    }

    public static double regularizedGammaP(double a2, double x2, double epsilon, int maxIterations) throws MathException {
        double ret;
        if (Double.isNaN(a2) || Double.isNaN(x2) || a2 <= 0.0 || x2 < 0.0) {
            ret = Double.NaN;
        } else if (x2 == 0.0) {
            ret = 0.0;
        } else if (x2 >= a2 + 1.0) {
            ret = 1.0 - Gamma.regularizedGammaQ(a2, x2, epsilon, maxIterations);
        } else {
            double sum;
            double an;
            double n2 = 0.0;
            for (sum = an = 1.0 / a2; FastMath.abs(an / sum) > epsilon && n2 < (double)maxIterations && sum < Double.POSITIVE_INFINITY; sum += (an *= x2 / (a2 + (n2 += 1.0)))) {
            }
            if (n2 >= (double)maxIterations) {
                throw new MaxIterationsExceededException(maxIterations);
            }
            ret = Double.isInfinite(sum) ? 1.0 : FastMath.exp(-x2 + a2 * FastMath.log(x2) - Gamma.logGamma(a2)) * sum;
        }
        return ret;
    }

    public static double regularizedGammaQ(double a2, double x2) throws MathException {
        return Gamma.regularizedGammaQ(a2, x2, 1.0E-14, Integer.MAX_VALUE);
    }

    public static double regularizedGammaQ(final double a2, double x2, double epsilon, int maxIterations) throws MathException {
        double ret;
        if (Double.isNaN(a2) || Double.isNaN(x2) || a2 <= 0.0 || x2 < 0.0) {
            ret = Double.NaN;
        } else if (x2 == 0.0) {
            ret = 1.0;
        } else if (x2 < a2 + 1.0) {
            ret = 1.0 - Gamma.regularizedGammaP(a2, x2, epsilon, maxIterations);
        } else {
            ContinuedFraction cf = new ContinuedFraction(){

                protected double getA(int n2, double x2) {
                    return 2.0 * (double)n2 + 1.0 - a2 + x2;
                }

                protected double getB(int n2, double x2) {
                    return (double)n2 * (a2 - (double)n2);
                }
            };
            ret = 1.0 / cf.evaluate(x2, epsilon, maxIterations);
            ret = FastMath.exp(-x2 + a2 * FastMath.log(x2) - Gamma.logGamma(a2)) * ret;
        }
        return ret;
    }

    public static double digamma(double x2) {
        if (x2 > 0.0 && x2 <= 1.0E-5) {
            return -0.5772156649015329 - 1.0 / x2;
        }
        if (x2 >= 49.0) {
            double inv = 1.0 / (x2 * x2);
            return FastMath.log(x2) - 0.5 / x2 - inv * (0.08333333333333333 + inv * (0.008333333333333333 - inv / 252.0));
        }
        return Gamma.digamma(x2 + 1.0) - 1.0 / x2;
    }

    public static double trigamma(double x2) {
        if (x2 > 0.0 && x2 <= 1.0E-5) {
            return 1.0 / (x2 * x2);
        }
        if (x2 >= 49.0) {
            double inv = 1.0 / (x2 * x2);
            return 1.0 / x2 + inv / 2.0 + inv / x2 * (0.16666666666666666 - inv * (0.03333333333333333 + inv / 42.0));
        }
        return Gamma.trigamma(x2 + 1.0) + 1.0 / (x2 * x2);
    }
}

