/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.special;

import org.apache.commons.math.MathException;
import org.apache.commons.math.special.Gamma;
import org.apache.commons.math.util.FastMath;

public class Erf {
    private Erf() {
    }

    public static double erf(double x2) throws MathException {
        if (FastMath.abs(x2) > 40.0) {
            return x2 > 0.0 ? 1.0 : -1.0;
        }
        double ret = Gamma.regularizedGammaP(0.5, x2 * x2, 1.0E-15, 10000);
        if (x2 < 0.0) {
            ret = -ret;
        }
        return ret;
    }

    public static double erfc(double x2) throws MathException {
        if (FastMath.abs(x2) > 40.0) {
            return x2 > 0.0 ? 0.0 : 2.0;
        }
        double ret = Gamma.regularizedGammaQ(0.5, x2 * x2, 1.0E-15, 10000);
        return x2 < 0.0 ? 2.0 - ret : ret;
    }
}

