/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.interpolation;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.math.MathException;
import org.apache.commons.math.analysis.interpolation.SplineInterpolator;
import org.apache.commons.math.analysis.interpolation.UnivariateRealInterpolator;
import org.apache.commons.math.analysis.polynomials.PolynomialSplineFunction;
import org.apache.commons.math.exception.util.Localizable;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.util.FastMath;

public class LoessInterpolator
implements UnivariateRealInterpolator,
Serializable {
    public static final double DEFAULT_BANDWIDTH = 0.3;
    public static final int DEFAULT_ROBUSTNESS_ITERS = 2;
    public static final double DEFAULT_ACCURACY = 1.0E-12;
    private static final long serialVersionUID = 5204927143605193821L;
    private final double bandwidth;
    private final int robustnessIters;
    private final double accuracy;

    public LoessInterpolator() {
        this.bandwidth = 0.3;
        this.robustnessIters = 2;
        this.accuracy = 1.0E-12;
    }

    public LoessInterpolator(double bandwidth, int robustnessIters) throws MathException {
        this(bandwidth, robustnessIters, 1.0E-12);
    }

    public LoessInterpolator(double bandwidth, int robustnessIters, double accuracy) throws MathException {
        if (bandwidth < 0.0 || bandwidth > 1.0) {
            throw new MathException(LocalizedFormats.BANDWIDTH_OUT_OF_INTERVAL, bandwidth);
        }
        this.bandwidth = bandwidth;
        if (robustnessIters < 0) {
            throw new MathException(LocalizedFormats.NEGATIVE_ROBUSTNESS_ITERATIONS, robustnessIters);
        }
        this.robustnessIters = robustnessIters;
        this.accuracy = accuracy;
    }

    public final PolynomialSplineFunction interpolate(double[] xval, double[] yval) throws MathException {
        return new SplineInterpolator().interpolate(xval, this.smooth(xval, yval));
    }

    public final double[] smooth(double[] xval, double[] yval, double[] weights) throws MathException {
        if (xval.length != yval.length) {
            throw new MathException(LocalizedFormats.MISMATCHED_LOESS_ABSCISSA_ORDINATE_ARRAYS, xval.length, yval.length);
        }
        int n2 = xval.length;
        if (n2 == 0) {
            throw new MathException(LocalizedFormats.LOESS_EXPECTS_AT_LEAST_ONE_POINT, new Object[0]);
        }
        LoessInterpolator.checkAllFiniteReal(xval, LocalizedFormats.NON_REAL_FINITE_ABSCISSA);
        LoessInterpolator.checkAllFiniteReal(yval, LocalizedFormats.NON_REAL_FINITE_ORDINATE);
        LoessInterpolator.checkAllFiniteReal(weights, LocalizedFormats.NON_REAL_FINITE_WEIGHT);
        LoessInterpolator.checkStrictlyIncreasing(xval);
        if (n2 == 1) {
            return new double[]{yval[0]};
        }
        if (n2 == 2) {
            return new double[]{yval[0], yval[1]};
        }
        int bandwidthInPoints = (int)(this.bandwidth * (double)n2);
        if (bandwidthInPoints < 2) {
            throw new MathException(LocalizedFormats.TOO_SMALL_BANDWIDTH, n2, 2.0 / (double)n2, this.bandwidth);
        }
        double[] res = new double[n2];
        double[] residuals = new double[n2];
        double[] sortedResiduals = new double[n2];
        double[] robustnessWeights = new double[n2];
        Arrays.fill(robustnessWeights, 1.0);
        for (int iter = 0; iter <= this.robustnessIters; ++iter) {
            int[] bandwidthInterval = new int[]{0, bandwidthInPoints - 1};
            for (int i2 = 0; i2 < n2; ++i2) {
                int iright;
                int ileft;
                double x2 = xval[i2];
                if (i2 > 0) {
                    LoessInterpolator.updateBandwidthInterval(xval, weights, i2, bandwidthInterval);
                }
                int edge = xval[i2] - xval[ileft = bandwidthInterval[0]] > xval[iright = bandwidthInterval[1]] - xval[i2] ? ileft : iright;
                double sumWeights = 0.0;
                double sumX = 0.0;
                double sumXSquared = 0.0;
                double sumY = 0.0;
                double sumXY = 0.0;
                double denom = FastMath.abs(1.0 / (xval[edge] - x2));
                for (int k2 = ileft; k2 <= iright; ++k2) {
                    double xk = xval[k2];
                    double yk = yval[k2];
                    double dist = k2 < i2 ? x2 - xk : xk - x2;
                    double w2 = LoessInterpolator.tricube(dist * denom) * robustnessWeights[k2] * weights[k2];
                    double xkw = xk * w2;
                    sumWeights += w2;
                    sumX += xkw;
                    sumXSquared += xk * xkw;
                    sumY += yk * w2;
                    sumXY += yk * xkw;
                }
                double meanX = sumX / sumWeights;
                double meanY = sumY / sumWeights;
                double meanXY = sumXY / sumWeights;
                double meanXSquared = sumXSquared / sumWeights;
                double beta = FastMath.sqrt(FastMath.abs(meanXSquared - meanX * meanX)) < this.accuracy ? 0.0 : (meanXY - meanX * meanY) / (meanXSquared - meanX * meanX);
                double alpha = meanY - beta * meanX;
                res[i2] = beta * x2 + alpha;
                residuals[i2] = FastMath.abs(yval[i2] - res[i2]);
            }
            if (iter == this.robustnessIters) break;
            System.arraycopy(residuals, 0, sortedResiduals, 0, n2);
            Arrays.sort(sortedResiduals);
            double medianResidual = sortedResiduals[n2 / 2];
            if (FastMath.abs(medianResidual) < this.accuracy) break;
            for (int i3 = 0; i3 < n2; ++i3) {
                double arg = residuals[i3] / (6.0 * medianResidual);
                if (arg >= 1.0) {
                    robustnessWeights[i3] = 0.0;
                    continue;
                }
                double w3 = 1.0 - arg * arg;
                robustnessWeights[i3] = w3 * w3;
            }
        }
        return res;
    }

    public final double[] smooth(double[] xval, double[] yval) throws MathException {
        if (xval.length != yval.length) {
            throw new MathException(LocalizedFormats.MISMATCHED_LOESS_ABSCISSA_ORDINATE_ARRAYS, xval.length, yval.length);
        }
        double[] unitWeights = new double[xval.length];
        Arrays.fill(unitWeights, 1.0);
        return this.smooth(xval, yval, unitWeights);
    }

    private static void updateBandwidthInterval(double[] xval, double[] weights, int i2, int[] bandwidthInterval) {
        int left = bandwidthInterval[0];
        int right = bandwidthInterval[1];
        int nextRight = LoessInterpolator.nextNonzero(weights, right);
        if (nextRight < xval.length && xval[nextRight] - xval[i2] < xval[i2] - xval[left]) {
            int nextLeft;
            bandwidthInterval[0] = nextLeft = LoessInterpolator.nextNonzero(weights, bandwidthInterval[0]);
            bandwidthInterval[1] = nextRight;
        }
    }

    private static int nextNonzero(double[] weights, int i2) {
        int j2;
        for (j2 = i2 + 1; j2 < weights.length && weights[j2] == 0.0; ++j2) {
        }
        return j2;
    }

    private static double tricube(double x2) {
        double tmp = 1.0 - x2 * x2 * x2;
        return tmp * tmp * tmp;
    }

    private static void checkAllFiniteReal(double[] values, Localizable pattern) throws MathException {
        for (int i2 = 0; i2 < values.length; ++i2) {
            double x2 = values[i2];
            if (!Double.isInfinite(x2) && !Double.isNaN(x2)) continue;
            throw new MathException(pattern, i2, x2);
        }
    }

    private static void checkStrictlyIncreasing(double[] xval) throws MathException {
        for (int i2 = 0; i2 < xval.length; ++i2) {
            if (i2 < 1 || !(xval[i2 - 1] >= xval[i2])) continue;
            throw new MathException(LocalizedFormats.OUT_OF_ORDER_ABSCISSA_ARRAY, i2 - 1, xval[i2 - 1], i2, xval[i2]);
        }
    }
}

