/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import com.jidesoft.converter.ObjectConverterManager;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArrayConverter
implements ObjectConverter {
    private String _separator;
    private int _size;
    private Class<?> _elementClass;
    private Class<?>[] _elementClasses;
    private boolean _useTokenizer;

    public ArrayConverter(String separator, int size, Class<?> elementClass) {
        this._separator = separator;
        this._size = size;
        this._elementClass = elementClass;
    }

    public ArrayConverter(String separator, int size, Class<?>[] elementClasses) {
        if (separator == null || separator.trim().length() == 0) {
            throw new IllegalArgumentException("separator cannot be empty.");
        }
        if (elementClasses == null) {
            throw new IllegalArgumentException("elementClasses cannot be null.");
        }
        if (size != elementClasses.length) {
            throw new IllegalArgumentException("size must be equal to the length of elementClasses.");
        }
        this._separator = separator;
        this._size = size;
        this._elementClasses = elementClasses;
    }

    public String arrayToString(Object[] objects, ConverterContext context) {
        StringBuffer buffer = new StringBuffer();
        for (int i2 = 0; i2 < objects.length; ++i2) {
            Object o2 = objects[i2];
            buffer.append(this.toString(i2, o2, context));
            if (i2 == objects.length - 1) continue;
            buffer.append(this._separator);
        }
        return new String(buffer);
    }

    protected String toString(int i2, Object o2, ConverterContext context) {
        return this._elementClass != null ? ObjectConverterManager.toString(o2, this._elementClass, context) : ObjectConverterManager.toString(o2, this._elementClasses[i2], context);
    }

    public Object[] arrayFromString(String string, ConverterContext context) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        if (this.isUseTokenizer()) {
            StringTokenizer token = new StringTokenizer(string, this._separator);
            Object[] objects = new Object[this._size != -1 ? this._size : token.countTokens()];
            for (int i2 = 0; i2 < objects.length && token.hasMoreTokens(); ++i2) {
                String s2 = token.nextToken().trim();
                objects[i2] = this.fromString(i2, s2, context);
            }
            return objects;
        }
        String[] ss = string.split(this._separator);
        Object[] objects = new Object[this._size != -1 ? this._size : ss.length];
        for (int i3 = 0; i3 < objects.length && i3 < ss.length; ++i3) {
            String s3 = ss[i3].trim();
            objects[i3] = this.fromString(i3, s3, context);
        }
        return objects;
    }

    protected Object fromString(int i2, String s2, ConverterContext context) {
        return this._elementClass != null ? ObjectConverterManager.fromString(s2, this._elementClass, context) : ObjectConverterManager.fromString(s2, this._elementClasses[i2], context);
    }

    public Class<?> getElementClass() {
        return this._elementClass;
    }

    public boolean isUseTokenizer() {
        return this._useTokenizer;
    }

    public void setUseTokenizer(boolean useTokenizer) {
        this._useTokenizer = useTokenizer;
    }
}

