/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.cram.encoding.readfeatures.Deletion;
import htsjdk.samtools.cram.encoding.readfeatures.HardClip;
import htsjdk.samtools.cram.encoding.readfeatures.Insertion;
import htsjdk.samtools.cram.encoding.readfeatures.Padding;
import htsjdk.samtools.cram.encoding.readfeatures.ReadFeature;
import htsjdk.samtools.cram.encoding.readfeatures.RefSkip;
import htsjdk.samtools.cram.encoding.readfeatures.SoftClip;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.ReadTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class Cram2SamRecordFactory {
    private final SAMFileHeader header;

    public Cram2SamRecordFactory(SAMFileHeader header) {
        this.header = header;
    }

    public SAMRecord create(CramCompressionRecord cramRecord) {
        SAMRecord samRecord = new SAMRecord(this.header);
        samRecord.setReadName(cramRecord.readName);
        Cram2SamRecordFactory.copyFlags(cramRecord, samRecord);
        if (cramRecord.sequenceId == -1) {
            samRecord.setAlignmentStart(0);
            samRecord.setMappingQuality(0);
            samRecord.setReferenceIndex(-1);
        } else {
            samRecord.setReferenceIndex(cramRecord.sequenceId);
            samRecord.setAlignmentStart(cramRecord.alignmentStart);
            samRecord.setMappingQuality(cramRecord.mappingQuality);
        }
        if (cramRecord.isSegmentUnmapped()) {
            samRecord.setCigarString("*");
        } else {
            samRecord.setCigar(Cram2SamRecordFactory.getCigar2(cramRecord.readFeatures, cramRecord.readLength));
        }
        if (samRecord.getReadPairedFlag()) {
            samRecord.setMateReferenceIndex(cramRecord.mateSequenceID);
            samRecord.setMateAlignmentStart(cramRecord.mateAlignmentStart > 0 ? cramRecord.mateAlignmentStart : 0);
            samRecord.setMateNegativeStrandFlag(cramRecord.isMateNegativeStrand());
            samRecord.setMateUnmappedFlag(cramRecord.isMateUnmapped());
        } else {
            samRecord.setMateReferenceIndex(-1);
            samRecord.setMateAlignmentStart(0);
        }
        samRecord.setInferredInsertSize(cramRecord.templateSize);
        samRecord.setReadBases(cramRecord.readBases);
        samRecord.setBaseQualities(cramRecord.qualityScores);
        if (cramRecord.tags != null) {
            for (ReadTag tag : cramRecord.tags) {
                samRecord.setAttribute(tag.getKey(), tag.getValue());
            }
        }
        if (cramRecord.readGroupID > -1) {
            SAMReadGroupRecord readGroupRecord = this.header.getReadGroups().get(cramRecord.readGroupID);
            samRecord.setAttribute("RG", (Object)readGroupRecord.getId());
        }
        return samRecord;
    }

    private static void copyFlags(CramCompressionRecord cramRecord, SAMRecord samRecord) {
        samRecord.setReadPairedFlag(cramRecord.isMultiFragment());
        samRecord.setProperPairFlag(cramRecord.isProperPair());
        samRecord.setReadUnmappedFlag(cramRecord.isSegmentUnmapped());
        samRecord.setReadNegativeStrandFlag(cramRecord.isNegativeStrand());
        samRecord.setFirstOfPairFlag(cramRecord.isFirstSegment());
        samRecord.setSecondOfPairFlag(cramRecord.isLastSegment());
        samRecord.setNotPrimaryAlignmentFlag(cramRecord.isSecondaryAlignment());
        samRecord.setReadFailsVendorQualityCheckFlag(cramRecord.isVendorFiltered());
        samRecord.setDuplicateReadFlag(cramRecord.isDuplicate());
        samRecord.setSupplementaryAlignmentFlag(cramRecord.isSupplementary());
    }

    private static Cigar getCigar2(Collection<ReadFeature> features, int readLength) {
        CigarElement cigarElement;
        if (features == null || features.isEmpty()) {
            CigarElement cigarElement2 = new CigarElement(readLength, CigarOperator.M);
            return new Cigar(Collections.singletonList(cigarElement2));
        }
        ArrayList<CigarElement> list = new ArrayList<CigarElement>();
        int totalOpLen = 1;
        CigarOperator lastOperator = CigarOperator.MATCH_OR_MISMATCH;
        int lastOpLen = 0;
        int lastOpPos = 1;
        block10: for (ReadFeature feature : features) {
            int readFeatureLength;
            CigarOperator cigarOperator;
            int gap = feature.getPosition() - (lastOpPos + lastOpLen);
            if (gap > 0) {
                if (lastOperator != CigarOperator.MATCH_OR_MISMATCH) {
                    list.add(new CigarElement(lastOpLen, lastOperator));
                    lastOpPos += lastOpLen;
                    totalOpLen += lastOpLen;
                    lastOpLen = gap;
                } else {
                    lastOpLen += gap;
                }
                lastOperator = CigarOperator.MATCH_OR_MISMATCH;
            }
            switch (feature.getOperator()) {
                case 73: {
                    cigarOperator = CigarOperator.INSERTION;
                    readFeatureLength = ((Insertion)feature).getSequence().length;
                    break;
                }
                case 83: {
                    cigarOperator = CigarOperator.SOFT_CLIP;
                    readFeatureLength = ((SoftClip)feature).getSequence().length;
                    break;
                }
                case 72: {
                    cigarOperator = CigarOperator.HARD_CLIP;
                    readFeatureLength = ((HardClip)feature).getLength();
                    break;
                }
                case 105: {
                    cigarOperator = CigarOperator.INSERTION;
                    readFeatureLength = 1;
                    break;
                }
                case 68: {
                    cigarOperator = CigarOperator.DELETION;
                    readFeatureLength = ((Deletion)feature).getLength();
                    break;
                }
                case 78: {
                    cigarOperator = CigarOperator.SKIPPED_REGION;
                    readFeatureLength = ((RefSkip)feature).getLength();
                    break;
                }
                case 80: {
                    cigarOperator = CigarOperator.PADDING;
                    readFeatureLength = ((Padding)feature).getLength();
                    break;
                }
                case 66: 
                case 88: {
                    cigarOperator = CigarOperator.MATCH_OR_MISMATCH;
                    readFeatureLength = 1;
                    break;
                }
                default: {
                    continue block10;
                }
            }
            if (lastOperator != cigarOperator) {
                if (lastOpLen > 0) {
                    list.add(new CigarElement(lastOpLen, lastOperator));
                    totalOpLen += lastOpLen;
                }
                lastOperator = cigarOperator;
                lastOpLen = readFeatureLength;
                lastOpPos = feature.getPosition();
            } else {
                lastOpLen += readFeatureLength;
            }
            if (cigarOperator.consumesReadBases()) continue;
            lastOpPos -= readFeatureLength;
        }
        if (lastOperator != null) {
            if (lastOperator != CigarOperator.M) {
                list.add(new CigarElement(lastOpLen, lastOperator));
                if (readLength >= lastOpPos + lastOpLen) {
                    cigarElement = new CigarElement(readLength - (lastOpLen + lastOpPos) + 1, CigarOperator.M);
                    list.add(cigarElement);
                }
            } else if (readLength == 0 || readLength > lastOpPos - 1) {
                cigarElement = readLength == 0 ? new CigarElement(lastOpLen, CigarOperator.M) : new CigarElement(readLength - lastOpPos + 1, CigarOperator.M);
                list.add(cigarElement);
            }
        }
        if (list.isEmpty()) {
            cigarElement = new CigarElement(readLength, CigarOperator.M);
            return new Cigar(Collections.singletonList(cigarElement));
        }
        return new Cigar(list);
    }
}

