/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import java.nio.ByteBuffer;

class BinaryCigarCodec {
    BinaryCigarCodec() {
    }

    static int[] encode(Cigar cigar) {
        if (cigar.numCigarElements() == 0) {
            return new int[0];
        }
        int[] binaryCigar = new int[cigar.numCigarElements()];
        int binaryCigarLength = 0;
        for (int i = 0; i < cigar.numCigarElements(); ++i) {
            CigarElement cigarElement = cigar.getCigarElement(i);
            int op = CigarOperator.enumToBinary(cigarElement.getOperator());
            binaryCigar[binaryCigarLength++] = cigarElement.getLength() << 4 | op;
        }
        return binaryCigar;
    }

    static Cigar decode(ByteBuffer binaryCigar) {
        Cigar ret = new Cigar();
        while (binaryCigar.hasRemaining()) {
            int cigarette = binaryCigar.getInt();
            ret.add(BinaryCigarCodec.binaryCigarToCigarElement(cigarette));
        }
        return ret;
    }

    static Cigar decode(int[] binaryCigar) {
        Cigar ret = new Cigar();
        for (int cigarette : binaryCigar) {
            ret.add(BinaryCigarCodec.binaryCigarToCigarElement(cigarette));
        }
        return ret;
    }

    private static CigarElement binaryCigarToCigarElement(int cigarette) {
        int binaryOp = cigarette & 0xF;
        int length = cigarette >>> 4;
        return new CigarElement(length, CigarOperator.binaryToEnum(binaryOp));
    }
}

