/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.demo;

import java.io.IOException;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.Pseudograph;
import org.jgrapht.traverse.BreadthFirstIterator;
import org.jgrapht.traverse.CrossComponentIterator;
import org.jgrapht.traverse.DepthFirstIterator;

public final class PerformanceDemo {
    public static void main(String[] stringArray) {
        Object object;
        long l2 = System.currentTimeMillis();
        PerformanceDemo.reportPerformanceFor("starting at", l2);
        Pseudograph<Object, DefaultEdge> pseudograph = new Pseudograph<Object, DefaultEdge>(DefaultEdge.class);
        Object object2 = object = new Object();
        pseudograph.addVertex(object);
        int n2 = 10000;
        int n3 = 200;
        int n4 = n2 * (1 + n3);
        System.out.println("\nallocating graph with " + n4 + " elements (may take a few tens of seconds)...");
        for (int i2 = 0; i2 < n2; ++i2) {
            object2 = new Object();
            pseudograph.addVertex(object2);
            for (int i3 = 0; i3 < n3; ++i3) {
                pseudograph.addEdge(object, object2);
            }
            object = object2;
        }
        PerformanceDemo.reportPerformanceFor("graph allocation", l2);
        l2 = System.currentTimeMillis();
        CrossComponentIterator crossComponentIterator = new BreadthFirstIterator(pseudograph);
        while (crossComponentIterator.hasNext()) {
            crossComponentIterator.next();
        }
        PerformanceDemo.reportPerformanceFor("breadth traversal", l2);
        l2 = System.currentTimeMillis();
        crossComponentIterator = new DepthFirstIterator(pseudograph);
        while (crossComponentIterator.hasNext()) {
            crossComponentIterator.next();
        }
        PerformanceDemo.reportPerformanceFor("depth traversal", l2);
        System.out.println("\nPaused: graph is still in memory (to check mem consumption).");
        System.out.print("press enter to free memory and finish...");
        try {
            System.in.read();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println("done.");
    }

    private static void reportPerformanceFor(String string, long l2) {
        double d2 = (double)(System.currentTimeMillis() - l2) / 1000.0;
        double d3 = (double)PerformanceDemo.usedMemory() / 1048576.0;
        d3 = (double)Math.round(d3 * 100.0) / 100.0;
        System.out.println(string + " (" + d2 + " sec, " + d3 + "MB)");
    }

    private static long usedMemory() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.totalMemory() - runtime.freeMemory();
    }
}

