/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.basic.BasicLabelUI;

public class VerticalLabelUI
extends BasicLabelUI {
    protected boolean clockwise;
    private static Rectangle paintIconR;
    private static Rectangle paintTextR;
    private static Rectangle paintViewR;
    private static Insets paintViewInsets;

    public VerticalLabelUI(boolean clockwise) {
        this.clockwise = clockwise;
    }

    @Override
    public Dimension getPreferredSize(JComponent c2) {
        Dimension dim = super.getPreferredSize(c2);
        return new Dimension(dim.height, dim.width);
    }

    @Override
    public void paint(Graphics g2, JComponent c2) {
        Icon icon;
        JLabel label = (JLabel)c2;
        String text = label.getText();
        Icon icon2 = icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        if (icon == null && text == null) {
            return;
        }
        FontMetrics fm = g2.getFontMetrics();
        paintViewInsets = c2.getInsets(paintViewInsets);
        VerticalLabelUI.paintViewR.x = VerticalLabelUI.paintViewInsets.left;
        VerticalLabelUI.paintViewR.y = VerticalLabelUI.paintViewInsets.top;
        VerticalLabelUI.paintViewR.height = c2.getWidth() - (VerticalLabelUI.paintViewInsets.left + VerticalLabelUI.paintViewInsets.right);
        VerticalLabelUI.paintViewR.width = c2.getHeight() - (VerticalLabelUI.paintViewInsets.top + VerticalLabelUI.paintViewInsets.bottom);
        VerticalLabelUI.paintIconR.height = 0;
        VerticalLabelUI.paintIconR.width = 0;
        VerticalLabelUI.paintIconR.y = 0;
        VerticalLabelUI.paintIconR.x = 0;
        VerticalLabelUI.paintTextR.height = 0;
        VerticalLabelUI.paintTextR.width = 0;
        VerticalLabelUI.paintTextR.y = 0;
        VerticalLabelUI.paintTextR.x = 0;
        String clippedText = this.layoutCL(label, fm, text, icon, paintViewR, paintIconR, paintTextR);
        Graphics2D g22 = (Graphics2D)g2;
        AffineTransform tr = g22.getTransform();
        if (this.clockwise) {
            g22.rotate(1.5707963267948966);
            g22.translate(0, -c2.getWidth());
        } else {
            g22.rotate(-1.5707963267948966);
            g22.translate(-c2.getHeight(), 0);
        }
        if (icon != null) {
            icon.paintIcon(c2, g2, VerticalLabelUI.paintIconR.x, VerticalLabelUI.paintIconR.y);
        }
        if (text != null) {
            int textX = VerticalLabelUI.paintTextR.x;
            int textY = VerticalLabelUI.paintTextR.y + fm.getAscent();
            if (label.isEnabled()) {
                this.paintEnabledText(label, g2, clippedText, textX, textY);
            } else {
                this.paintDisabledText(label, g2, clippedText, textX, textY);
            }
        }
        g22.setTransform(tr);
    }

    static {
        labelUI = new VerticalLabelUI(false);
        paintIconR = new Rectangle();
        paintTextR = new Rectangle();
        paintViewR = new Rectangle();
        paintViewInsets = new Insets(0, 0, 0, 0);
    }
}

