/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.broad.igv.track.RenderContext;
import org.broad.igv.ui.panel.ReferenceFrame;

public class RenderContextImpl
implements RenderContext {
    private Graphics2D graphics;
    private Map<Color, Graphics2D> graphicCacheByColor;
    private ReferenceFrame referenceFrame;
    private JComponent panel;
    private Rectangle visibleRect;

    public RenderContextImpl(JComponent panel, Graphics2D graphics, ReferenceFrame referenceFrame, Rectangle visibleRect) {
        this.graphics = graphics;
        this.panel = panel;
        this.graphicCacheByColor = new HashMap<Color, Graphics2D>();
        this.referenceFrame = referenceFrame;
        this.visibleRect = visibleRect;
    }

    @Override
    public Graphics2D getGraphic2DForColor(Color color) {
        Graphics2D g2 = this.graphicCacheByColor.get(color);
        if (g2 == null) {
            g2 = (Graphics2D)this.graphics.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.graphicCacheByColor.put(color, g2);
            g2.setColor(color);
        }
        return g2;
    }

    public Color getBackgroundColor() {
        return this.panel.getBackground();
    }

    @Override
    public String getChr() {
        return this.referenceFrame.getChrName();
    }

    @Override
    public double getOrigin() {
        return this.referenceFrame.getOrigin();
    }

    @Override
    public double getEndLocation() {
        return this.referenceFrame.getEnd();
    }

    @Override
    public double getScale() {
        return this.referenceFrame.getScale();
    }

    @Override
    public Rectangle getVisibleRect() {
        return this.visibleRect;
    }

    @Override
    public JComponent getPanel() {
        return this.panel;
    }

    @Override
    public Graphics2D getGraphics() {
        return this.graphics;
    }

    @Override
    public int getZoom() {
        return this.referenceFrame.getZoom();
    }

    @Override
    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    @Override
    public int bpToScreenPixel(double location) {
        double scale = this.getScale();
        double origin = this.getOrigin();
        return (int)((location - origin) / scale);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    @Override
    public void dispose() {
        for (Graphics2D g2 : this.graphicCacheByColor.values()) {
            g2.dispose();
        }
        this.graphicCacheByColor.clear();
    }
}

