/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.gwas;

import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.Feature;
import htsjdk.tribble.readers.LineIterator;
import java.util.HashMap;
import org.broad.igv.Globals;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.tribble.FeatureFileHeader;
import org.broad.igv.gwas.EQTLFeature;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.util.StringUtils;

public class EQTLCodec
extends AsciiFeatureCodec<EQTLFeature> {
    String[] columnNames;
    Genome genome;
    private FeatureFileHeader header;

    public EQTLCodec(Genome genome) {
        super(EQTLFeature.class);
        this.genome = genome;
    }

    @Override
    public Feature decodeLoc(String line) {
        String[] tokens = Globals.tabPattern.split(line);
        if (tokens[0].equals("SNP")) {
            return null;
        }
        String chr = tokens[1];
        int position = Integer.parseInt(tokens[2]) - 1;
        return new BasicFeature(chr, position, position + 1);
    }

    @Override
    public EQTLFeature decode(String s2) {
        String[] tokens = Globals.tabPattern.split(s2);
        if (tokens[0].equals("SNP")) {
            this.columnNames = tokens;
            return null;
        }
        String snp = tokens[0];
        String chr = this.genome == null ? StringUtils.intern(tokens[1]) : this.genome.getChromosomeAlias(tokens[1]);
        int position = Integer.parseInt(tokens[2]) - 1;
        String geneId = tokens[3];
        String geneName = tokens[4];
        double tmp = Double.parseDouble(tokens[5]);
        float pValue = tmp < (double)1.4E-45f ? Float.MIN_VALUE : (float)tmp;
        HashMap<String, String> attributes = null;
        if (this.columnNames != null) {
            attributes = new HashMap<String, String>();
            for (int i2 = 5; i2 < tokens.length; ++i2) {
                if (this.columnNames.length >= i2) continue;
                attributes.put(this.columnNames[i2], tokens[i2]);
            }
        }
        return new EQTLFeature(snp, chr, position, geneId, geneName, pValue);
    }

    @Override
    public Object readActualHeader(LineIterator reader) {
        if (this.header == null) {
            this.header = new FeatureFileHeader();
            TrackProperties tp = new TrackProperties();
            tp.setDisplayMode(Track.DisplayMode.EXPANDED);
            this.header.setTrackProperties(tp);
        }
        return this.header;
    }

    @Override
    public boolean canDecode(String path) {
        String fn = path.toLowerCase();
        if (fn.endsWith(".gz")) {
            fn = fn.substring(0, fn.length() - 3);
        }
        return fn.endsWith(".eqtl");
    }
}

