/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ga4gh;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.broad.igv.ga4gh.Ga4ghAlignment;
import org.broad.igv.ga4gh.Ga4ghDataset;
import org.broad.igv.ga4gh.Ga4ghProvider;
import org.broad.igv.ga4gh.Ga4ghReadset;
import org.broad.igv.ga4gh.OAuthUtils;
import org.broad.igv.sam.Alignment;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.MessageUtils;

public class Ga4ghAPIHelper {
    private static Logger log = Logger.getLogger(Ga4ghAPIHelper.class);
    public static final String RESOURCE_TYPE = "ga4gh";
    public static final Ga4ghProvider GA4GH_GOOGLE_PROVIDER = new Ga4ghProvider("Google", "https://www.googleapis.com/genomics/v1beta2", "AIzaSyC-dujgw4P1QvNd8i_c-I-S_P1uxVZzn0w", Arrays.asList(new Ga4ghDataset("10473108253681171589", "1000 Genomes", "hg19"), new Ga4ghDataset("383928317087", "PGP", "hg19"), new Ga4ghDataset("461916304629", "Simons Foundation", "hg19")));
    public static final Ga4ghProvider GA4GH_NCBI_PROVIDER = new Ga4ghProvider("NCBI", "http://trace.ncbi.nlm.nih.gov/Traces/gg", null, Arrays.asList(new Ga4ghDataset("SRP034507", "SRP034507", "M74568"), new Ga4ghDataset("SRP029392", "SRP029392", "NC_004917")));
    public static final Ga4ghProvider[] providers = new Ga4ghProvider[]{GA4GH_GOOGLE_PROVIDER};
    static final Map<String, List<Ga4ghReadset>> readsetCache = new HashMap<String, List<Ga4ghReadset>>();
    static final Map<String, List<JsonObject>> referenceCache = new HashMap<String, List<JsonObject>>();
    static Map<String, String> genomeIdMap = new HashMap<String, String>();

    public static List<Ga4ghReadset> searchReadGroupsets(Ga4ghProvider provider, String datasetId, int maxResults) throws IOException {
        List<Ga4ghReadset> readsets = readsetCache.get(datasetId);
        if (readsets == null) {
            readsets = new ArrayList<Ga4ghReadset>();
            String genomeId = genomeIdMap.get(provider.getName() + " " + datasetId);
            int maxPages = 100;
            JsonPrimitive pageToken = null;
            while (maxPages-- > 0) {
                String contentToPost = "{\"datasetIds\": [\"" + datasetId + "\"]" + (pageToken == null ? "" : ", \"pageToken\": " + pageToken) + ", \"pageSize\":" + maxResults + "}";
                String result = Ga4ghAPIHelper.doPost(provider, "/readgroupsets/search", contentToPost, null);
                if (result == null) {
                    return null;
                }
                JsonParser parser = new JsonParser();
                JsonObject obj = parser.parse(result).getAsJsonObject();
                for (JsonElement next : obj.getAsJsonArray("readGroupSets")) {
                    JsonObject jobj = next.getAsJsonObject();
                    String id = jobj.get("id").getAsString();
                    String name = jobj.get("name").getAsString();
                    readsets.add(new Ga4ghReadset(id, name, genomeId));
                }
                if (readsets.size() < maxResults && (pageToken = obj.getAsJsonPrimitive("nextPageToken")) != null) continue;
                break;
            }
            Collections.sort(readsets, new Comparator<Ga4ghReadset>(){

                @Override
                public int compare(Ga4ghReadset o1, Ga4ghReadset o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            readsetCache.put(datasetId, readsets);
        }
        return readsets;
    }

    public static List<JsonObject> searchReferences(Ga4ghProvider provider, String referenceSetId, int maxResults) throws IOException {
        List<JsonObject> references = referenceCache.get(referenceSetId);
        if (references == null) {
            references = new ArrayList<JsonObject>();
            int maxPages = 100;
            JsonPrimitive pageToken = null;
            while (maxPages-- > 0) {
                String contentToPost = "{\"referenceSetId\": \"" + referenceSetId + "\"" + (pageToken == null ? "" : ", \"pageToken\": " + pageToken) + ", \"pageSize\":" + maxResults + "}";
                String result = Ga4ghAPIHelper.doPost(provider, "/references/search", contentToPost, null);
                if (result == null) {
                    return null;
                }
                JsonParser parser = new JsonParser();
                JsonObject obj = parser.parse(result).getAsJsonObject();
                for (JsonElement next : obj.getAsJsonArray("references")) {
                    references.add(next.getAsJsonObject());
                }
                if (references.size() < maxResults && (pageToken = obj.getAsJsonPrimitive("nextPageToken")) != null) continue;
                break;
            }
            referenceCache.put(referenceSetId, references);
        }
        return references;
    }

    public static List<Alignment> searchReads(Ga4ghProvider provider, String readGroupSetId, String chr, int start, int end) throws IOException {
        ArrayList<Alignment> alignments = new ArrayList<Alignment>(10000);
        int maxPages = 10000;
        JsonPrimitive pageToken = null;
        StringBuffer result = new StringBuffer();
        while (maxPages-- > 0) {
            String contentToPost = "{\"readGroupSetIds\": [\"" + readGroupSetId + "\"]" + ", \"referenceName\": \"" + chr + "\"" + ", \"start\": \"" + start + "\"" + ", \"end\": \"" + end + "\"" + ", \"pageSize\": \"10000\"" + (pageToken == null ? "" : ", \"pageToken\": " + pageToken) + "}";
            String readString = Ga4ghAPIHelper.doPost(provider, "/reads/search", contentToPost, "");
            if (readString == null) {
                return null;
            }
            JsonParser parser = new JsonParser();
            JsonObject obj = parser.parse(readString).getAsJsonObject();
            JsonArray reads = obj.getAsJsonArray("alignments");
            for (JsonElement next : reads) {
                Ga4ghAlignment alignment = new Ga4ghAlignment(next.getAsJsonObject());
                alignments.add(alignment);
            }
            pageToken = obj.getAsJsonPrimitive("nextPageToken");
            if (pageToken != null) continue;
            break;
        }
        return alignments;
    }

    private static String doPost(Ga4ghProvider provider, String command, String content, String fields) throws IOException {
        String authKey = provider.getAuthKey();
        String baseURL = provider.getBaseURL();
        String token = OAuthUtils.getInstance().getAccessToken();
        String fullUrl = baseURL + command;
        if (authKey != null) {
            fullUrl = fullUrl + "?key=" + authKey;
        }
        if (fields != null) {
            fullUrl = fullUrl + (authKey == null ? "?" : "&") + fields;
        }
        URL url = new URL(fullUrl);
        byte[] bytes = content.getBytes();
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)url.openConnection();
            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Cache-Control", "no-cache");
            connection.setRequestProperty("Accept-Encoding", "gzip");
            connection.setRequestProperty("User-Agent", "IGV (gzip)");
            if (token != null) {
                connection.setRequestProperty("Authorization", "Bearer " + token);
            }
            OutputStream outputStream = connection.getOutputStream();
            outputStream.write(bytes);
            outputStream.close();
            BufferedReader br = new BufferedReader(new InputStreamReader(new GZIPInputStream(connection.getInputStream())));
            StringBuffer sb = new StringBuffer();
            String str = br.readLine();
            while (str != null) {
                sb.append(str);
                str = br.readLine();
            }
            br.close();
            return sb.toString();
        }
        catch (Exception e2) {
            Ga4ghAPIHelper.handleHttpException(url, connection, e2);
            return null;
        }
    }

    static void handleHttpException(URL url, HttpURLConnection connection, Exception e2) throws IOException {
        int rs = connection.getResponseCode();
        if (rs == 404) {
            MessageUtils.showErrorMessage("The requested resource was not found<br>" + url, e2);
        } else if (rs == 401 || rs == 403) {
            Ga4ghAPIHelper.displayAuthorizationDialog(url.getHost());
        } else {
            MessageUtils.showErrorMessage("Error accessing resource", e2);
            log.error("Error accessing resource", e2);
        }
    }

    static void displayAuthorizationDialog(String host) {
        String message = "The requested resource at '" + host + "' requires authorization.";
        Icon icon = null;
        int option = JOptionPane.showOptionDialog(IGV.getMainFrame(), message, "Error", 2, 3, icon, new String[]{"Cancel", "Authorize"}, 0);
        if (option == 1) {
            try {
                OAuthUtils.getInstance().openAuthorizationPage();
            }
            catch (Exception e2) {
                MessageUtils.showErrorMessage("Error fetching oAuth token", e2);
                log.error("Error fetching oAuth tokens", e2);
            }
        }
    }

    static {
        genomeIdMap = new HashMap<String, String>();
        genomeIdMap.put("Google 10473108253681171589", "hg19");
        genomeIdMap.put("Google 383928317087", "hg19");
        genomeIdMap.put("Google 461916304629", "hg19");
        genomeIdMap.put("Google 337315832689", "hg19");
    }
}

