/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.complex;

import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.complex.Complex;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.util.FastMath;

public class ComplexUtils {
    private ComplexUtils() {
    }

    public static Complex polar2Complex(double r2, double theta) {
        if (r2 < 0.0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NEGATIVE_COMPLEX_MODULE, r2);
        }
        return new Complex(r2 * FastMath.cos(theta), r2 * FastMath.sin(theta));
    }
}

