/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.DefaultSAMRecordFactory;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileSource;
import htsjdk.samtools.SAMFormatException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordFactory;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMValidationError;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.TagValueAndUnsignedArrayFlag;
import htsjdk.samtools.TextTagCodec;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class SAMLineParser {
    private static final int QNAME_COL = 0;
    private static final int FLAG_COL = 1;
    private static final int RNAME_COL = 2;
    private static final int POS_COL = 3;
    private static final int MAPQ_COL = 4;
    private static final int CIGAR_COL = 5;
    private static final int MRNM_COL = 6;
    private static final int MPOS_COL = 7;
    private static final int ISIZE_COL = 8;
    private static final int SEQ_COL = 9;
    private static final int QUAL_COL = 10;
    private static final int NUM_REQUIRED_FIELDS = 11;
    private static final Pattern VALID_BASES = Pattern.compile("^[acmgrsvtwyhkdbnACMGRSVTWYHKDBN.=]+$");
    private final String[] mFields = new String[10000];
    private final SamReader mParentReader;
    private final SAMRecordFactory samRecordFactory;
    private final ValidationStringency validationStringency;
    private final SAMFileHeader mFileHeader;
    private final File mFile;
    private final TextTagCodec tagCodec = new TextTagCodec();
    private int currentLineNumber;
    private String currentLine;

    public SAMLineParser(SAMFileHeader samFileHeader) {
        this(new DefaultSAMRecordFactory(), ValidationStringency.DEFAULT_STRINGENCY, samFileHeader, null, null);
    }

    public SAMLineParser(SAMFileHeader samFileHeader, SamReader samFileReader, File samFile) {
        this(new DefaultSAMRecordFactory(), ValidationStringency.DEFAULT_STRINGENCY, samFileHeader, samFileReader, samFile);
    }

    public SAMLineParser(SAMRecordFactory samRecordFactory, ValidationStringency validationStringency, SAMFileHeader samFileHeader, SamReader samFileReader, File samFile) {
        if (samRecordFactory == null) {
            throw new NullPointerException("The SamRecordFactory must be set");
        }
        if (validationStringency == null) {
            throw new NullPointerException("The validationStringency must be set");
        }
        if (samFileHeader == null) {
            throw new NullPointerException("The mFileHeader must be set");
        }
        this.samRecordFactory = samRecordFactory;
        this.validationStringency = validationStringency;
        this.mFileHeader = samFileHeader;
        this.mParentReader = samFileReader;
        this.mFile = samFile;
    }

    public SAMFileHeader getFileHeader() {
        return this.mFileHeader;
    }

    public ValidationStringency getValidationStringency() {
        return this.validationStringency;
    }

    private int parseInt(String s2, String fieldName) {
        int ret;
        try {
            ret = Integer.parseInt(s2);
        }
        catch (NumberFormatException e2) {
            throw this.reportFatalErrorParsingLine("Non-numeric value in " + fieldName + " column");
        }
        return ret;
    }

    private void validateReferenceName(String rname, String fieldName) {
        if (rname.equals("=")) {
            if (fieldName.equals("MRNM")) {
                return;
            }
            this.reportErrorParsingLine("= is not a valid value for " + fieldName + " field.");
        }
        if (this.mFileHeader.getSequenceDictionary().size() != 0 && this.mFileHeader.getSequence(rname) == null) {
            this.reportErrorParsingLine(fieldName + " '" + rname + "' not found in any SQ record");
        }
    }

    public SAMRecord parseLine(String line) {
        return this.parseLine(line, -1);
    }

    public SAMRecord parseLine(String line, int lineNumber) {
        List<SAMValidationError> validationErrors;
        String mCurrentLine = line;
        this.currentLineNumber = lineNumber;
        this.currentLine = line;
        int numFields = StringUtil.split(mCurrentLine, this.mFields, '\t');
        if (numFields < 11) {
            throw this.reportFatalErrorParsingLine("Not enough fields");
        }
        if (numFields == this.mFields.length) {
            this.reportErrorParsingLine("Too many fields in SAM text record.");
        }
        for (int i2 = 0; i2 < numFields; ++i2) {
            if (this.mFields[i2].length() != 0) continue;
            this.reportErrorParsingLine("Empty field at position " + i2 + " (zero-based)");
        }
        SAMRecord samRecord = this.samRecordFactory.createSAMRecord(this.mFileHeader);
        samRecord.setValidationStringency(this.validationStringency);
        if (this.mParentReader != null) {
            samRecord.setFileSource(new SAMFileSource(this.mParentReader, null));
        }
        samRecord.setHeader(this.mFileHeader);
        samRecord.setReadName(this.mFields[0]);
        int flags = this.parseInt(this.mFields[1], "FLAG");
        samRecord.setFlags(flags);
        String rname = this.mFields[2];
        if (!rname.equals("*")) {
            rname = SAMSequenceRecord.truncateSequenceName(rname);
            this.validateReferenceName(rname, "RNAME");
            samRecord.setReferenceName(rname);
        } else if (!samRecord.getReadUnmappedFlag()) {
            this.reportErrorParsingLine("RNAME is not specified but flags indicate mapped");
        }
        int pos = this.parseInt(this.mFields[3], "POS");
        int mapq = this.parseInt(this.mFields[4], "MAPQ");
        String cigar = this.mFields[5];
        if (!"*".equals(samRecord.getReferenceName())) {
            if (pos == 0) {
                this.reportErrorParsingLine("POS must be non-zero if RNAME is specified");
            }
            if (!samRecord.getReadUnmappedFlag() && cigar.equals("*")) {
                this.reportErrorParsingLine("CIGAR must not be '*' if RNAME is specified");
            }
        } else {
            if (pos != 0) {
                this.reportErrorParsingLine("POS must be zero if RNAME is not specified");
            }
            if (mapq != 0) {
                this.reportErrorParsingLine("MAPQ must be zero if RNAME is not specified");
            }
            if (!cigar.equals("*")) {
                this.reportErrorParsingLine("CIGAR must be '*' if RNAME is not specified");
            }
        }
        samRecord.setAlignmentStart(pos);
        samRecord.setMappingQuality(mapq);
        samRecord.setCigarString(cigar);
        String mateRName = this.mFields[6];
        if (mateRName.equals("*")) {
            if (samRecord.getReadPairedFlag() && !samRecord.getMateUnmappedFlag()) {
                this.reportErrorParsingLine("MRNM not specified but flags indicate mate mapped");
            }
        } else {
            if (!samRecord.getReadPairedFlag()) {
                this.reportErrorParsingLine("MRNM specified but flags indicate unpaired");
            }
            if (!"=".equals(mateRName)) {
                mateRName = SAMSequenceRecord.truncateSequenceName(mateRName);
            }
            this.validateReferenceName(mateRName, "MRNM");
            if (mateRName.equals("=")) {
                if (samRecord.getReferenceName() == null) {
                    this.reportErrorParsingLine("MRNM is '=', but RNAME is not set");
                }
                samRecord.setMateReferenceName(samRecord.getReferenceName());
            } else {
                samRecord.setMateReferenceName(mateRName);
            }
        }
        int matePos = this.parseInt(this.mFields[7], "MPOS");
        int isize = this.parseInt(this.mFields[8], "ISIZE");
        if (!samRecord.getMateReferenceName().equals("*")) {
            if (matePos == 0) {
                this.reportErrorParsingLine("MPOS must be non-zero if MRNM is specified");
            }
        } else {
            if (matePos != 0) {
                this.reportErrorParsingLine("MPOS must be zero if MRNM is not specified");
            }
            if (isize != 0) {
                this.reportErrorParsingLine("ISIZE must be zero if MRNM is not specified");
            }
        }
        samRecord.setMateAlignmentStart(matePos);
        samRecord.setInferredInsertSize(isize);
        if (!this.mFields[9].equals("*")) {
            this.validateReadBases(this.mFields[9]);
            samRecord.setReadString(this.mFields[9]);
        } else {
            samRecord.setReadBases(SAMRecord.NULL_SEQUENCE);
        }
        if (!this.mFields[10].equals("*")) {
            if (samRecord.getReadBases() == SAMRecord.NULL_SEQUENCE) {
                this.reportErrorParsingLine("QUAL should not be specified if SEQ is not specified");
            }
            if (samRecord.getReadString().length() != this.mFields[10].length()) {
                this.reportErrorParsingLine("length(QUAL) != length(SEQ)");
            }
            samRecord.setBaseQualityString(this.mFields[10]);
        } else {
            samRecord.setBaseQualities(SAMRecord.NULL_QUALS);
        }
        for (int i3 = 11; i3 < numFields; ++i3) {
            this.parseTag(samRecord, this.mFields[i3]);
        }
        if (this.validationStringency != ValidationStringency.SILENT && (validationErrors = samRecord.isValid()) != null) {
            for (SAMValidationError errorMessage : validationErrors) {
                this.reportErrorParsingLine(errorMessage.getMessage());
            }
        }
        return samRecord;
    }

    private void validateReadBases(String bases) {
        for (int i2 = 0; i2 < bases.length(); ++i2) {
            if (this.isValidReadBase(bases.charAt(i2))) continue;
            this.reportErrorParsingLine("Invalid character in read bases");
            return;
        }
    }

    private boolean isValidReadBase(char base) {
        switch (base) {
            case '.': 
            case '=': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'G': 
            case 'H': 
            case 'K': 
            case 'M': 
            case 'N': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'V': 
            case 'W': 
            case 'Y': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'g': 
            case 'h': 
            case 'k': 
            case 'm': 
            case 'n': 
            case 'r': 
            case 's': 
            case 't': 
            case 'v': 
            case 'w': 
            case 'y': {
                return true;
            }
        }
        return false;
    }

    private void parseTag(SAMRecord samRecord, String tag) {
        Map.Entry<String, Object> entry = null;
        try {
            entry = this.tagCodec.decode(tag);
        }
        catch (SAMFormatException e2) {
            this.reportErrorParsingLine(e2);
        }
        if (entry != null) {
            if (entry.getValue() instanceof TagValueAndUnsignedArrayFlag) {
                TagValueAndUnsignedArrayFlag valueAndFlag = (TagValueAndUnsignedArrayFlag)entry.getValue();
                if (valueAndFlag.isUnsignedArray) {
                    samRecord.setUnsignedArrayAttribute(entry.getKey(), valueAndFlag.value);
                } else {
                    samRecord.setAttribute(entry.getKey(), valueAndFlag.value);
                }
            } else {
                samRecord.setAttribute(entry.getKey(), entry.getValue());
            }
        }
    }

    private RuntimeException reportFatalErrorParsingLine(String reason) {
        return new SAMFormatException(this.makeErrorString(reason));
    }

    private void reportErrorParsingLine(String reason) {
        String errorMessage = this.makeErrorString(reason);
        if (this.validationStringency == ValidationStringency.STRICT) {
            throw new SAMFormatException(errorMessage);
        }
        if (this.validationStringency == ValidationStringency.LENIENT) {
            System.err.println("Ignoring SAM validation error due to lenient parsing:");
            System.err.println(errorMessage);
        }
    }

    private void reportErrorParsingLine(Exception e2) {
        String errorMessage = this.makeErrorString(e2.getMessage());
        if (this.validationStringency == ValidationStringency.STRICT) {
            throw new SAMFormatException(errorMessage);
        }
        if (this.validationStringency == ValidationStringency.LENIENT) {
            System.err.println("Ignoring SAM validation error due to lenient parsing:");
            System.err.println(errorMessage);
        }
    }

    private String makeErrorString(String reason) {
        String fileMessage = "";
        if (this.mFile != null) {
            fileMessage = "File " + this.mFile + "; ";
        }
        return "Error parsing text SAM file. " + reason + "; " + fileMessage + "Line " + (this.currentLineNumber <= 0 ? "unknown" : Integer.valueOf(this.currentLineNumber)) + "\nLine: " + this.currentLine;
    }
}

