/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.util;

import java.util.Arrays;
import java.util.regex.Pattern;

public class MyAsserts {
    private static Pattern _whiteSpace = Pattern.compile("\\s+", 40);

    public static void assertTrue(boolean b2) {
        if (!b2) {
            throw new MyAssert("false");
        }
    }

    public static void assertTrue(boolean b2, String msg) {
        if (!b2) {
            throw new MyAssert("false : " + msg);
        }
    }

    public static void assertFalse(boolean b2) {
        if (b2) {
            throw new MyAssert("true");
        }
    }

    public static void assertEquals(int a2, int b2) {
        if (a2 != b2) {
            throw new MyAssert("" + a2 + " != " + b2);
        }
    }

    public static void assertEquals(long a2, long b2) {
        if (a2 != b2) {
            throw new MyAssert("" + a2 + " != " + b2);
        }
    }

    public static void assertEquals(char a2, char b2) {
        if (a2 != b2) {
            throw new MyAssert("" + a2 + " != " + b2);
        }
    }

    public static void assertEquals(short a2, short b2) {
        if (a2 != b2) {
            throw new MyAssert("" + a2 + " != " + b2);
        }
    }

    public static void assertEquals(byte expected, byte result) {
        if (expected != result) {
            throw new MyAssert("" + expected + " != " + result);
        }
    }

    public static void assertEquals(double a2, double b2, double diff) {
        if (Math.abs(a2 - b2) > diff) {
            throw new MyAssert("" + a2 + " != " + b2);
        }
    }

    public static void assertEquals(String a2, Object b2) {
        MyAsserts._assertEquals(a2, b2 == null ? null : b2.toString());
    }

    public static void assertSame(Object a2, Object b2) {
        if (a2 != b2) {
            throw new MyAssert(a2 + " != " + b2);
        }
    }

    public static void assertEquals(Object a2, Object b2) {
        MyAsserts._assertEquals(a2, b2);
    }

    public static void _assertEquals(Object a2, Object b2) {
        if (a2 == null) {
            if (b2 == null) {
                return;
            }
            throw new MyAssert("left null, right not");
        }
        if (a2.equals(b2)) {
            return;
        }
        throw new MyAssert("[" + a2 + "] != [" + b2 + "] ");
    }

    public static void assertEquals(String a2, String b2, String msg) {
        if (a2.equals(b2)) {
            return;
        }
        throw new MyAssert("[" + a2 + "] != [" + b2 + "] " + msg);
    }

    public static void assertArrayEquals(byte[] expected, byte[] result) {
        if (Arrays.equals(expected, result)) {
            return;
        }
        throw new MyAssert("These arrays are different, but they might be big so not printing them here");
    }

    public static void assertArrayEquals(char[] expected, char[] result) {
        if (Arrays.equals(expected, result)) {
            return;
        }
        throw new MyAssert("These arrays are different, but they might be big so not printing them here");
    }

    public static void assertNotEquals(Object a2, Object b2) {
        if (a2 == null) {
            if (b2 != null) {
                return;
            }
            throw new MyAssert("left null, right null");
        }
        if (!a2.equals(b2)) {
            return;
        }
        throw new MyAssert("[" + a2 + "] == [" + b2 + "] ");
    }

    public static void assertClose(String a2, Object o2) {
        MyAsserts.assertClose(a2, o2 == null ? "null" : o2.toString());
    }

    public static void assertClose(String a2, String b2) {
        MyAsserts.assertClose(a2, b2, "");
    }

    public static void assertClose(String a2, String b2, String tag) {
        if (MyAsserts.isClose(a2, b2)) {
            return;
        }
        throw new MyAssert(tag + "[" + a2 + "] != [" + b2 + "]");
    }

    public static boolean isClose(String a2, String b2) {
        a2 = MyAsserts._simplify(a2);
        b2 = MyAsserts._simplify(b2);
        return a2.equalsIgnoreCase(b2);
    }

    private static String _simplify(String s2) {
        s2 = s2.trim();
        s2 = _whiteSpace.matcher(s2).replaceAll("");
        return s2;
    }

    public static void assertNull(Object foo) {
        if (foo == null) {
            return;
        }
        throw new MyAssert("not null [" + foo + "]");
    }

    public static void assertNotNull(Object foo) {
        if (foo != null) {
            return;
        }
        throw new MyAssert("null");
    }

    public static void assertLess(long lower, long higher) {
        if (lower < higher) {
            return;
        }
        throw new MyAssert(lower + " is higher than " + higher);
    }

    public static void assertLess(double lower, double higher) {
        if (lower < higher) {
            return;
        }
        throw new MyAssert(lower + " is higher than " + higher);
    }

    public static void assertEmptyString(String s2) {
        if (!s2.equals("")) {
            throw new MyAssert(s2);
        }
    }

    public static void fail(String errorMessage) {
        throw new MyAssert(errorMessage);
    }

    public static class MyAssert
    extends RuntimeException {
        private static final long serialVersionUID = -4415279469780082174L;
        final String _s;

        MyAssert(String s2) {
            super(s2);
            this._s = s2;
        }

        public String toString() {
            return this._s;
        }
    }
}

