/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMRecordCodec;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordComparator;
import htsjdk.samtools.SAMRecordCoordinateComparator;
import htsjdk.samtools.SAMRecordQueryNameComparator;
import htsjdk.samtools.SAMSortOrderChecker;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.util.ProgressLoggerInterface;
import htsjdk.samtools.util.SortingCollection;
import java.io.File;
import java.io.StringWriter;

public abstract class SAMFileWriterImpl
implements SAMFileWriter {
    private static int DEAFULT_MAX_RECORDS_IN_RAM = 500000;
    private int maxRecordsInRam = DEAFULT_MAX_RECORDS_IN_RAM;
    private SAMFileHeader.SortOrder sortOrder;
    private SAMFileHeader header;
    private SortingCollection<SAMRecord> alignmentSorter;
    private File tmpDir = new File(System.getProperty("java.io.tmpdir"));
    private ProgressLoggerInterface progressLogger = null;
    private boolean isClosed = false;
    private boolean presorted;
    private SAMSortOrderChecker sortOrderChecker;

    public static void setDefaultMaxRecordsInRam(int maxRecordsInRam) {
        DEAFULT_MAX_RECORDS_IN_RAM = maxRecordsInRam;
    }

    public static int getDefaultMaxRecordsInRam() {
        return DEAFULT_MAX_RECORDS_IN_RAM;
    }

    @Override
    public void setProgressLogger(ProgressLoggerInterface progress) {
        this.progressLogger = progress;
    }

    public void setSortOrder(SAMFileHeader.SortOrder sortOrder, boolean presorted) {
        if (this.header != null) {
            throw new IllegalStateException("Cannot call SAMFileWriterImpl.setSortOrder after setHeader for " + this.getFilename());
        }
        this.sortOrder = sortOrder;
        this.presorted = presorted;
    }

    protected SAMFileHeader.SortOrder getSortOrder() {
        return this.sortOrder;
    }

    void setMaxRecordsInRam(int maxRecordsInRam) {
        if (this.header != null) {
            throw new IllegalStateException("setMaxRecordsInRam must be called before setHeader()");
        }
        this.maxRecordsInRam = maxRecordsInRam;
    }

    void setTempDirectory(File tmpDir) {
        if (tmpDir != null) {
            this.tmpDir = tmpDir;
        }
    }

    public void setHeader(SAMFileHeader header) {
        this.header = header;
        if (this.sortOrder == null) {
            this.sortOrder = SAMFileHeader.SortOrder.unsorted;
        }
        header.setSortOrder(this.sortOrder);
        StringWriter headerTextBuffer = new StringWriter();
        new SAMTextHeaderCodec().encode(headerTextBuffer, header);
        String headerText = headerTextBuffer.toString();
        this.writeHeader(headerText);
        if (this.presorted) {
            if (this.sortOrder.equals((Object)SAMFileHeader.SortOrder.unsorted)) {
                this.presorted = false;
            } else {
                this.sortOrderChecker = new SAMSortOrderChecker(this.sortOrder);
            }
        } else if (!this.sortOrder.equals((Object)SAMFileHeader.SortOrder.unsorted)) {
            this.alignmentSorter = SortingCollection.newInstance(SAMRecord.class, new BAMRecordCodec(header), this.makeComparator(), this.maxRecordsInRam, this.tmpDir);
        }
    }

    @Override
    public SAMFileHeader getFileHeader() {
        return this.header;
    }

    private SAMRecordComparator makeComparator() {
        switch (this.sortOrder) {
            case coordinate: {
                return new SAMRecordCoordinateComparator();
            }
            case queryname: {
                return new SAMRecordQueryNameComparator();
            }
            case unsorted: {
                return null;
            }
        }
        throw new IllegalStateException("sortOrder should not be null");
    }

    @Override
    public void addAlignment(SAMRecord alignment) {
        if (this.sortOrder.equals((Object)SAMFileHeader.SortOrder.unsorted)) {
            if (!this.header.getGroupOrder().equals((Object)SAMFileHeader.GroupOrder.none)) {
                throw new UnsupportedOperationException("GroupOrder " + (Object)((Object)this.header.getGroupOrder()) + " is not supported");
            }
            this.writeAlignment(alignment);
        } else if (this.presorted) {
            this.assertPresorted(alignment);
            this.writeAlignment(alignment);
        } else {
            this.alignmentSorter.add(alignment);
        }
    }

    private void assertPresorted(SAMRecord alignment) {
        SAMRecord prev = this.sortOrderChecker.getPreviousRecord();
        if (!this.sortOrderChecker.isSorted(alignment)) {
            throw new IllegalArgumentException("Alignments added out of order in SAMFileWriterImpl.addAlignment for " + this.getFilename() + ". Sort order is " + (Object)((Object)this.sortOrder) + ". Offending records are at [" + this.sortOrderChecker.getSortKey(prev) + "] and [" + this.sortOrderChecker.getSortKey(alignment) + "]");
        }
    }

    @Override
    public final void close() {
        if (!this.isClosed) {
            if (this.alignmentSorter != null) {
                for (SAMRecord alignment : this.alignmentSorter) {
                    this.writeAlignment(alignment);
                    if (this.progressLogger == null) continue;
                    this.progressLogger.record(alignment);
                }
                this.alignmentSorter.cleanup();
            }
            this.finish();
        }
        this.isClosed = true;
    }

    protected abstract void writeAlignment(SAMRecord var1);

    protected abstract void writeHeader(String var1);

    protected abstract void finish();

    protected abstract String getFilename();
}

