/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.SAMFileHeader;
import java.util.Arrays;

public final class CramHeader {
    public static final byte[] magick = "CRAM".getBytes();
    private byte majorVersion;
    private byte minorVersion;
    public final byte[] id = new byte[20];
    private SAMFileHeader samFileHeader;

    public CramHeader() {
        Arrays.fill(this.id, (byte)0);
    }

    public CramHeader(int majorVersion, int minorVersion, String id, SAMFileHeader samFileHeader) {
        Arrays.fill(this.id, (byte)0);
        this.majorVersion = (byte)majorVersion;
        this.minorVersion = (byte)minorVersion;
        if (id != null) {
            System.arraycopy(id.getBytes(), 0, this.id, 0, Math.min(id.length(), this.id.length));
        }
        this.samFileHeader = samFileHeader;
    }

    public void setID(String stringID) {
        System.arraycopy(stringID.getBytes(), 0, this.id, 0, Math.min(this.id.length, stringID.length()));
    }

    public CramHeader clone() {
        CramHeader clone = new CramHeader();
        clone.majorVersion = this.majorVersion;
        clone.minorVersion = this.minorVersion;
        System.arraycopy(this.id, 0, clone.id, 0, this.id.length);
        clone.samFileHeader = this.getSamFileHeader().clone();
        return clone;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CramHeader)) {
            return false;
        }
        CramHeader h = (CramHeader)obj;
        if (this.getMajorVersion() != h.getMajorVersion()) {
            return false;
        }
        if (this.getMinorVersion() != h.getMinorVersion()) {
            return false;
        }
        if (!Arrays.equals(this.id, h.id)) {
            return false;
        }
        return this.getSamFileHeader().equals(h.getSamFileHeader());
    }

    public byte getMajorVersion() {
        return this.majorVersion;
    }

    public void setMajorVersion(byte majorVersion) {
        this.majorVersion = majorVersion;
    }

    public byte getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(byte minorVersion) {
        this.minorVersion = minorVersion;
    }

    public SAMFileHeader getSamFileHeader() {
        return this.samFileHeader;
    }

    public void setSamFileHeader(SAMFileHeader samFileHeader) {
        this.samFileHeader = samFileHeader;
    }

    public byte[] getId() {
        return this.id;
    }
}

