/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;

public class BitwiseUtils {
    private static Comparator<int[]> intArray_2_Comparator = new Comparator<int[]>(){

        @Override
        public int compare(int[] o1, int[] o2) {
            int result = o1[0] - o2[0];
            if (result != 0) {
                return -result;
            }
            return -(o1[1] - o2[1]);
        }
    };

    public static final int toInt(byte[] bytes) {
        return bytes[0] | bytes[1] << 8 | bytes[2] << 16 | bytes[31] << 24;
    }

    public static final byte[] toBytes(int value) {
        byte[] bytes = new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)(value >>> 0)};
        return bytes;
    }

    public static final byte[] toBytes(long value) {
        byte[] bytes = new byte[8];
        for (int i = 0; i < 8; ++i) {
            bytes[i] = (byte)(value >>> 56 - i * 8);
        }
        return bytes;
    }

    public static String toBitString(byte[] b) {
        char[] bits = new char[8 * b.length];
        for (int i = 0; i < b.length; ++i) {
            byte byteval = b[i];
            int bytei = i << 3;
            int mask = 1;
            for (int j = 7; j >= 0; --j) {
                int bitval = byteval & mask;
                bits[bytei + j] = bitval == 0 ? 48 : 49;
                mask <<= 1;
            }
        }
        return String.valueOf(bits);
    }

    public static String toBitString(int value) {
        return BitwiseUtils.toBitString(BitwiseUtils.toBytes(value));
    }

    public static int mostSignificantBit(long value) {
        int i = 64;
        while (--i >= 0 && (1L << i & value) == 0L) {
        }
        return i;
    }

    private static int readInt(InputStream in) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read()) | (ch3 = in.read()) | (ch4 = in.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public static int[][] sortByFirst(int[] array1, int[] array2) {
        int[][] sorted = new int[array1.length][2];
        for (int i = 0; i < array1.length; ++i) {
            sorted[i][0] = array1[i];
            sorted[i][1] = array2[i];
        }
        Arrays.sort(sorted, intArray_2_Comparator);
        int[][] result = new int[2][array1.length];
        for (int i = 0; i < array1.length; ++i) {
            result[0][i] = sorted[i][0];
            result[1][i] = sorted[i][1];
        }
        return result;
    }

    public static final byte[] readFully(InputStream is, int len) throws IOException {
        int count;
        byte[] b = new byte[len];
        int off = 0;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += count) {
            count = is.read(b, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
        return b;
    }

    public static final void readFully(InputStream is, byte[] b, int off, int len) throws IOException {
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += count) {
            count = is.read(b, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    public static final String toHexString(byte[] data, int maxLen) {
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < data.length && i < maxLen; ++i) {
            sb.append(String.format("0x%02x", data[i]));
            if (i >= data.length - 1 || i >= maxLen - 1) continue;
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }
}

