/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.AbstractBAMFileIndex;
import htsjdk.samtools.BAMIndexContent;
import htsjdk.samtools.BAMIndexMetaData;
import htsjdk.samtools.BAMIndexWriter;
import htsjdk.samtools.Bin;
import htsjdk.samtools.BinaryBAMIndexWriter;
import htsjdk.samtools.CachingBAMFileIndex;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.LinearIndex;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.TextualBAMIndexWriter;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.util.BlockCompressedFilePointerUtil;
import java.io.File;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;

public class CRAMIndexer {
    private final int numReferences;
    private final BAMIndexWriter outputWriter;
    private int currentReference = 0;
    private final BAMIndexBuilder indexBuilder;

    public CRAMIndexer(File output, SAMFileHeader fileHeader) {
        this.numReferences = fileHeader.getSequenceDictionary().size();
        this.indexBuilder = new BAMIndexBuilder(fileHeader);
        this.outputWriter = new BinaryBAMIndexWriter(this.numReferences, output);
    }

    public CRAMIndexer(OutputStream output, SAMFileHeader fileHeader) {
        this.numReferences = fileHeader.getSequenceDictionary().size();
        this.indexBuilder = new BAMIndexBuilder(fileHeader);
        this.outputWriter = new BinaryBAMIndexWriter(this.numReferences, output);
    }

    public void processAlignment(Slice slice) {
        try {
            int reference = slice.sequenceId;
            if (reference != -1 && reference != this.currentReference) {
                this.advanceToReference(reference);
            }
            this.indexBuilder.processAlignment(slice);
        }
        catch (Exception e) {
            throw new SAMException("Exception creating BAM index for record " + slice, e);
        }
    }

    public void finish() {
        this.advanceToReference(this.numReferences);
        this.outputWriter.writeNoCoordinateRecordCount(this.indexBuilder.getNoCoordinateRecordCount());
        this.outputWriter.close();
    }

    private void advanceToReference(int nextReference) {
        while (this.currentReference < nextReference) {
            BAMIndexContent content = this.indexBuilder.processReference(this.currentReference);
            this.outputWriter.writeReference(content);
            ++this.currentReference;
            this.indexBuilder.startNewReference();
        }
    }

    public static void createAndWriteIndex(File input, File output, boolean textOutput) {
        CachingBAMFileIndex existingIndex = new CachingBAMFileIndex(input, null);
        int n_ref = existingIndex.getNumberOfReferences();
        BAMIndexWriter outputWriter = textOutput ? new TextualBAMIndexWriter(n_ref, output) : new BinaryBAMIndexWriter(n_ref, output);
        try {
            for (int i = 0; i < n_ref; ++i) {
                outputWriter.writeReference(existingIndex.getQueryResults(i));
            }
            outputWriter.writeNoCoordinateRecordCount(existingIndex.getNoCoordinateCount());
            outputWriter.close();
        }
        catch (Exception e) {
            throw new SAMException("Exception creating BAM index", e);
        }
    }

    private class BAMIndexBuilder {
        private final SAMFileHeader bamHeader;
        private Bin[] bins;
        private int binsSeen = 0;
        private final long[] index = new long[LinearIndex.MAX_LINEAR_INDEX_SIZE];
        private int largestIndexSeen = -1;
        private BAMIndexMetaData indexStats = new BAMIndexMetaData();

        BAMIndexBuilder(SAMFileHeader header) {
            this.bamHeader = header;
        }

        private int computeIndexingBin(Slice slice) {
            int alignmentEnd = slice.alignmentStart + slice.alignmentSpan - 1;
            int alignmentStart = slice.alignmentStart - 1;
            if (alignmentEnd <= alignmentStart) {
                alignmentEnd = alignmentStart + 1;
            }
            return SAMUtils.reg2bin(alignmentStart, alignmentEnd);
        }

        public void processAlignment(Slice slice) {
            Bin bin;
            this.indexStats.recordMetaData(slice);
            int alignmentStart = slice.alignmentStart;
            if (alignmentStart == 0) {
                return;
            }
            int reference = slice.sequenceId;
            if (reference != CRAMIndexer.this.currentReference) {
                throw new SAMException("Unexpected reference " + reference + " when constructing index for " + CRAMIndexer.this.currentReference + " for record " + slice);
            }
            int binNum = this.computeIndexingBin(slice);
            if (this.bins == null) {
                SAMSequenceRecord seq = this.bamHeader.getSequence(reference);
                this.bins = seq == null ? new Bin[37451] : new Bin[AbstractBAMFileIndex.getMaxBinNumberForSequenceLength(seq.getSequenceLength()) + 1];
            }
            if (this.bins[binNum] != null) {
                bin = this.bins[binNum];
            } else {
                this.bins[binNum] = bin = new Bin(reference, binNum);
                ++this.binsSeen;
            }
            long chunkStart = slice.containerOffset << 16 | (long)slice.index;
            long chunkEnd = (slice.containerOffset << 16 | (long)slice.index) + 1L;
            Chunk newChunk = new Chunk(chunkStart, chunkEnd);
            List<Chunk> oldChunks = bin.getChunkList();
            if (!bin.containsChunks()) {
                bin.addInitialChunk(newChunk);
            } else {
                Chunk lastChunk = bin.getLastChunk();
                if (BlockCompressedFilePointerUtil.areInSameOrAdjacentBlocks(lastChunk.getChunkEnd(), chunkStart)) {
                    lastChunk.setChunkEnd(chunkEnd);
                } else {
                    oldChunks.add(newChunk);
                    bin.setLastChunk(newChunk);
                }
            }
            int alignmentEnd = slice.alignmentStart + slice.alignmentSpan;
            int startWindow = LinearIndex.convertToLinearIndexOffset(alignmentStart);
            int endWindow = alignmentEnd == 0 ? (startWindow = LinearIndex.convertToLinearIndexOffset(alignmentStart - 1)) : LinearIndex.convertToLinearIndexOffset(alignmentEnd);
            if (endWindow > this.largestIndexSeen) {
                this.largestIndexSeen = endWindow;
            }
            for (int win = startWindow; win <= endWindow; ++win) {
                if (this.index[win] != 0L && chunkStart >= this.index[win]) continue;
                this.index[win] = chunkStart;
            }
        }

        public BAMIndexContent processReference(int reference) {
            if (reference != CRAMIndexer.this.currentReference) {
                throw new SAMException("Unexpected reference " + reference + " when constructing index for " + CRAMIndexer.this.currentReference);
            }
            if (this.binsSeen == 0) {
                return null;
            }
            long[] newIndex = new long[this.largestIndexSeen + 1];
            long lastNonZeroOffset = 0L;
            for (int i = 0; i <= this.largestIndexSeen; ++i) {
                if (this.index[i] == 0L) {
                    this.index[i] = lastNonZeroOffset;
                } else {
                    lastNonZeroOffset = this.index[i];
                }
                newIndex[i] = this.index[i];
            }
            LinearIndex linearIndex = new LinearIndex(reference, 0, newIndex);
            return new BAMIndexContent(reference, this.bins, this.binsSeen, this.indexStats, linearIndex);
        }

        public long getNoCoordinateRecordCount() {
            return this.indexStats.getNoCoordinateRecordCount();
        }

        void startNewReference() {
            this.bins = null;
            if (this.binsSeen > 0) {
                Arrays.fill(this.index, 0L);
            }
            this.binsSeen = 0;
            this.largestIndexSeen = -1;
            this.indexStats.newReference();
        }
    }
}

