/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oci.OracleOCIConnection;
import oracle.jdbc.pool.OracleDataSource;

public class OracleOCIConnectionPool
extends OracleDataSource {
    public OracleOCIConnection m_connection_pool;
    public static final String IS_CONNECTION_POOLING = "is_connection_pooling";
    private int m_conn_min_limit = 0;
    private int m_conn_max_limit = 0;
    private int m_conn_increment = 0;
    private int m_conn_active_size = 0;
    private int m_conn_pool_size = 0;
    private int m_conn_timeout = 0;
    private String m_conn_nowait = "false";
    private int m_is_transactions_distributed = 0;
    public static final String CONNPOOL_OBJECT = "connpool_object";
    public static final String CONNPOOL_LOGON_MODE = "connection_pool";
    public static final String CONNECTION_POOL = "connection_pool";
    public static final String CONNPOOL_CONNECTION = "connpool_connection";
    public static final String CONNPOOL_PROXY_CONNECTION = "connpool_proxy_connection";
    public static final String CONNPOOL_ALIASED_CONNECTION = "connpool_alias_connection";
    public static final String PROXY_USER_NAME = "proxy_user_name";
    public static final String PROXY_DISTINGUISHED_NAME = "proxy_distinguished_name";
    public static final String PROXY_CERTIFICATE = "proxy_certificate";
    public static final String PROXY_ROLES = "proxy_roles";
    public static final String PROXY_NUM_ROLES = "proxy_num_roles";
    public static final String PROXY_PASSWORD = "proxy_password";
    public static final String PROXYTYPE = "proxytype";
    public static final String PROXYTYPE_USER_NAME = "proxytype_user_name";
    public static final String PROXYTYPE_DISTINGUISHED_NAME = "proxytype_distinguished_name";
    public static final String PROXYTYPE_CERTIFICATE = "proxytype_certificate";
    public static final String CONNECTION_ID = "connection_id";
    public static final String CONNPOOL_MIN_LIMIT = "connpool_min_limit";
    public static final String CONNPOOL_MAX_LIMIT = "connpool_max_limit";
    public static final String CONNPOOL_INCREMENT = "connpool_increment";
    public static final String CONNPOOL_ACTIVE_SIZE = "connpool_active_size";
    public static final String CONNPOOL_POOL_SIZE = "connpool_pool_size";
    public static final String CONNPOOL_TIMEOUT = "connpool_timeout";
    public static final String CONNPOOL_NOWAIT = "connpool_nowait";
    public static final String CONNPOOL_IS_POOLCREATED = "connpool_is_poolcreated";
    public static final String TRANSACTIONS_DISTRIBUTED = "transactions_distributed";
    private Hashtable m_lconnections = null;
    private Lifecycle lifecycle = Lifecycle.NEW;
    private OracleDriver m_oracleDriver = new OracleDriver();
    protected int m_stmtCacheSize = 0;
    protected boolean m_stmtClearMetaData = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
    public static final boolean TRACE = false;

    private void ensureOpen() throws SQLException {
        if (this.lifecycle == Lifecycle.NEW) {
            this.createConnectionPool(null);
        }
        if (this.lifecycle != Lifecycle.OPEN) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    public OracleOCIConnectionPool(String string, String string2, String string3, Properties properties) throws SQLException {
        this();
        this.setURL(string3);
        this.setUser(string);
        this.setPassword(string2);
        this.createConnectionPool(properties);
    }

    public OracleOCIConnectionPool(String string, String string2, String string3) throws SQLException {
        this();
        this.setURL(string3);
        this.setUser(string);
        this.setPassword(string2);
        this.createConnectionPool(null);
    }

    public OracleOCIConnectionPool() throws SQLException {
        this.isOracleDataSource = false;
        this.m_lconnections = new Hashtable(10);
        this.setDriverType("oci8");
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        this.ensureOpen();
        Connection connection = this.getConnection(this.user, this.password);
        return connection;
    }

    @Override
    public synchronized Connection getConnection(String string, String string2) throws SQLException {
        this.ensureOpen();
        Properties properties = this.connectionProperties != null ? new Properties(this.connectionProperties) : new Properties();
        properties.put(IS_CONNECTION_POOLING, "true");
        properties.put("user", string);
        properties.put("password", string2);
        properties.put("connection_pool", CONNPOOL_CONNECTION);
        properties.put(CONNPOOL_OBJECT, this.m_connection_pool);
        OracleOCIConnection oracleOCIConnection = (OracleOCIConnection)this.m_oracleDriver.connect(this.url, properties);
        if (oracleOCIConnection == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 67);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        oracleOCIConnection.setStmtCacheSize(this.m_stmtCacheSize, this.m_stmtClearMetaData);
        this.m_lconnections.put(oracleOCIConnection, oracleOCIConnection);
        oracleOCIConnection.setConnectionPool(this);
        return oracleOCIConnection;
    }

    @Override
    public synchronized Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), "oracle.jdbc.pool.OracleDataSourceFactory", null);
        super.addRefProperties(reference);
        reference.add(new StringRefAddr(CONNPOOL_MIN_LIMIT, String.valueOf(this.m_conn_min_limit)));
        reference.add(new StringRefAddr(CONNPOOL_MAX_LIMIT, String.valueOf(this.m_conn_max_limit)));
        reference.add(new StringRefAddr(CONNPOOL_INCREMENT, String.valueOf(this.m_conn_increment)));
        reference.add(new StringRefAddr(CONNPOOL_ACTIVE_SIZE, String.valueOf(this.m_conn_active_size)));
        reference.add(new StringRefAddr(CONNPOOL_POOL_SIZE, String.valueOf(this.m_conn_pool_size)));
        reference.add(new StringRefAddr(CONNPOOL_TIMEOUT, String.valueOf(this.m_conn_timeout)));
        reference.add(new StringRefAddr(CONNPOOL_NOWAIT, this.m_conn_nowait));
        reference.add(new StringRefAddr(CONNPOOL_IS_POOLCREATED, String.valueOf(this.isPoolCreated())));
        reference.add(new StringRefAddr(TRANSACTIONS_DISTRIBUTED, String.valueOf(this.isDistributedTransEnabled())));
        return reference;
    }

    public synchronized OracleConnection getProxyConnection(String string, Properties properties) throws SQLException {
        this.ensureOpen();
        if (PROXYTYPE_USER_NAME.equals(string)) {
            properties.put("user", properties.getProperty(PROXY_USER_NAME));
        } else if (PROXYTYPE_DISTINGUISHED_NAME.equals(string)) {
            properties.put("user", properties.getProperty(PROXY_DISTINGUISHED_NAME));
        } else if (PROXYTYPE_CERTIFICATE.equals(string)) {
            properties.put("user", String.valueOf(properties.getProperty(PROXY_USER_NAME)));
        } else {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 107, "null properties");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        properties.put(IS_CONNECTION_POOLING, "true");
        properties.put(PROXYTYPE, string);
        String[] stringArray = (String[])properties.get(PROXY_ROLES);
        if (stringArray != null) {
            properties.put(PROXY_NUM_ROLES, new Integer(stringArray.length));
        } else {
            properties.put(PROXY_NUM_ROLES, new Integer(0));
        }
        properties.put("connection_pool", CONNPOOL_PROXY_CONNECTION);
        properties.put(CONNPOOL_OBJECT, this.m_connection_pool);
        OracleOCIConnection oracleOCIConnection = (OracleOCIConnection)this.m_oracleDriver.connect(this.url, properties);
        if (oracleOCIConnection == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 67);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        oracleOCIConnection.setStmtCacheSize(this.m_stmtCacheSize, this.m_stmtClearMetaData);
        this.m_lconnections.put(oracleOCIConnection, oracleOCIConnection);
        oracleOCIConnection.setConnectionPool(this);
        return oracleOCIConnection;
    }

    public synchronized OracleConnection getAliasedConnection(byte[] byArray) throws SQLException {
        this.ensureOpen();
        Properties properties = new Properties();
        properties.put(IS_CONNECTION_POOLING, "true");
        properties.put(CONNECTION_ID, byArray);
        properties.put("connection_pool", CONNPOOL_ALIASED_CONNECTION);
        properties.put(CONNPOOL_OBJECT, this.m_connection_pool);
        OracleOCIConnection oracleOCIConnection = (OracleOCIConnection)this.m_oracleDriver.connect(this.url, properties);
        if (oracleOCIConnection == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 67);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        oracleOCIConnection.setStmtCacheSize(this.m_stmtCacheSize, this.m_stmtClearMetaData);
        this.m_lconnections.put(oracleOCIConnection, oracleOCIConnection);
        oracleOCIConnection.setConnectionPool(this);
        return oracleOCIConnection;
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.lifecycle != Lifecycle.OPEN) {
            return;
        }
        this.lifecycle = Lifecycle.CLOSING;
        Iterator iterator = this.m_lconnections.values().iterator();
        while (iterator.hasNext()) {
            OracleOCIConnection oracleOCIConnection = (OracleOCIConnection)iterator.next();
            if (oracleOCIConnection != null && oracleOCIConnection != this.m_connection_pool) {
                oracleOCIConnection.close();
            }
            iterator.remove();
        }
        this.m_connection_pool.close();
        this.lifecycle = Lifecycle.CLOSED;
    }

    public synchronized void setPoolConfig(Properties properties) throws SQLException {
        if (properties == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 106, "null properties");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (!this.isPoolCreated()) {
            this.createConnectionPool(properties);
        } else {
            Properties properties2 = new Properties();
            this.checkPoolConfig(properties, properties2);
            int[] nArray = new int[6];
            OracleOCIConnectionPool.readPoolConfig(properties2, nArray);
            this.m_connection_pool.setConnectionPoolInfo(nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5]);
        }
        this.storePoolProperties();
    }

    public static void readPoolConfig(int n2, int n3, int n4, int n5, boolean bl, boolean bl2, int[] nArray) {
        for (int i2 = 0; i2 < 6; ++i2) {
            nArray[i2] = 0;
        }
        nArray[0] = n2;
        nArray[1] = n3;
        nArray[2] = n4;
        nArray[3] = n5;
        if (bl) {
            nArray[4] = 1;
        }
        if (bl2) {
            nArray[5] = 1;
        }
    }

    public static void readPoolConfig(Properties properties, int[] nArray) {
        String string = properties.getProperty(CONNPOOL_MIN_LIMIT);
        if (string != null) {
            nArray[0] = Integer.parseInt(string);
        }
        if ((string = properties.getProperty(CONNPOOL_MAX_LIMIT)) != null) {
            nArray[1] = Integer.parseInt(string);
        }
        if ((string = properties.getProperty(CONNPOOL_INCREMENT)) != null) {
            nArray[2] = Integer.parseInt(string);
        }
        if ((string = properties.getProperty(CONNPOOL_TIMEOUT)) != null) {
            nArray[3] = Integer.parseInt(string);
        }
        if ((string = properties.getProperty(CONNPOOL_NOWAIT)) != null && string.equalsIgnoreCase("true")) {
            nArray[4] = 1;
        }
        if ((string = properties.getProperty(TRANSACTIONS_DISTRIBUTED)) != null && string.equalsIgnoreCase("true")) {
            nArray[5] = 1;
        }
    }

    private void checkPoolConfig(Properties properties, Properties properties2) throws SQLException {
        String string = (String)properties.get(TRANSACTIONS_DISTRIBUTED);
        String string2 = (String)properties.get(CONNPOOL_NOWAIT);
        if (string != null && !string.equalsIgnoreCase("true") || string2 != null && !string2.equalsIgnoreCase("true") || properties.get(CONNPOOL_MIN_LIMIT) == null || properties.get(CONNPOOL_MAX_LIMIT) == null || properties.get(CONNPOOL_INCREMENT) == null || Integer.decode((String)properties.get(CONNPOOL_MIN_LIMIT)) < 0 || Integer.decode((String)properties.get(CONNPOOL_MAX_LIMIT)) < 0 || Integer.decode((String)properties.get(CONNPOOL_INCREMENT)) < 0) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 106, "");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            String string4 = properties.getProperty(string3);
            if (TRANSACTIONS_DISTRIBUTED.equals(string3) || CONNPOOL_NOWAIT.equals(string3)) {
                properties2.put(string3, "true");
                continue;
            }
            properties2.put(string3, string4);
        }
    }

    private synchronized void storePoolProperties() throws SQLException {
        Properties properties = this.getPoolConfig();
        this.m_conn_min_limit = Integer.decode(properties.getProperty(CONNPOOL_MIN_LIMIT));
        this.m_conn_max_limit = Integer.decode(properties.getProperty(CONNPOOL_MAX_LIMIT));
        this.m_conn_increment = Integer.decode(properties.getProperty(CONNPOOL_INCREMENT));
        this.m_conn_active_size = Integer.decode(properties.getProperty(CONNPOOL_ACTIVE_SIZE));
        this.m_conn_pool_size = Integer.decode(properties.getProperty(CONNPOOL_POOL_SIZE));
        this.m_conn_timeout = Integer.decode(properties.getProperty(CONNPOOL_TIMEOUT));
        this.m_conn_nowait = properties.getProperty(CONNPOOL_NOWAIT);
    }

    public synchronized Properties getPoolConfig() throws SQLException {
        this.ensureOpen();
        Properties properties = this.m_connection_pool.getConnectionPoolInfo();
        properties.put(CONNPOOL_IS_POOLCREATED, String.valueOf(this.isPoolCreated()));
        return properties;
    }

    public synchronized int getActiveSize() throws SQLException {
        this.ensureOpen();
        Properties properties = this.m_connection_pool.getConnectionPoolInfo();
        String string = properties.getProperty(CONNPOOL_ACTIVE_SIZE);
        int n2 = Integer.decode(string);
        return n2;
    }

    public synchronized int getPoolSize() throws SQLException {
        this.ensureOpen();
        Properties properties = this.m_connection_pool.getConnectionPoolInfo();
        String string = properties.getProperty(CONNPOOL_POOL_SIZE);
        int n2 = Integer.decode(string);
        return n2;
    }

    public synchronized int getTimeout() throws SQLException {
        this.ensureOpen();
        Properties properties = this.m_connection_pool.getConnectionPoolInfo();
        String string = properties.getProperty(CONNPOOL_TIMEOUT);
        int n2 = Integer.decode(string);
        return n2;
    }

    public synchronized String getNoWait() throws SQLException {
        this.ensureOpen();
        Properties properties = this.m_connection_pool.getConnectionPoolInfo();
        return properties.getProperty(CONNPOOL_NOWAIT);
    }

    public synchronized int getMinLimit() throws SQLException {
        this.ensureOpen();
        Properties properties = this.m_connection_pool.getConnectionPoolInfo();
        String string = properties.getProperty(CONNPOOL_MIN_LIMIT);
        int n2 = Integer.decode(string);
        return n2;
    }

    public synchronized int getMaxLimit() throws SQLException {
        this.ensureOpen();
        Properties properties = this.m_connection_pool.getConnectionPoolInfo();
        String string = properties.getProperty(CONNPOOL_MAX_LIMIT);
        int n2 = Integer.decode(string);
        return n2;
    }

    public synchronized int getConnectionIncrement() throws SQLException {
        this.ensureOpen();
        Properties properties = this.m_connection_pool.getConnectionPoolInfo();
        String string = properties.getProperty(CONNPOOL_INCREMENT);
        int n2 = Integer.decode(string);
        return n2;
    }

    public synchronized boolean isDistributedTransEnabled() {
        return this.m_is_transactions_distributed == 1;
    }

    private void createConnectionPool(Properties properties) throws SQLException {
        if (this.lifecycle != Lifecycle.NEW) {
            return;
        }
        if (this.user == null || this.password == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 106, " ");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Properties properties2 = new Properties();
        if (properties != null) {
            this.checkPoolConfig(properties, properties2);
        }
        properties2.put(IS_CONNECTION_POOLING, "true");
        properties2.put("user", this.user);
        properties2.put("password", this.password);
        properties2.put("connection_pool", "connection_pool");
        if (this.getURL() == null) {
            this.makeURL();
        }
        this.m_connection_pool = (OracleOCIConnection)this.m_oracleDriver.connect(this.url, properties2);
        if (this.m_connection_pool == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 67);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.m_connection_pool.setConnectionPool(this);
        this.m_lconnections.put(this.m_connection_pool, this.m_connection_pool);
        this.lifecycle = Lifecycle.OPEN;
        this.storePoolProperties();
        if (properties != null && "true".equalsIgnoreCase(properties.getProperty(TRANSACTIONS_DISTRIBUTED))) {
            this.m_is_transactions_distributed = 1;
        }
    }

    public synchronized boolean isPoolCreated() {
        return this.lifecycle == Lifecycle.OPEN;
    }

    public synchronized void connectionClosed(OracleOCIConnection oracleOCIConnection) throws SQLException {
        if (this.lifecycle != Lifecycle.CLOSING && this.m_lconnections.remove(oracleOCIConnection) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "internal OracleOCIConnectionPool error");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    public synchronized void setStmtCacheSize(int n2) throws SQLException {
        this.setStmtCacheSize(n2, false);
    }

    public synchronized void setStmtCacheSize(int n2, boolean bl) throws SQLException {
        if (n2 < 0) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.m_stmtCacheSize = n2;
        this.m_stmtClearMetaData = bl;
    }

    public synchronized int getStmtCacheSize() {
        return this.m_stmtCacheSize;
    }

    public synchronized boolean isStmtCacheEnabled() {
        return this.m_stmtCacheSize > 0;
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    private static enum Lifecycle {
        NEW,
        OPEN,
        CLOSING,
        CLOSED;

    }
}

