/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import htsjdk.samtools.cram.io.DefaultBitOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class ArithCodec1
extends AbstractBitCodec<byte[]> {
    private byte curBit = 0;
    private int curByte = 0;
    private double min = 0.0;
    private double max = 1.0;
    private double localMin = 0.0;
    private double localMax = 1.0;
    private long bitCount;
    private ByteArrayOutputStream baos;
    private ArrayList<Integer> fileData;
    private int previous;
    private double[][] freq;

    public ArithCodec1(int[] freqs, byte[][] map) {
        int i;
        long[] count = new long[257];
        this.freq = new double[257][256];
        for (i = 0; i < 256; ++i) {
            this.freq[256][i] = 1.0;
            count[256] = count[256] + 1L;
        }
        for (i = 0; i < freqs.length; ++i) {
            int x = map[i].length > 1 ? map[i][0] : 256;
            byte y = map[i].length > 1 ? map[i][1] : map[i][0];
            this.freq[x][y] = freqs[i];
            int n = x;
            count[n] = count[n] + (long)freqs[i];
        }
        for (int x = 0; x < this.freq.length; ++x) {
            double accum = 0.0;
            for (int y = 0; y < this.freq[x].length; ++y) {
                if (count[x] <= 0L) continue;
                this.freq[x][y] = accum += this.freq[x][y] / (double)count[x];
            }
            if (this.freq[x][this.freq[x].length - 1] == 1.0) continue;
            this.freq[x][this.freq[x].length - 1] = 1.0;
        }
        this.baos = new ByteArrayOutputStream();
        this.fileData = new ArrayList();
        this.previous = 256;
    }

    private Byte readByte(BitInputStream bis) throws IOException {
        this.baos.reset();
        this.fileData.clear();
        this.curBit = 0;
        this.curByte = 0;
        this.min = 0.0;
        this.max = 1.0;
        this.localMin = 0.0;
        this.localMax = 1.0;
        this.previous = 256;
        int read = this.decodeCharacter(bis);
        this.baos.write(read);
        this.previous = read;
        return (byte)read;
    }

    @Override
    public byte[] read(BitInputStream bis, int length) throws IOException {
        this.baos.reset();
        this.fileData.clear();
        this.curBit = 0;
        this.curByte = 0;
        this.min = 0.0;
        this.max = 1.0;
        this.localMin = 0.0;
        this.localMax = 1.0;
        this.previous = 256;
        for (int i = 0; i < length; ++i) {
            int read = this.decodeCharacter(bis);
            this.baos.write(read);
            this.previous = read;
        }
        System.out.println(this.fileData.size());
        System.out.println(this.curByte);
        System.out.println(this.curBit);
        int nofBits = 8 - this.curBit;
        System.out.println(nofBits);
        int bits = this.fileData.get(this.fileData.size() - 1);
        bis.putBack(this.curBit, bits >> this.curBit & (1 << nofBits) - 1);
        return this.baos.toByteArray();
    }

    public int decodeCharacter(BitInputStream bis) throws IOException {
        double cur;
        double tempMin = this.min;
        double tempMax = this.max;
        byte tempBit = this.curBit;
        int tempByte = this.curByte;
        int val = 256;
        if (this.fileData.isEmpty()) {
            this.fileData.add(bis.readBits(8));
        }
        double[] probs = this.freq[this.previous];
        while (true) {
            cur = (this.min + this.max) / 2.0;
            val = -1;
            for (int i = 0; i < probs.length; ++i) {
                if (!(probs[i] > this.min)) continue;
                if (!(probs[i] > this.max)) break;
                val = i;
                break;
            }
            if (val != -1) break;
            boolean bit = false;
            if ((this.fileData.get(this.curByte) & 128 >> this.curBit) != 0) {
                bit = true;
            }
            if (bit) {
                this.min = cur;
            } else {
                this.max = cur;
            }
            this.curBit = (byte)(this.curBit + 1);
            if (this.curBit != 8) continue;
            this.curBit = 0;
            ++this.curByte;
            if (this.curByte <= this.fileData.size() - 1) continue;
            try {
                this.fileData.add(bis.readBits(8));
            }
            catch (Throwable t) {
                this.fileData.add(0);
            }
        }
        this.min = tempMin;
        this.max = tempMax;
        this.curBit = tempBit;
        this.curByte = tempByte;
        while (true) {
            int temp;
            cur = (this.min + this.max) / 2.0;
            for (temp = 0; temp < probs.length && !(probs[temp] > cur); ++temp) {
            }
            if (cur < 0.0 || cur > 1.0) {
                temp = -1;
            }
            if (temp == val) break;
            boolean bit = false;
            if ((this.fileData.get(this.curByte) & 128 >> this.curBit) != 0) {
                bit = true;
            }
            if (bit) {
                this.min = cur;
            } else {
                this.max = cur;
            }
            this.curBit = (byte)(this.curBit + 1);
            if (this.curBit != 8) continue;
            this.curBit = 0;
            ++this.curByte;
            if (this.curByte <= this.fileData.size() - 1) continue;
            try {
                this.fileData.add(bis.readBits(8));
            }
            catch (Throwable t) {
                this.fileData.add(0);
            }
        }
        tempMin = 0.0;
        if (val > 0) {
            tempMin = probs[val - 1];
        }
        double factor = 1.0 / (probs[val] - tempMin);
        this.min = factor * (this.min - tempMin);
        this.max = factor * (this.max - tempMin);
        return val;
    }

    @Override
    public long write(BitOutputStream bos, byte[] object) throws IOException {
        this.baos.reset();
        this.curBit = 0;
        this.curByte = 0;
        this.min = 0.0;
        this.max = 1.0;
        this.localMin = 0.0;
        this.localMax = 1.0;
        this.bitCount = 0L;
        this.previous = 256;
        try {
            for (int i = 0; i < object.length; ++i) {
                this.encodeCharacter(bos, object[i] & 0xFF);
                this.previous = object[i] & 0xFF;
            }
            this.flush(bos);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return this.bitCount;
    }

    private void encodeCharacter(BitOutputStream bos, int character) throws Exception {
        double[] prbs = this.freq[this.previous];
        if (prbs.length < 2 || prbs[prbs.length - 1] != 1.0 || character < 0 || character >= prbs.length) {
            throw new Exception("Invalid input");
        }
        this.localMin = character > 0 ? prbs[character - 1] : 0.0;
        this.localMax = prbs[character];
        while (true) {
            double cur;
            if ((cur = (this.min + this.max) / 2.0) < this.localMin) {
                this.curByte |= 128 >> this.curBit;
                this.curBit = (byte)(this.curBit + 1);
                if (this.curBit == 8) {
                    bos.write(this.curByte, 8);
                    this.curByte = 0;
                    this.curBit = 0;
                    this.bitCount += 8L;
                }
                this.min = cur;
                continue;
            }
            if (!(cur >= this.localMax)) break;
            this.curBit = (byte)(this.curBit + 1);
            if (this.curBit == 8) {
                bos.write(this.curByte, 8);
                this.curByte = 0;
                this.curBit = 0;
                this.bitCount += 8L;
            }
            this.max = cur;
        }
        double factor = 1.0 / (this.localMax - this.localMin);
        this.min = factor * (this.min - this.localMin);
        this.max = factor * (this.max - this.localMin);
    }

    private void flush(BitOutputStream bos) throws IOException {
        if (this.curBit != 0) {
            while (true) {
                double mid;
                double cur;
                if ((cur = (this.min + this.max) / 2.0) < (mid = (this.localMin + this.localMax) / 2.0)) {
                    this.curByte |= 128 >> this.curBit;
                    this.min = cur;
                } else {
                    this.max = cur;
                }
                this.curBit = (byte)(this.curBit + 1);
                if (this.curBit != 8) continue;
                bos.write(this.curByte, 8);
                this.curByte = 0;
                this.curBit = 0;
                this.bitCount += 8L;
                cur = (this.min + this.max) / 2.0;
                if (cur >= this.localMin && cur < this.localMax) break;
            }
        }
        bos.close();
    }

    @Override
    public long numberOfBits(byte[] object) {
        NullOutputStream baos = new NullOutputStream();
        DefaultBitOutputStream nBos = new DefaultBitOutputStream(baos);
        this.baos.reset();
        this.curBit = 0;
        this.curByte = 0;
        this.min = 0.0;
        this.max = 1.0;
        this.localMin = 0.0;
        this.localMax = 1.0;
        this.bitCount = 0L;
        this.previous = 256;
        try {
            for (int i = 0; i < object.length; ++i) {
                this.encodeCharacter(nBos, object[i] & 0xFF);
                this.previous = object[i];
            }
            this.flush(nBos);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return this.bitCount;
    }

    @Override
    public byte[] read(BitInputStream bis) throws IOException {
        return null;
    }

    private class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }
}

