/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.encoding.GammaIntegerCodec;
import htsjdk.samtools.cram.io.ByteBufferUtils;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.EncodingParams;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public class GammaIntegerEncoding
implements Encoding<Integer> {
    public static final EncodingID ENCODING_ID = EncodingID.GAMMA;
    private int offset;

    public GammaIntegerEncoding() {
        this(0);
    }

    public GammaIntegerEncoding(int offset) {
        this.offset = offset;
    }

    @Override
    public EncodingID id() {
        return ENCODING_ID;
    }

    public static EncodingParams toParam(int offset) {
        GammaIntegerEncoding e = new GammaIntegerEncoding();
        e.offset = offset;
        return new EncodingParams(ENCODING_ID, e.toByteArray());
    }

    @Override
    public byte[] toByteArray() {
        ByteBuffer buf = ByteBuffer.allocate(10);
        ByteBufferUtils.writeUnsignedITF8(this.offset, buf);
        buf.flip();
        byte[] array = new byte[buf.limit()];
        buf.get(array);
        return array;
    }

    @Override
    public void fromByteArray(byte[] data) {
        this.offset = ByteBufferUtils.readUnsignedITF8(data);
    }

    @Override
    public BitCodec<Integer> buildCodec(Map<Integer, InputStream> inputMap, Map<Integer, ExposedByteArrayOutputStream> outputMap) {
        return new GammaIntegerCodec(this.offset);
    }
}

