/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.SpliceJunctionFeature;
import org.broad.igv.feature.Strand;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.SpliceJunctionFinderTrack;

public class SpliceJunctionHelper {
    static Logger log = Logger.getLogger(SpliceJunctionHelper.class);
    List<SpliceJunctionFeature> allSpliceJunctionFeatures = new ArrayList<SpliceJunctionFeature>();
    List<SpliceJunctionFeature> filteredCombinedFeatures = null;
    Table<Integer, Integer, SpliceJunctionFeature> posStartEndJunctionsMap = HashBasedTable.create();
    Table<Integer, Integer, SpliceJunctionFeature> negStartEndJunctionsMap = HashBasedTable.create();
    private LoadOptions loadOptions;

    public SpliceJunctionHelper(LoadOptions loadOptions) {
        this.loadOptions = loadOptions;
    }

    public List<SpliceJunctionFeature> getFilteredJunctions(SpliceJunctionFinderTrack.StrandOption strandOption) {
        List<SpliceJunctionFeature> junctions;
        switch (strandOption) {
            case FORWARD: {
                junctions = new ArrayList<SpliceJunctionFeature>(this.posStartEndJunctionsMap.values());
                break;
            }
            case REVERSE: {
                junctions = new ArrayList<SpliceJunctionFeature>(this.negStartEndJunctionsMap.values());
                break;
            }
            case BOTH: {
                junctions = new ArrayList<SpliceJunctionFeature>(this.posStartEndJunctionsMap.values());
                junctions.addAll(this.negStartEndJunctionsMap.values());
                break;
            }
            default: {
                junctions = this.combineStrandJunctionsMaps();
            }
        }
        SpliceJunctionHelper.filterJunctionList(this.loadOptions, junctions);
        FeatureUtils.sortFeatureList(junctions);
        return junctions;
    }

    public void addAlignment(Alignment alignment) {
        AlignmentBlock[] blocks = alignment.getAlignmentBlocks();
        if (blocks == null || blocks.length < 2) {
            return;
        }
        Object strandAttr = alignment.getAttribute("XS");
        boolean isNegativeStrand = strandAttr != null ? strandAttr.toString().charAt(0) == '-' : (alignment.isPaired() ? alignment.getFirstOfPairStrand() == Strand.NEGATIVE : alignment.isNegativeStrand());
        Table<Integer, Integer, SpliceJunctionFeature> startEndJunctionsTableThisStrand = isNegativeStrand ? this.negStartEndJunctionsMap : this.posStartEndJunctionsMap;
        int flankingStart = -1;
        int junctionStart = -1;
        int gapCount = -1;
        char[] gapTypes = alignment.getGapTypes();
        for (AlignmentBlock block : blocks) {
            int flankingEnd = block.getEnd();
            int junctionEnd = block.getStart();
            if (junctionStart != -1 && gapCount < gapTypes.length && gapTypes[gapCount] == 'N' && (this.loadOptions.minReadFlankingWidth == 0 || junctionStart - flankingStart >= this.loadOptions.minReadFlankingWidth && flankingEnd - junctionEnd >= this.loadOptions.minReadFlankingWidth)) {
                SpliceJunctionFeature junction = startEndJunctionsTableThisStrand.get(junctionStart, junctionEnd);
                if (junction == null) {
                    junction = new SpliceJunctionFeature(alignment.getChr(), junctionStart, junctionEnd, isNegativeStrand ? Strand.NEGATIVE : Strand.POSITIVE);
                    startEndJunctionsTableThisStrand.put(junctionStart, junctionEnd, junction);
                    this.allSpliceJunctionFeatures.add(junction);
                }
                junction.addRead(flankingStart, flankingEnd);
            }
            flankingStart = junctionEnd;
            junctionStart = flankingEnd;
            ++gapCount;
        }
    }

    private static List<SpliceJunctionFeature> filterJunctionList(LoadOptions loadOptions, List<SpliceJunctionFeature> unfiltered) {
        if (loadOptions.minJunctionCoverage > 1) {
            ArrayList<SpliceJunctionFeature> coveredFeatures = new ArrayList<SpliceJunctionFeature>(unfiltered.size());
            for (SpliceJunctionFeature feature : unfiltered) {
                if (feature.getJunctionDepth() < loadOptions.minJunctionCoverage) continue;
                coveredFeatures.add(feature);
            }
            return coveredFeatures;
        }
        return unfiltered;
    }

    private List<SpliceJunctionFeature> combineStrandJunctionsMaps() {
        HashBasedTable<Integer, Integer, SpliceJunctionFeature> combinedStartEndJunctionsMap = HashBasedTable.create(this.posStartEndJunctionsMap);
        for (Table.Cell<Integer, Integer, SpliceJunctionFeature> negJunctionCell : this.negStartEndJunctionsMap.cellSet()) {
            int junctionStart = negJunctionCell.getRowKey();
            int junctionEnd = negJunctionCell.getColumnKey();
            SpliceJunctionFeature negFeat = negJunctionCell.getValue();
            SpliceJunctionFeature junction = (SpliceJunctionFeature)combinedStartEndJunctionsMap.get(junctionStart, junctionEnd);
            if (junction == null) {
                combinedStartEndJunctionsMap.put(junctionStart, junctionEnd, negFeat);
                continue;
            }
            int newJunctionDepth = junction.getJunctionDepth() + negFeat.getJunctionDepth();
            junction.setJunctionDepth(newJunctionDepth);
        }
        return new ArrayList<SpliceJunctionFeature>(combinedStartEndJunctionsMap.values());
    }

    void setLoadOptions(LoadOptions loadOptions) {
        int oldMinJunctionCoverage = this.loadOptions.minJunctionCoverage;
        assert (this.loadOptions.minReadFlankingWidth == loadOptions.minReadFlankingWidth);
        this.loadOptions = loadOptions;
    }

    public static class LoadOptions {
        private static PreferenceManager prefs = PreferenceManager.getInstance();
        public final int minJunctionCoverage;
        public final int minReadFlankingWidth;

        public LoadOptions() {
            this(prefs.getAsInt("SAM.JUNCTION_MIN_COVERAGE"), prefs.getAsInt("SAM.JUNCTION_MIN_FLANKING_WIDTH"));
        }

        public LoadOptions(int minJunctionCoverage, int minReadFlankingWidth) {
            this.minJunctionCoverage = minJunctionCoverage;
            this.minReadFlankingWidth = minReadFlankingWidth;
        }
    }
}

