/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import htsjdk.tribble.readers.AsciiLineReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.util.ParsingUtils;

public class FastaUtils {
    private static Logger log = Logger.getLogger(FastaUtils.class);
    static Pattern WHITE_SPACE = Pattern.compile("\\s+");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createIndexFile(String inputPath, String outputPath) throws DataLoadException, IOException {
        AsciiLineReader reader = null;
        BufferedWriter writer = null;
        try {
            log.info("Creating index file at " + outputPath);
            reader = new AsciiLineReader(ParsingUtils.openInputStream(inputPath));
            writer = new BufferedWriter(new FileWriter(outputPath));
            String line = null;
            String curContig = null;
            HashSet<String> allContigs = new HashSet<String>();
            int basesPerLine = -1;
            int bytesPerLine = -1;
            long location = 0L;
            long size = 0L;
            long lastPosition = 0L;
            int numInconsistentLines = -1;
            boolean haveTasks = true;
            int numBlanks = -1;
            int lastBlankLineNum = -1;
            int curLineNum = 0;
            while (haveTasks) {
                line = reader.readLine();
                ++curLineNum;
                if (line == null || line.startsWith(">")) {
                    if (numInconsistentLines >= 2) {
                        throw new DataLoadException("Fasta file has uneven line lengths in contig " + curContig, inputPath);
                    }
                    if (curContig != null) {
                        FastaUtils.writeLine(writer, curContig, size, location, basesPerLine, bytesPerLine);
                    }
                    if (line == null) {
                        haveTasks = false;
                        break;
                    }
                    curContig = WHITE_SPACE.split(line)[0];
                    if (allContigs.contains(curContig = curContig.substring(1))) {
                        throw new DataLoadException("Contig '" + curContig + "' found multiple times in file.", inputPath);
                    }
                    allContigs.add(curContig);
                    location = reader.getPosition();
                    size = 0L;
                    basesPerLine = -1;
                    bytesPerLine = -1;
                    numInconsistentLines = -1;
                } else {
                    int basesThisLine = line.length();
                    int bytesThisLine = (int)(reader.getPosition() - lastPosition);
                    if (numInconsistentLines < 0) {
                        basesPerLine = basesThisLine;
                        bytesPerLine = bytesThisLine;
                        numInconsistentLines = 0;
                        numBlanks = 0;
                    } else if ((basesPerLine != basesThisLine || bytesPerLine != bytesThisLine) && basesThisLine > 0) {
                        ++numInconsistentLines;
                    }
                    if (basesThisLine == 0) {
                        ++numBlanks;
                        lastBlankLineNum = curLineNum;
                    } else if (numBlanks >= 1) {
                        throw new DataLoadException(String.format("Blank line at line number %d, followed by data line at %d, in contig %s\nBlank lines are only allowed at the end of a contig", lastBlankLineNum, curLineNum, curContig), inputPath);
                    }
                    size += (long)basesThisLine;
                }
                lastPosition = reader.getPosition();
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    static void writeLine(Writer writer, String contig, long size, long location, int basesPerLine, int bytesPerLine) throws IOException {
        String delim = "\t";
        String line = contig + delim + size + delim + location + delim + basesPerLine + delim + bytesPerLine;
        writer.write(line);
        String newline = "\n";
        if (bytesPerLine - basesPerLine == 2) {
            newline = "\r\n";
        }
        writer.write(newline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void regularizeFastaFile(File inputFile, File outputFile) throws IOException {
        int basesPerLine = 80;
        BufferedReader br = null;
        PrintWriter pw = null;
        try {
            String nextLine;
            br = new BufferedReader(new FileReader(inputFile));
            pw = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
            int count = 0;
            while ((nextLine = br.readLine()) != null) {
                if (nextLine.startsWith(">")) {
                    if (count != 0) {
                        pw.println();
                    }
                    pw.println(nextLine);
                    count = 0;
                    continue;
                }
                char[] characters = nextLine.toCharArray();
                for (int i2 = 0; i2 < characters.length; ++i2) {
                    pw.print(characters[i2]);
                    if (++count != basesPerLine) continue;
                    pw.println();
                    count = 0;
                }
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (pw != null) {
                pw.close();
            }
        }
    }

    public static boolean isFastaPath(String absolutePath) {
        String pth = absolutePath.toLowerCase();
        return pth.endsWith(".fa") || pth.endsWith(".fasta") || pth.endsWith(".fna");
    }
}

