/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.tls.ProtocolVersion;
import org.bouncycastle.crypto.tls.SecurityParameters;
import org.bouncycastle.crypto.tls.TlsClientContext;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.io.Streams;

public class TlsUtils {
    static final byte[] SSL_CLIENT = new byte[]{67, 76, 78, 84};
    static final byte[] SSL_SERVER = new byte[]{83, 82, 86, 82};
    static final byte[][] SSL3_CONST = TlsUtils.genConst();

    protected static void writeUint8(short i2, OutputStream os) throws IOException {
        os.write(i2);
    }

    protected static void writeUint8(short i2, byte[] buf, int offset) {
        buf[offset] = (byte)i2;
    }

    protected static void writeUint16(int i2, OutputStream os) throws IOException {
        os.write(i2 >> 8);
        os.write(i2);
    }

    protected static void writeUint16(int i2, byte[] buf, int offset) {
        buf[offset] = (byte)(i2 >> 8);
        buf[offset + 1] = (byte)i2;
    }

    protected static void writeUint24(int i2, OutputStream os) throws IOException {
        os.write(i2 >> 16);
        os.write(i2 >> 8);
        os.write(i2);
    }

    protected static void writeUint24(int i2, byte[] buf, int offset) {
        buf[offset] = (byte)(i2 >> 16);
        buf[offset + 1] = (byte)(i2 >> 8);
        buf[offset + 2] = (byte)i2;
    }

    protected static void writeUint32(long i2, OutputStream os) throws IOException {
        os.write((int)(i2 >> 24));
        os.write((int)(i2 >> 16));
        os.write((int)(i2 >> 8));
        os.write((int)i2);
    }

    protected static void writeUint32(long i2, byte[] buf, int offset) {
        buf[offset] = (byte)(i2 >> 24);
        buf[offset + 1] = (byte)(i2 >> 16);
        buf[offset + 2] = (byte)(i2 >> 8);
        buf[offset + 3] = (byte)i2;
    }

    protected static void writeUint64(long i2, OutputStream os) throws IOException {
        os.write((int)(i2 >> 56));
        os.write((int)(i2 >> 48));
        os.write((int)(i2 >> 40));
        os.write((int)(i2 >> 32));
        os.write((int)(i2 >> 24));
        os.write((int)(i2 >> 16));
        os.write((int)(i2 >> 8));
        os.write((int)i2);
    }

    protected static void writeUint64(long i2, byte[] buf, int offset) {
        buf[offset] = (byte)(i2 >> 56);
        buf[offset + 1] = (byte)(i2 >> 48);
        buf[offset + 2] = (byte)(i2 >> 40);
        buf[offset + 3] = (byte)(i2 >> 32);
        buf[offset + 4] = (byte)(i2 >> 24);
        buf[offset + 5] = (byte)(i2 >> 16);
        buf[offset + 6] = (byte)(i2 >> 8);
        buf[offset + 7] = (byte)i2;
    }

    protected static void writeOpaque8(byte[] buf, OutputStream os) throws IOException {
        TlsUtils.writeUint8((short)buf.length, os);
        os.write(buf);
    }

    protected static void writeOpaque16(byte[] buf, OutputStream os) throws IOException {
        TlsUtils.writeUint16(buf.length, os);
        os.write(buf);
    }

    protected static void writeOpaque24(byte[] buf, OutputStream os) throws IOException {
        TlsUtils.writeUint24(buf.length, os);
        os.write(buf);
    }

    protected static void writeUint8Array(short[] uints, OutputStream os) throws IOException {
        for (int i2 = 0; i2 < uints.length; ++i2) {
            TlsUtils.writeUint8(uints[i2], os);
        }
    }

    protected static void writeUint16Array(int[] uints, OutputStream os) throws IOException {
        for (int i2 = 0; i2 < uints.length; ++i2) {
            TlsUtils.writeUint16(uints[i2], os);
        }
    }

    protected static short readUint8(InputStream is) throws IOException {
        int i2 = is.read();
        if (i2 == -1) {
            throw new EOFException();
        }
        return (short)i2;
    }

    protected static int readUint16(InputStream is) throws IOException {
        int i2;
        int i1 = is.read();
        if ((i1 | (i2 = is.read())) < 0) {
            throw new EOFException();
        }
        return i1 << 8 | i2;
    }

    protected static int readUint24(InputStream is) throws IOException {
        int i3;
        int i2;
        int i1 = is.read();
        if ((i1 | (i2 = is.read()) | (i3 = is.read())) < 0) {
            throw new EOFException();
        }
        return i1 << 16 | i2 << 8 | i3;
    }

    protected static long readUint32(InputStream is) throws IOException {
        int i4;
        int i3;
        int i2;
        int i1 = is.read();
        if ((i1 | (i2 = is.read()) | (i3 = is.read()) | (i4 = is.read())) < 0) {
            throw new EOFException();
        }
        return (long)i1 << 24 | (long)i2 << 16 | (long)i3 << 8 | (long)i4;
    }

    protected static void readFully(byte[] buf, InputStream is) throws IOException {
        if (Streams.readFully(is, buf) != buf.length) {
            throw new EOFException();
        }
    }

    protected static byte[] readOpaque8(InputStream is) throws IOException {
        short length = TlsUtils.readUint8(is);
        byte[] value = new byte[length];
        TlsUtils.readFully(value, is);
        return value;
    }

    protected static byte[] readOpaque16(InputStream is) throws IOException {
        int length = TlsUtils.readUint16(is);
        byte[] value = new byte[length];
        TlsUtils.readFully(value, is);
        return value;
    }

    static ProtocolVersion readVersion(byte[] buf) throws IOException {
        return ProtocolVersion.get(buf[0], buf[1]);
    }

    static ProtocolVersion readVersion(InputStream is) throws IOException {
        int i1 = is.read();
        int i2 = is.read();
        return ProtocolVersion.get(i1, i2);
    }

    protected static void writeGMTUnixTime(byte[] buf, int offset) {
        int t2 = (int)(System.currentTimeMillis() / 1000L);
        buf[offset] = (byte)(t2 >> 24);
        buf[offset + 1] = (byte)(t2 >> 16);
        buf[offset + 2] = (byte)(t2 >> 8);
        buf[offset + 3] = (byte)t2;
    }

    static void writeVersion(ProtocolVersion version, OutputStream os) throws IOException {
        os.write(version.getMajorVersion());
        os.write(version.getMinorVersion());
    }

    static void writeVersion(ProtocolVersion version, byte[] buf, int offset) throws IOException {
        buf[offset] = (byte)version.getMajorVersion();
        buf[offset + 1] = (byte)version.getMinorVersion();
    }

    private static void hmac_hash(Digest digest, byte[] secret, byte[] seed, byte[] out) {
        HMac mac = new HMac(digest);
        KeyParameter param = new KeyParameter(secret);
        byte[] a2 = seed;
        int size = digest.getDigestSize();
        int iterations = (out.length + size - 1) / size;
        byte[] buf = new byte[mac.getMacSize()];
        byte[] buf2 = new byte[mac.getMacSize()];
        for (int i2 = 0; i2 < iterations; ++i2) {
            mac.init(param);
            mac.update(a2, 0, a2.length);
            mac.doFinal(buf, 0);
            a2 = buf;
            mac.init(param);
            mac.update(a2, 0, a2.length);
            mac.update(seed, 0, seed.length);
            mac.doFinal(buf2, 0);
            System.arraycopy(buf2, 0, out, size * i2, Math.min(size, out.length - size * i2));
        }
    }

    protected static byte[] PRF(byte[] secret, String asciiLabel, byte[] seed, int size) {
        byte[] label = Strings.toByteArray(asciiLabel);
        int s_half = (secret.length + 1) / 2;
        byte[] s1 = new byte[s_half];
        byte[] s2 = new byte[s_half];
        System.arraycopy(secret, 0, s1, 0, s_half);
        System.arraycopy(secret, secret.length - s_half, s2, 0, s_half);
        byte[] ls = TlsUtils.concat(label, seed);
        byte[] buf = new byte[size];
        byte[] prf = new byte[size];
        TlsUtils.hmac_hash(new MD5Digest(), s1, ls, prf);
        TlsUtils.hmac_hash(new SHA1Digest(), s2, ls, buf);
        for (int i2 = 0; i2 < size; ++i2) {
            int n2 = i2;
            buf[n2] = (byte)(buf[n2] ^ prf[i2]);
        }
        return buf;
    }

    static byte[] PRF_1_2(Digest digest, byte[] secret, String asciiLabel, byte[] seed, int size) {
        byte[] label = Strings.toByteArray(asciiLabel);
        byte[] labelSeed = TlsUtils.concat(label, seed);
        byte[] buf = new byte[size];
        TlsUtils.hmac_hash(digest, secret, labelSeed, buf);
        return buf;
    }

    static byte[] concat(byte[] a2, byte[] b2) {
        byte[] c2 = new byte[a2.length + b2.length];
        System.arraycopy(a2, 0, c2, 0, a2.length);
        System.arraycopy(b2, 0, c2, a2.length, b2.length);
        return c2;
    }

    static void validateKeyUsage(X509CertificateStructure c2, int keyUsageBits) throws IOException {
        DERBitString ku;
        int bits;
        X509Extension ext;
        X509Extensions exts = c2.getTBSCertificate().getExtensions();
        if (exts != null && (ext = exts.getExtension(X509Extension.keyUsage)) != null && ((bits = (ku = KeyUsage.getInstance(ext)).getBytes()[0] & 0xFF) & keyUsageBits) != keyUsageBits) {
            throw new TlsFatalAlert(46);
        }
    }

    static byte[] calculateKeyBlock(TlsClientContext context, int size) {
        boolean isTls;
        ProtocolVersion pv = context.getServerVersion();
        SecurityParameters sp = context.getSecurityParameters();
        byte[] random = TlsUtils.concat(sp.serverRandom, sp.clientRandom);
        boolean bl = isTls = pv.getFullVersion() >= ProtocolVersion.TLSv10.getFullVersion();
        if (isTls) {
            return TlsUtils.PRF(sp.masterSecret, "key expansion", random, size);
        }
        MD5Digest md5 = new MD5Digest();
        SHA1Digest sha1 = new SHA1Digest();
        int md5Size = md5.getDigestSize();
        byte[] shatmp = new byte[sha1.getDigestSize()];
        byte[] tmp = new byte[size + md5Size];
        int i2 = 0;
        int pos = 0;
        while (pos < size) {
            byte[] ssl3Const = SSL3_CONST[i2];
            sha1.update(ssl3Const, 0, ssl3Const.length);
            sha1.update(sp.masterSecret, 0, sp.masterSecret.length);
            sha1.update(random, 0, random.length);
            sha1.doFinal(shatmp, 0);
            md5.update(sp.masterSecret, 0, sp.masterSecret.length);
            md5.update(shatmp, 0, shatmp.length);
            md5.doFinal(tmp, pos);
            pos += md5Size;
            ++i2;
        }
        byte[] rval = new byte[size];
        System.arraycopy(tmp, 0, rval, 0, size);
        return rval;
    }

    static byte[] calculateMasterSecret(TlsClientContext context, byte[] pms) {
        boolean isTls;
        ProtocolVersion pv = context.getServerVersion();
        SecurityParameters sp = context.getSecurityParameters();
        byte[] random = TlsUtils.concat(sp.clientRandom, sp.serverRandom);
        boolean bl = isTls = pv.getFullVersion() >= ProtocolVersion.TLSv10.getFullVersion();
        if (isTls) {
            return TlsUtils.PRF(pms, "master secret", random, 48);
        }
        MD5Digest md5 = new MD5Digest();
        SHA1Digest sha1 = new SHA1Digest();
        int md5Size = md5.getDigestSize();
        byte[] shatmp = new byte[sha1.getDigestSize()];
        byte[] rval = new byte[md5Size * 3];
        int pos = 0;
        for (int i2 = 0; i2 < 3; ++i2) {
            byte[] ssl3Const = SSL3_CONST[i2];
            sha1.update(ssl3Const, 0, ssl3Const.length);
            sha1.update(pms, 0, pms.length);
            sha1.update(random, 0, random.length);
            sha1.doFinal(shatmp, 0);
            md5.update(pms, 0, pms.length);
            md5.update(shatmp, 0, shatmp.length);
            md5.doFinal(rval, pos);
            pos += md5Size;
        }
        return rval;
    }

    static byte[] calculateVerifyData(TlsClientContext context, String asciiLabel, byte[] handshakeHash) {
        boolean isTls;
        ProtocolVersion pv = context.getServerVersion();
        SecurityParameters sp = context.getSecurityParameters();
        boolean bl = isTls = pv.getFullVersion() >= ProtocolVersion.TLSv10.getFullVersion();
        if (isTls) {
            return TlsUtils.PRF(sp.masterSecret, asciiLabel, handshakeHash, 12);
        }
        return handshakeHash;
    }

    private static byte[][] genConst() {
        int n2 = 10;
        byte[][] arr = new byte[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            byte[] b2 = new byte[i2 + 1];
            Arrays.fill(b2, (byte)(65 + i2));
            arr[i2] = b2;
        }
        return arr;
    }
}

