/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.StreamUtil;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.Streams;

public class DERBitString
extends ASN1Primitive
implements ASN1String {
    private static final char[] table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected byte[] data;
    protected int padBits;

    protected static int getPadBits(int bitString) {
        int val = 0;
        for (int i2 = 3; i2 >= 0; --i2) {
            if (i2 != 0) {
                if (bitString >> i2 * 8 == 0) continue;
                val = bitString >> i2 * 8 & 0xFF;
                break;
            }
            if (bitString == 0) continue;
            val = bitString & 0xFF;
            break;
        }
        if (val == 0) {
            return 7;
        }
        int bits = 1;
        while (((val <<= 1) & 0xFF) != 0) {
            ++bits;
        }
        return 8 - bits;
    }

    protected static byte[] getBytes(int bitString) {
        int bytes = 4;
        for (int i2 = 3; i2 >= 1 && (bitString & 255 << i2 * 8) == 0; --i2) {
            --bytes;
        }
        byte[] result = new byte[bytes];
        for (int i3 = 0; i3 < bytes; ++i3) {
            result[i3] = (byte)(bitString >> i3 * 8 & 0xFF);
        }
        return result;
    }

    public static DERBitString getInstance(Object obj) {
        if (obj == null || obj instanceof DERBitString) {
            return (DERBitString)obj;
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERBitString getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive o2 = obj.getObject();
        if (explicit || o2 instanceof DERBitString) {
            return DERBitString.getInstance(o2);
        }
        return DERBitString.fromOctetString(((ASN1OctetString)o2).getOctets());
    }

    protected DERBitString(byte data, int padBits) {
        this.data = new byte[1];
        this.data[0] = data;
        this.padBits = padBits;
    }

    public DERBitString(byte[] data, int padBits) {
        this.data = data;
        this.padBits = padBits;
    }

    public DERBitString(byte[] data) {
        this(data, 0);
    }

    public DERBitString(ASN1Encodable obj) {
        try {
            this.data = obj.toASN1Primitive().getEncoded("DER");
            this.padBits = 0;
        }
        catch (IOException e2) {
            throw new IllegalArgumentException("Error processing object : " + e2.toString());
        }
    }

    public byte[] getBytes() {
        return this.data;
    }

    public int getPadBits() {
        return this.padBits;
    }

    public int intValue() {
        int value = 0;
        for (int i2 = 0; i2 != this.data.length && i2 != 4; ++i2) {
            value |= (this.data[i2] & 0xFF) << 8 * i2;
        }
        return value;
    }

    boolean isConstructed() {
        return false;
    }

    int encodedLength() {
        return 1 + StreamUtil.calculateBodyLength(this.data.length + 1) + this.data.length + 1;
    }

    void encode(ASN1OutputStream out) throws IOException {
        byte[] bytes = new byte[this.getBytes().length + 1];
        bytes[0] = (byte)this.getPadBits();
        System.arraycopy(this.getBytes(), 0, bytes, 1, bytes.length - 1);
        out.writeEncoded(3, bytes);
    }

    public int hashCode() {
        return this.padBits ^ Arrays.hashCode(this.data);
    }

    protected boolean asn1Equals(ASN1Primitive o2) {
        if (!(o2 instanceof DERBitString)) {
            return false;
        }
        DERBitString other = (DERBitString)o2;
        return this.padBits == other.padBits && Arrays.areEqual(this.data, other.data);
    }

    public String getString() {
        StringBuffer buf = new StringBuffer("#");
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        try {
            aOut.writeObject(this);
        }
        catch (IOException e2) {
            throw new RuntimeException("internal error encoding BitString");
        }
        byte[] string = bOut.toByteArray();
        for (int i2 = 0; i2 != string.length; ++i2) {
            buf.append(table[string[i2] >>> 4 & 0xF]);
            buf.append(table[string[i2] & 0xF]);
        }
        return buf.toString();
    }

    public String toString() {
        return this.getString();
    }

    static DERBitString fromOctetString(byte[] bytes) {
        if (bytes.length < 1) {
            throw new IllegalArgumentException("truncated BIT STRING detected");
        }
        byte padBits = bytes[0];
        byte[] data = new byte[bytes.length - 1];
        if (data.length != 0) {
            System.arraycopy(bytes, 1, data, 0, bytes.length - 1);
        }
        return new DERBitString(data, (int)padBits);
    }

    static DERBitString fromInputStream(int length, InputStream stream) throws IOException {
        if (length < 1) {
            throw new IllegalArgumentException("truncated BIT STRING detected");
        }
        int padBits = stream.read();
        byte[] data = new byte[length - 1];
        if (data.length != 0 && Streams.readFully(stream, data) != data.length) {
            throw new EOFException("EOF encountered in middle of BIT STRING");
        }
        return new DERBitString(data, padBits);
    }
}

