/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedArrayList<E>
extends ArrayList<E> {
    private static final long serialVersionUID = 3835017332487313880L;
    private Map<Object, Integer> _indexCache;
    private boolean _lazyCaching = false;
    private boolean _isDirty = false;

    public CachedArrayList() {
    }

    public CachedArrayList(Collection<? extends E> c2) {
        super(c2);
        if (!this.isLazyCaching()) {
            this.cacheAll();
        }
    }

    public CachedArrayList(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public int indexOf(Object elem) {
        Integer o2;
        if (this._indexCache == null || this._isDirty) {
            this.cacheAll();
        }
        if ((o2 = this._indexCache.get(elem)) != null) {
            return o2;
        }
        if (this.isLazyCaching()) {
            int i2 = super.indexOf(elem);
            if (i2 == -1) {
                this.uncacheIt(elem);
            } else {
                this.cacheIt(elem, i2);
            }
            return i2;
        }
        return -1;
    }

    @Deprecated
    protected synchronized void adjustCache(int index, int increase) {
        if (this._indexCache != null) {
            Map<Object, Integer> newCache = this.createCache();
            Set<Object> keys = this._indexCache.keySet();
            for (Object key : keys) {
                int value = this._indexCache.get(key);
                if (value >= index) {
                    newCache.put(key, value + increase);
                    continue;
                }
                newCache.put(key, value);
            }
            this._indexCache = newCache;
        }
    }

    protected Map<Object, Integer> createCache() {
        return new IdentityHashMap<Object, Integer>();
    }

    public void cacheIt(Object o2, int index) {
        if (this._indexCache != null) {
            Integer old = this._indexCache.put(o2, index);
            if (old != null && old < index) {
                this._indexCache.put(o2, old);
            }
            this.markDirtyIfNecessary(index);
            if (!this._isDirty && !this.isLazyCaching()) {
                for (int i2 = this.size() - 1; i2 > index; --i2) {
                    Integer oldI = this._indexCache.put(this.get(i2), i2);
                    if (oldI == null || oldI >= index) continue;
                    this._indexCache.put(this.get(i2), oldI);
                }
            }
        }
    }

    protected void markDirtyIfNecessary(int index) {
        if (index < this.size() / 2) {
            this._isDirty = true;
        }
    }

    public void uncacheIt(Object o2) {
        if (this._indexCache != null) {
            this._indexCache.remove(o2);
        }
    }

    @Override
    public boolean add(E o2) {
        boolean added = super.add(o2);
        if (!this.isLazyCaching() && this._indexCache != null && added) {
            this.cacheIt(o2, this.size() - 1);
        }
        return added;
    }

    @Override
    public void add(int index, E element) {
        if (index == this.size()) {
            this.add(element);
            return;
        }
        super.add(index, element);
        if (!this.isLazyCaching()) {
            this.cacheIt(element, index);
        } else if (this._indexCache != null) {
            this.cacheIt(element, index);
        }
    }

    private void initializeCache() {
        if (this._indexCache == null) {
            this._indexCache = this.createCache();
        }
    }

    @Override
    public E remove(int index) {
        Object element = super.remove(index);
        if (element != null) {
            this.uncacheAll();
        }
        return element;
    }

    @Override
    public boolean remove(Object o2) {
        boolean removed = super.remove(o2);
        if (removed) {
            this.uncacheAll();
        }
        return removed;
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        this.uncacheAll();
        return super.removeAll(c2);
    }

    @Override
    public void clear() {
        this.uncacheAll();
        super.clear();
    }

    @Override
    public boolean addAll(Collection<? extends E> c2) {
        int index = this.size();
        boolean added = super.addAll(c2);
        if (added && this._indexCache != null) {
            for (E e2 : c2) {
                this.cacheIt(e2, index++);
            }
        }
        return added;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c2) {
        if (index == this.size()) {
            return this.addAll(c2);
        }
        boolean added = super.addAll(index, c2);
        if (added) {
            this.uncacheAll();
        }
        return added;
    }

    @Override
    public E set(int index, E element) {
        if (!this.isLazyCaching()) {
            this.uncacheAll();
            return super.set(index, element);
        }
        return super.set(index, element);
    }

    public void invalidateCache() {
        this.uncacheAll();
    }

    public void uncacheAll() {
        if (this._indexCache != null) {
            this._indexCache.clear();
            this._indexCache = null;
        }
    }

    public void cacheAll() {
        this._indexCache = this.createCache();
        for (int i2 = this.size() - 1; i2 >= 0; --i2) {
            this._indexCache.put(this.get(i2), i2);
        }
        this._isDirty = false;
    }

    public boolean isLazyCaching() {
        return this._lazyCaching;
    }

    public void setLazyCaching(boolean lazyCaching) {
        this._lazyCaching = lazyCaching;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            this.remove(fromIndex);
        } else {
            super.removeRange(fromIndex, toIndex);
            this.uncacheAll();
        }
    }
}

