/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.markduplicates.util;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.Histogram;
import java.util.HashMap;
import java.util.Map;
import picard.sam.DuplicationMetrics;

public class LibraryIdGenerator {
    private final SAMFileHeader header;
    private final Map<String, Short> libraryIds = new HashMap<String, Short>();
    private short nextLibraryId = 1;
    private final Map<String, DuplicationMetrics> metricsByLibrary = new HashMap<String, DuplicationMetrics>();
    private final Histogram<Short> opticalDuplicatesByLibraryId = new Histogram();

    public LibraryIdGenerator(SAMFileHeader header) {
        this.header = header;
        for (SAMReadGroupRecord readGroup : header.getReadGroups()) {
            String library = readGroup.getLibrary();
            DuplicationMetrics metrics = this.metricsByLibrary.get(library);
            if (metrics != null) continue;
            metrics = new DuplicationMetrics();
            metrics.LIBRARY = library;
            this.metricsByLibrary.put(library, metrics);
        }
    }

    public Map<String, Short> getLibraryIdsMap() {
        return this.libraryIds;
    }

    public Map<String, DuplicationMetrics> getMetricsByLibraryMap() {
        return this.metricsByLibrary;
    }

    public Histogram<Short> getOpticalDuplicatesByLibraryIdMap() {
        return this.opticalDuplicatesByLibraryId;
    }

    public static String getLibraryName(SAMFileHeader header, SAMRecord rec) {
        String libraryName;
        SAMReadGroupRecord rg;
        String readGroupId = (String)rec.getAttribute("RG");
        if (readGroupId != null && (rg = header.getReadGroup(readGroupId)) != null && null != (libraryName = rg.getLibrary())) {
            return libraryName;
        }
        return "Unknown Library";
    }

    public short getLibraryId(SAMRecord rec) {
        String library = LibraryIdGenerator.getLibraryName(this.header, rec);
        Short libraryId = this.libraryIds.get(library);
        if (libraryId == null) {
            short s2 = this.nextLibraryId;
            this.nextLibraryId = (short)(s2 + 1);
            libraryId = s2;
            this.libraryIds.put(library, libraryId);
        }
        return libraryId;
    }

    public DuplicationMetrics getMetricsByLibrary(String library) {
        return this.metricsByLibrary.get(library);
    }

    public void addMetricsByLibrary(String library, DuplicationMetrics metrics) {
        this.metricsByLibrary.put(library, metrics);
    }

    public long getNumberOfOpticalDuplicateClusters() {
        return (long)this.opticalDuplicatesByLibraryId.getSumOfValues();
    }
}

