/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jgrapht.EdgeFactory;
import org.jgrapht.Graph;
import org.jgrapht.ListenableGraph;
import org.jgrapht.WeightedGraph;
import org.jgrapht.event.GraphEdgeChangeEvent;
import org.jgrapht.event.GraphListener;
import org.jgrapht.event.GraphVertexChangeEvent;
import org.jgrapht.graph.AbstractGraph;
import org.jgrapht.util.ArrayUnenforcedSet;

public class Subgraph<V, E, G extends Graph<V, E>>
extends AbstractGraph<V, E>
implements Serializable {
    private static final long serialVersionUID = 3208313055169665387L;
    private static final String NO_SUCH_EDGE_IN_BASE = "no such edge in base graph";
    private static final String NO_SUCH_VERTEX_IN_BASE = "no such vertex in base graph";
    Set<E> edgeSet = new LinkedHashSet();
    Set<V> vertexSet = new LinkedHashSet<V>();
    private transient Set<E> unmodifiableEdgeSet = null;
    private transient Set<V> unmodifiableVertexSet = null;
    private G base;
    private boolean isInduced = false;

    public Subgraph(G g2, Set<V> set, Set<E> set2) {
        this.base = g2;
        if (set2 == null) {
            this.isInduced = true;
        }
        if (g2 instanceof ListenableGraph) {
            ((ListenableGraph)g2).addGraphListener(new BaseGraphListener());
        }
        this.addVerticesUsingFilter(g2.vertexSet(), set);
        this.addEdgesUsingFilter(g2.edgeSet(), set2);
    }

    public Subgraph(G g2, Set<V> set) {
        this(g2, set, null);
    }

    @Override
    public Set<E> getAllEdges(V v2, V v3) {
        ArrayUnenforcedSet arrayUnenforcedSet = null;
        if (this.containsVertex(v2) && this.containsVertex(v3)) {
            arrayUnenforcedSet = new ArrayUnenforcedSet();
            Set set = this.base.getAllEdges(v2, v3);
            for (Object e2 : set) {
                if (!this.edgeSet.contains(e2)) continue;
                arrayUnenforcedSet.add(e2);
            }
        }
        return arrayUnenforcedSet;
    }

    @Override
    public E getEdge(V v2, V v3) {
        Set<E> set = this.getAllEdges(v2, v3);
        if (set == null || set.isEmpty()) {
            return null;
        }
        return set.iterator().next();
    }

    @Override
    public EdgeFactory<V, E> getEdgeFactory() {
        return this.base.getEdgeFactory();
    }

    @Override
    public E addEdge(V v2, V v3) {
        this.assertVertexExist(v2);
        this.assertVertexExist(v3);
        if (!this.base.containsEdge(v2, v3)) {
            throw new IllegalArgumentException(NO_SUCH_EDGE_IN_BASE);
        }
        Set set = this.base.getAllEdges(v2, v3);
        for (Object e2 : set) {
            if (this.containsEdge(e2)) continue;
            this.edgeSet.add(e2);
            return e2;
        }
        return null;
    }

    @Override
    public boolean addEdge(V v2, V v3, E e2) {
        if (e2 == null) {
            throw new NullPointerException();
        }
        if (!this.base.containsEdge(e2)) {
            throw new IllegalArgumentException(NO_SUCH_EDGE_IN_BASE);
        }
        this.assertVertexExist(v2);
        this.assertVertexExist(v3);
        assert (this.base.getEdgeSource(e2) == v2);
        assert (this.base.getEdgeTarget(e2) == v3);
        if (this.containsEdge(e2)) {
            return false;
        }
        this.edgeSet.add(e2);
        return true;
    }

    @Override
    public boolean addVertex(V v2) {
        if (v2 == null) {
            throw new NullPointerException();
        }
        if (!this.base.containsVertex(v2)) {
            throw new IllegalArgumentException(NO_SUCH_VERTEX_IN_BASE);
        }
        if (this.containsVertex(v2)) {
            return false;
        }
        this.vertexSet.add(v2);
        return true;
    }

    @Override
    public boolean containsEdge(E e2) {
        return this.edgeSet.contains(e2);
    }

    @Override
    public boolean containsVertex(V v2) {
        return this.vertexSet.contains(v2);
    }

    @Override
    public Set<E> edgeSet() {
        if (this.unmodifiableEdgeSet == null) {
            this.unmodifiableEdgeSet = Collections.unmodifiableSet(this.edgeSet);
        }
        return this.unmodifiableEdgeSet;
    }

    @Override
    public Set<E> edgesOf(V v2) {
        this.assertVertexExist(v2);
        ArrayUnenforcedSet arrayUnenforcedSet = new ArrayUnenforcedSet();
        Set set = this.base.edgesOf(v2);
        for (Object e2 : set) {
            if (!this.containsEdge(e2)) continue;
            arrayUnenforcedSet.add(e2);
        }
        return arrayUnenforcedSet;
    }

    @Override
    public boolean removeEdge(E e2) {
        return this.edgeSet.remove(e2);
    }

    @Override
    public E removeEdge(V v2, V v3) {
        E e2 = this.getEdge(v2, v3);
        return (E)(this.edgeSet.remove(e2) ? e2 : null);
    }

    @Override
    public boolean removeVertex(V v2) {
        if (this.containsVertex(v2) && this.base.containsVertex(v2)) {
            this.removeAllEdges(this.edgesOf(v2));
        }
        return this.vertexSet.remove(v2);
    }

    @Override
    public Set<V> vertexSet() {
        if (this.unmodifiableVertexSet == null) {
            this.unmodifiableVertexSet = Collections.unmodifiableSet(this.vertexSet);
        }
        return this.unmodifiableVertexSet;
    }

    @Override
    public V getEdgeSource(E e2) {
        return this.base.getEdgeSource(e2);
    }

    @Override
    public V getEdgeTarget(E e2) {
        return this.base.getEdgeTarget(e2);
    }

    private void addEdgesUsingFilter(Set<E> set, Set<E> set2) {
        for (E e2 : set) {
            boolean bl;
            Object v2 = this.base.getEdgeSource(e2);
            Object v3 = this.base.getEdgeTarget(e2);
            boolean bl2 = this.containsVertex(v2) && this.containsVertex(v3);
            boolean bl3 = bl = set2 == null || set2.contains(e2);
            if (!bl2 || !bl) continue;
            this.addEdge(v2, v3, e2);
        }
    }

    private void addVerticesUsingFilter(Set<V> set, Set<V> set2) {
        for (V v2 : set) {
            if (set2 != null && !set2.contains(v2)) continue;
            this.addVertex(v2);
        }
    }

    public G getBase() {
        return this.base;
    }

    @Override
    public double getEdgeWeight(E e2) {
        return this.base.getEdgeWeight(e2);
    }

    public void setEdgeWeight(E e2, double d2) {
        ((WeightedGraph)this.base).setEdgeWeight(e2, d2);
    }

    private class BaseGraphListener
    implements GraphListener<V, E>,
    Serializable {
        private static final long serialVersionUID = 4343535244243546391L;

        private BaseGraphListener() {
        }

        @Override
        public void edgeAdded(GraphEdgeChangeEvent<V, E> graphEdgeChangeEvent) {
            if (Subgraph.this.isInduced) {
                Object e2 = graphEdgeChangeEvent.getEdge();
                Object v2 = Subgraph.this.base.getEdgeSource(e2);
                Object v3 = Subgraph.this.base.getEdgeTarget(e2);
                if (Subgraph.this.containsVertex(v2) && Subgraph.this.containsVertex(v3)) {
                    Subgraph.this.addEdge(v2, v3, e2);
                }
            }
        }

        @Override
        public void edgeRemoved(GraphEdgeChangeEvent<V, E> graphEdgeChangeEvent) {
            Object e2 = graphEdgeChangeEvent.getEdge();
            Subgraph.this.removeEdge(e2);
        }

        @Override
        public void vertexAdded(GraphVertexChangeEvent<V> graphVertexChangeEvent) {
        }

        @Override
        public void vertexRemoved(GraphVertexChangeEvent<V> graphVertexChangeEvent) {
            Object v2 = graphVertexChangeEvent.getVertex();
            Subgraph.this.removeVertex(v2);
        }
    }
}

