/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.generate;

import java.util.LinkedList;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.VertexFactory;
import org.jgrapht.generate.GraphGenerator;

public class HyperCubeGraphGenerator<V, E>
implements GraphGenerator<V, E, V> {
    private int dim;

    public HyperCubeGraphGenerator(int n2) {
        this.dim = n2;
    }

    @Override
    public void generateGraph(Graph<V, E> graph, VertexFactory<V> vertexFactory, Map<String, V> map) {
        int n2;
        int n3 = (int)Math.pow(2.0, this.dim);
        LinkedList<V> linkedList = new LinkedList<V>();
        for (n2 = 0; n2 < n3; ++n2) {
            V v2 = vertexFactory.createVertex();
            graph.addVertex(v2);
            linkedList.add(v2);
            if (map == null) continue;
            String string = Integer.toBinaryString(n2);
            while (string.length() < this.dim) {
                string = "0" + string;
            }
            map.put(string, v2);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            block3: for (int i2 = n2 + 1; i2 < n3; ++i2) {
                for (int i3 = 0; i3 < this.dim; ++i3) {
                    if ((i2 ^ n2) != 1 << i3) continue;
                    graph.addEdge(linkedList.get(n2), linkedList.get(i2));
                    continue block3;
                }
            }
        }
    }
}

