/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.stream;

import htsjdk.samtools.seekablestream.ISeekableStreamFactory;
import htsjdk.samtools.seekablestream.SeekableFileStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.stream.IGVSeekableBufferedStream;
import org.broad.igv.util.stream.IGVSeekableFTPStream;
import org.broad.igv.util.stream.IGVSeekableHTTPStream;
import org.broad.igv.util.stream.SeekableServiceStream;
import org.broad.igv.util.stream.SeekableSplitStream;

public class IGVSeekableStreamFactory
implements ISeekableStreamFactory {
    private static IGVSeekableStreamFactory instance = new IGVSeekableStreamFactory();

    private IGVSeekableStreamFactory() {
    }

    public static IGVSeekableStreamFactory getInstance() {
        return instance;
    }

    @Override
    public SeekableStream getStreamFor(URL url) throws IOException {
        return this.getStreamFor(url.toExternalForm());
    }

    @Override
    public SeekableStream getStreamFor(String path) throws IOException {
        if (path.endsWith(".list")) {
            return new SeekableSplitStream(path);
        }
        SeekableStream is = null;
        if (path.toLowerCase().startsWith("http:") || path.toLowerCase().startsWith("https:")) {
            URL url = new URL(path);
            boolean useByteRange = HttpUtils.getInstance().useByteRange(url);
            is = useByteRange ? new IGVSeekableHTTPStream(url) : new SeekableServiceStream(url);
        } else if (path.toLowerCase().startsWith("ftp:")) {
            URL url = new URL(path);
            is = new IGVSeekableFTPStream(url);
        } else {
            is = new SeekableFileStream(new File(path));
        }
        return is;
    }

    @Override
    public SeekableStream getBufferedStream(SeekableStream stream) {
        return this.getBufferedStream(stream, 512000);
    }

    @Override
    public SeekableStream getBufferedStream(SeekableStream stream, int bufferSize) {
        return new IGVSeekableBufferedStream(stream, bufferSize);
    }
}

