/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.broad.igv.Globals;
import org.broad.igv.util.FileUtils;

public class OneKGUtils {
    static final String prefix = "http://1000genomes.s3.amazonaws.com/";
    static final String prefix2 = "http://www.broadinstitute.org/igvdata/1KG/b37/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createResourceXMLs(List<String> inputFiles, String outputFile) throws IOException {
        HashMap exomeResources = new HashMap();
        HashMap lowCovResources = new HashMap();
        HashSet<String> pops = new HashSet<String>();
        BufferedReader br = null;
        for (String inputFile : inputFiles) {
            try {
                String line;
                br = new BufferedReader(new FileReader(inputFile));
                while ((line = br.readLine()) != null) {
                    String fullPath;
                    String[] t1 = Globals.forwardSlashPattern.split(line);
                    String[] t2 = t1[3].split("\\.");
                    String type = t2[5];
                    String name = t2[0] + " " + type;
                    String pop = t2[4];
                    pops.add(pop);
                    HashMap resources = type.equals("exome") ? exomeResources : lowCovResources;
                    ArrayList<String> entries = (ArrayList<String>)resources.get(pop);
                    if (entries == null) {
                        entries = new ArrayList<String>();
                        resources.put(pop, entries);
                    }
                    if (!FileUtils.resourceExists(fullPath = prefix + line) || !FileUtils.resourceExists(fullPath + ".bai")) {
                        fullPath = prefix2 + line;
                    }
                    if (!FileUtils.resourceExists(fullPath) || !FileUtils.resourceExists(fullPath + ".bai")) {
                        System.out.println("Resource not found: " + line);
                        continue;
                    }
                    entries.add("<Resource name=\"" + name + "\" path=\"" + fullPath + "\"/>");
                }
            }
            finally {
                br.close();
            }
        }
        PrintWriter out = null;
        try {
            out = new PrintWriter(outputFile);
            ArrayList popList = new ArrayList(pops);
            Collections.sort(popList);
            for (String pop : popList) {
                out.println("<Category name=\"" + pop + "\">");
                out.println("<Category name=\"exome\">");
                List entries = (List)exomeResources.get(pop);
                for (String e2 : entries) {
                    out.println(e2);
                }
                out.println("</Category>");
                out.println("<Category name=\"low coverage\">");
                entries = (List)lowCovResources.get(pop);
                for (String e2 : entries) {
                    out.println(e2);
                }
                out.println("</Category>");
                out.println("</Category>");
            }
        }
        finally {
            out.close();
        }
    }
}

