/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.LoadFilesMenuAction;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.ResourceLocator;

public class LoadFromURLMenuAction
extends MenuAction {
    static Logger log = Logger.getLogger(LoadFilesMenuAction.class);
    public static final String LOAD_FROM_DAS = "Load from DAS...";
    public static final String LOAD_FROM_URL = "Load from URL...";
    public static final String LOAD_GENOME_FROM_URL = "Load Genome from URL...";
    private IGV igv;

    public LoadFromURLMenuAction(String label, int mnemonic, IGV igv) {
        super(label, null, mnemonic);
        this.igv = igv;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        String url;
        JPanel ta = new JPanel();
        ta.setPreferredSize(new Dimension(600, 20));
        if (e2.getActionCommand().equalsIgnoreCase(LOAD_FROM_URL)) {
            String url2 = JOptionPane.showInputDialog(IGV.getMainFrame(), ta, "Enter URL (http or ftp)", 3);
            if (url2 != null && url2.trim().length() > 0) {
                if (url2.endsWith(".xml") || url2.endsWith(".session")) {
                    try {
                        boolean merge = false;
                        String locus = null;
                        this.igv.doRestoreSession(url2, locus, merge);
                    }
                    catch (Exception ex) {
                        MessageUtils.showMessage("Error loading url: " + url2 + " (" + ex.toString() + ")");
                    }
                } else {
                    ResourceLocator rl = new ResourceLocator(url2.trim());
                    this.igv.loadTracks(Arrays.asList(rl));
                }
            }
        } else if (e2.getActionCommand().equalsIgnoreCase(LOAD_FROM_DAS)) {
            String url3 = JOptionPane.showInputDialog(IGV.getMainFrame(), ta, "Enter DAS feature source URL", 3);
            if (url3 != null && url3.trim().length() > 0) {
                ResourceLocator rl = new ResourceLocator(url3.trim());
                rl.setType("das");
                this.igv.loadTracks(Arrays.asList(rl));
            }
        } else if (e2.getActionCommand().equalsIgnoreCase(LOAD_GENOME_FROM_URL) && (url = JOptionPane.showInputDialog(IGV.getMainFrame(), ta, "Enter URL to .genome or FASTA file", 3)) != null && url.trim().length() > 0) {
            try {
                this.igv.loadGenome(url.trim(), null, true);
            }
            catch (IOException e1) {
                MessageUtils.showMessage("Error loading genome: " + e1.getMessage());
            }
        }
    }
}

