/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileReader;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.CloseableIterator;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.apache.log4j.Logger;
import org.broad.igv.DirectoryManager;
import org.broad.igv.Globals;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.sam.PicardAlignment;
import org.broad.igv.sam.reader.AlignmentReader;
import org.broad.igv.sam.reader.AlignmentReaderFactory;
import org.broad.igv.sam.reader.WrappedIterator;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.stream.IGVSeekableBufferedStream;
import org.broad.igv.util.stream.IGVSeekableStreamFactory;

public class BAMHttpReader
implements AlignmentReader<PicardAlignment> {
    static Logger log = Logger.getLogger(BAMHttpReader.class);
    public static final long oneDay = 86400000L;
    static Hashtable<String, File> indexFileCache = new Hashtable();
    URL url;
    SAMFileHeader header;
    File indexFile;
    SAMFileReader reader;
    List<String> sequenceNames;

    public BAMHttpReader(ResourceLocator locator, boolean requireIndex) throws IOException {
        this.url = new URL(locator.getPath());
        if (requireIndex) {
            this.indexFile = this.getIndexFile(locator);
            if (this.indexFile == null) {
                throw new RuntimeException("Could not load index file for file: " + this.url.getPath());
            }
            IGVSeekableBufferedStream ss = new IGVSeekableBufferedStream(IGVSeekableStreamFactory.getInstance().getStreamFor(this.url), 128000);
            log.debug("Initializing SAMFileReader");
            this.reader = new SAMFileReader((SeekableStream)ss, this.indexFile, false);
        } else {
            InputStream is = HttpUtils.getInstance().openConnectionStream(this.url);
            this.reader = new SAMFileReader(new BufferedInputStream(is));
        }
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    @Override
    public SAMFileHeader getFileHeader() {
        if (this.header == null) {
            this.header = this.reader.getFileHeader();
        }
        return this.header;
    }

    @Override
    public Set<String> getPlatforms() {
        return AlignmentReaderFactory.getPlatforms(this.getFileHeader());
    }

    @Override
    public boolean hasIndex() {
        return this.indexFile != null && this.indexFile.exists();
    }

    @Override
    public List<String> getSequenceNames() {
        if (this.sequenceNames == null) {
            SAMFileHeader header = this.getFileHeader();
            if (header == null) {
                return null;
            }
            this.sequenceNames = new ArrayList<String>();
            List<SAMSequenceRecord> records = header.getSequenceDictionary().getSequences();
            if (records.size() > 0) {
                for (SAMSequenceRecord rec : header.getSequenceDictionary().getSequences()) {
                    String chr = rec.getSequenceName();
                    this.sequenceNames.add(chr);
                }
            }
        }
        return this.sequenceNames;
    }

    @Override
    public CloseableIterator<PicardAlignment> iterator() {
        try {
            if (this.reader == null) {
                InputStream is = HttpUtils.getInstance().openConnectionStream(this.url);
                this.reader = new SAMFileReader(new BufferedInputStream(is));
            }
            return new WrappedIterator(this.reader.iterator());
        }
        catch (IOException e2) {
            log.error("Error creating iterator", e2);
            throw new RuntimeException(e2);
        }
    }

    @Override
    public CloseableIterator<PicardAlignment> query(String sequence, int start, int end, boolean contained) {
        try {
            if (this.reader == null) {
                IGVSeekableBufferedStream ss = new IGVSeekableBufferedStream(IGVSeekableStreamFactory.getInstance().getStreamFor(this.url));
                this.reader = new SAMFileReader((SeekableStream)ss, this.indexFile, false);
            }
            SAMRecordIterator iter = this.reader.query(sequence, start + 1, end, contained);
            return new WrappedIterator(iter);
        }
        catch (IOException e2) {
            log.error("Error opening SAM reader", e2);
            throw new RuntimeException("Error opening SAM reader", e2);
        }
    }

    File getIndexFile(ResourceLocator locator) throws IOException {
        log.debug("Getting index for " + this.url + ". Index path " + locator.getBamIndexPath());
        String urlString = this.url.toString();
        this.indexFile = this.getTmpIndexFile(urlString);
        long age = System.currentTimeMillis() - this.indexFile.lastModified();
        if (age > 86400000L) {
            this.indexFile.delete();
        }
        if (!this.indexFile.exists() || this.indexFile.length() < 1L) {
            this.loadIndexFile(locator.getBamIndexPath(), this.indexFile);
            this.indexFile.deleteOnExit();
        }
        return this.indexFile;
    }

    private File getTmpIndexFile(String bamURL) throws IOException {
        File indexFile = indexFileCache.get(bamURL);
        if (indexFile == null) {
            indexFile = File.createTempFile("index_", ".bai", DirectoryManager.getCacheDirectory());
            indexFile.deleteOnExit();
            indexFileCache.put(bamURL, indexFile);
        }
        return indexFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIndexFile(String indexPath, File indexFile) throws IOException {
        InputStream is = null;
        OutputStream os = null;
        try {
            int bytesRead;
            boolean foundIndex;
            block24: {
                String gzippedPath = indexPath + ".gz";
                URL indexURL = new URL(gzippedPath);
                os = new FileOutputStream(indexFile);
                foundIndex = true;
                try {
                    is = new GZIPInputStream(HttpUtils.getInstance().openConnectionStream(indexURL));
                }
                catch (Exception e2) {
                    indexURL = new URL(indexPath);
                    try {
                        is = HttpUtils.getInstance().openConnectionStream(indexURL);
                    }
                    catch (FileNotFoundException e1) {
                        indexPath = indexPath.replace(".bam.bai", ".bai");
                        indexURL = new URL(indexPath);
                        try {
                            is = HttpUtils.getInstance().openConnectionStream(indexURL);
                        }
                        catch (FileNotFoundException e22) {
                            if (Globals.isHeadless() || !IGV.hasInstance()) break block24;
                            String tmp = MessageUtils.showInputDialog("Index file not found. Enter path to index file", indexPath);
                            if (tmp != null) {
                                try {
                                    indexURL = new URL(tmp);
                                    is = HttpUtils.getInstance().openConnectionStream(indexURL);
                                }
                                catch (FileNotFoundException e3) {
                                    foundIndex = false;
                                }
                                break block24;
                            }
                            foundIndex = false;
                        }
                    }
                }
            }
            if (!foundIndex) {
                String msg = "Index file not found: " + indexPath;
                throw new DataLoadException(msg, indexPath);
            }
            byte[] buf = new byte[512000];
            while ((bytesRead = is.read(buf)) != -1) {
                os.write(buf, 0, bytesRead);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e3) {
                    log.error(e3.getMessage(), e3);
                }
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e4) {
                    log.error(e4.getMessage(), e4);
                }
            }
        }
    }
}

