/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ga4gh;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.prefs.Preferences;
import org.apache.log4j.Logger;
import org.broad.igv.util.HttpUtils;

public class OAuthUtils {
    private static Logger log = Logger.getLogger(OAuthUtils.class);
    private static final String REFRESH_TOKEN_KEY = "oauth_refresh_token";
    private static final String PROPERTIES_URL = "https://igvdata.broadinstitute.org/app/oauth_native.json";
    private String scope = "https://www.googleapis.com/auth/genomics";
    private String state = "%2Fprofile";
    private String redirectURI = "http%3A%2F%2Flocalhost%3A60151%2FoauthCallback";
    private String clientId;
    private String clientSecret;
    private String authURI;
    private String tokenURI;
    private String authorizationCode;
    private String accessToken;
    private String refreshToken;
    private long expirationTime;
    private static OAuthUtils theInstance;

    public static synchronized OAuthUtils getInstance() {
        if (theInstance == null) {
            theInstance = new OAuthUtils();
        }
        return theInstance;
    }

    private OAuthUtils() {
        try {
            this.refreshToken = Preferences.userRoot().get(REFRESH_TOKEN_KEY, null);
        }
        catch (Exception e2) {
            log.error("Error fetching oauth refresh token", e2);
        }
    }

    private void fetchOauthProperties() throws IOException {
        String propString = HttpUtils.getInstance().getContentsAsString(new URL(PROPERTIES_URL));
        JsonParser parser = new JsonParser();
        JsonObject obj = parser.parse(propString).getAsJsonObject().get("installed").getAsJsonObject();
        this.authURI = obj.get("auth_uri").getAsString();
        this.clientSecret = obj.get("client_secret").getAsString();
        this.tokenURI = obj.get("token_uri").getAsString();
        this.clientId = obj.get("client_id").getAsString();
    }

    public void fetchAuthCode() throws IOException, URISyntaxException {
        if (this.clientId == null) {
            this.fetchOauthProperties();
        }
        String url = this.authURI + "?" + "scope=" + this.scope + "&" + "state=" + this.state + "&" + "redirect_uri=" + this.redirectURI + "&" + "response_type=code&" + "client_id=" + this.clientId;
        Desktop.getDesktop().browse(new URI(url));
    }

    public void setAuthorizationCode(String ac) throws IOException {
        this.authorizationCode = ac;
        this.fetchTokens();
    }

    public void fetchTokens() throws IOException {
        if (this.clientId == null) {
            this.fetchOauthProperties();
        }
        URL url = new URL(this.tokenURI);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("code", this.authorizationCode);
        params.put("client_id", this.clientId);
        params.put("client_secret", this.clientSecret);
        params.put("redirect_uri", this.redirectURI);
        params.put("grant_type", "authorization_code");
        String response = HttpUtils.getInstance().doPost(url, params);
        JsonParser parser = new JsonParser();
        JsonObject obj = parser.parse(response).getAsJsonObject();
        this.accessToken = obj.getAsJsonPrimitive("access_token").getAsString();
        this.refreshToken = obj.getAsJsonPrimitive("refresh_token").getAsString();
        this.expirationTime = System.currentTimeMillis() + (long)(obj.getAsJsonPrimitive("expires_in").getAsInt() * 1000);
        try {
            Preferences.userRoot().put(REFRESH_TOKEN_KEY, this.refreshToken);
        }
        catch (Exception e2) {
            log.error("Error storing refresh token", e2);
        }
    }

    public void fetchAccessToken() throws IOException {
        if (this.clientId == null) {
            this.fetchOauthProperties();
        }
        URL url = new URL(this.tokenURI);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("refresh_token", this.refreshToken);
        params.put("client_id", this.clientId);
        params.put("client_secret", this.clientSecret);
        params.put("grant_type", "refresh_token");
        String response = HttpUtils.getInstance().doPost(url, params);
        JsonParser parser = new JsonParser();
        JsonObject obj = parser.parse(response).getAsJsonObject();
        this.accessToken = obj.getAsJsonPrimitive("access_token").getAsString();
        this.expirationTime = System.currentTimeMillis() + (long)(obj.getAsJsonPrimitive("expires_in").getAsInt() * 1000);
        try {
            Preferences.userRoot().put(REFRESH_TOKEN_KEY, this.refreshToken);
        }
        catch (Exception e2) {
            log.error("Error storing refresh token", e2);
        }
    }

    public String getAccessToken() {
        if ((this.accessToken == null || System.currentTimeMillis() > this.expirationTime - 60000L) && this.refreshToken != null) {
            try {
                this.fetchAccessToken();
            }
            catch (IOException e2) {
                log.error("Error fetching access token", e2);
            }
        }
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public boolean isLoggedIn() {
        return this.getAccessToken() != null;
    }

    public void logout() {
        this.accessToken = null;
        this.refreshToken = null;
        this.expirationTime = -1L;
        try {
            Preferences.userRoot().remove(REFRESH_TOKEN_KEY);
        }
        catch (Exception e2) {
            log.error("Error removing oauth refresh token", e2);
        }
    }

    public static void main(String[] args) throws IOException, URISyntaxException {
        OAuthUtils.getInstance().fetchAuthCode();
    }
}

