/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ga4gh;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.TextCigarCodec;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.sam.SAMAlignment;

public class Ga4ghAlignment
extends SAMAlignment {
    private final Map<String, String> tags;
    protected int alignmentStart;
    protected int alignmentEnd;
    int inferredInsertSize;
    int mappingQuality = 255;
    String readName;
    protected String readSequence;
    private boolean negativeStrand;
    private int readNumber;
    private boolean duplicateFragment;
    private int numberReads;
    private boolean properPlacement;
    private boolean supplementaryAlignment;
    private boolean failedVendorQualityChecks;
    private boolean secondaryAlignment;
    private String cigarString;
    private boolean mapped;
    static Map<String, String> CigarMap = new HashMap<String, String>();

    public Ga4ghAlignment(JsonObject json) {
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        this.readName = json.get("fragmentName").getAsString();
        this.properPlacement = json.has("properPlacement") ? json.get("properPlacement").getAsBoolean() : true;
        this.duplicateFragment = json.has("duplicateFragment") ? json.get("duplicateFragment").getAsBoolean() : false;
        this.numberReads = json.has("numberReads") ? json.get("numberReads").getAsInt() : 1;
        this.inferredInsertSize = json.has("fragmentLength") ? json.get("fragmentLength").getAsInt() : 0;
        this.readNumber = json.has("readNumber") ? json.get("readNumber").getAsInt() : 0;
        this.failedVendorQualityChecks = json.has("failedVendorQualityChecks") ? json.get("failedVendorQualityChecks").getAsBoolean() : false;
        JsonObject alignmentObject = json.getAsJsonObject("alignment");
        if (alignmentObject == null) {
            this.mapped = false;
        } else {
            this.mapped = true;
            JsonObject positionObject = alignmentObject.getAsJsonObject("position");
            String refName = positionObject.get("referenceName").getAsString();
            this.setChr(genome == null ? refName : genome.getChromosomeAlias(refName));
            this.alignmentStart = positionObject.get("position").getAsInt();
            this.mappingQuality = alignmentObject.has("mappingQuality") ? alignmentObject.get("mappingQuality").getAsInt() : 256;
            this.negativeStrand = positionObject.get("reverseStrand").getAsBoolean();
            this.cigarString = this.generateCigarString(alignmentObject.getAsJsonArray("cigar"));
            this.start = this.alignmentStart;
            this.end = this.alignmentEnd = this.alignmentStart + this.getReferenceLength(this.cigarString);
        }
        this.secondaryAlignment = json.has("secondaryAlignment") ? json.get("secondaryAlignment").getAsBoolean() : false;
        this.supplementaryAlignment = json.has("supplementaryAlignment") ? json.get("supplementaryAlignment").getAsBoolean() : false;
        this.readSequence = json.has("alignedSequence") ? json.get("alignedSequence").getAsString() : null;
        byte[] baseQualities = json.has("alignedQuality") ? this.generateBaseQualities(json.getAsJsonArray("alignedQuality")) : null;
        JsonObject mateObject = json.getAsJsonObject("nextMatePosition");
        if (mateObject == null) {
            this.setMate(new ReadMate("*", 0, false, true));
        } else {
            String mateReferenceName = mateObject.get("referenceName").getAsString();
            String mateChr = genome == null ? mateReferenceName : genome.getChromosomeAlias(mateReferenceName);
            int matePosition = Integer.parseInt(mateObject.get("position").getAsString());
            boolean mateNegStrand = mateObject.get("reverseStrand").getAsBoolean();
            this.setMate(new ReadMate(mateChr, matePosition, mateNegStrand, false));
        }
        JsonObject infoObject = json.getAsJsonObject("info");
        this.tags = this.generateTags(infoObject);
        this.setPairOrientation();
        this.setPairStrands();
        this.createAlignmentBlocks(this.cigarString, this.readSequence.getBytes(), baseQualities, null, null, -1);
    }

    private Map<String, String> generateTags(JsonObject infoObject) {
        HashMap<String, String> tags = new HashMap<String, String>();
        if (infoObject != null) {
            for (Map.Entry<String, JsonElement> entry : infoObject.entrySet()) {
                String key = entry.getKey();
                JsonArray valueArray = entry.getValue().getAsJsonArray();
                String value = valueArray.get(0).getAsString();
                for (int i2 = 1; i2 < valueArray.size(); ++i2) {
                    value = value + "," + valueArray.get(i2).getAsString();
                }
                tags.put(key, value);
            }
        }
        return tags;
    }

    private byte[] generateBaseQualities(JsonArray alignedQuality) {
        byte[] baseQualities = new byte[alignedQuality.size()];
        Iterator<JsonElement> iter = alignedQuality.iterator();
        int i2 = 0;
        while (iter.hasNext()) {
            baseQualities[i2++] = iter.next().getAsByte();
        }
        return baseQualities;
    }

    private String generateCigarString(JsonArray cigar) {
        StringBuffer cigarStr = new StringBuffer();
        Iterator<JsonElement> iter = cigar.iterator();
        while (iter.hasNext()) {
            JsonObject op = iter.next().getAsJsonObject();
            cigarStr.append(op.getAsJsonPrimitive("operationLength").getAsString());
            cigarStr.append(CigarMap.get(op.getAsJsonPrimitive("operation").getAsString()));
        }
        return cigarStr.toString();
    }

    @Override
    public int getAlignmentStart() {
        return this.alignmentStart;
    }

    @Override
    public int getAlignmentEnd() {
        return this.alignmentEnd;
    }

    @Override
    public String getReadName() {
        return this.readName;
    }

    @Override
    public int getMappingQuality() {
        return this.mappingQuality;
    }

    @Override
    public int getInferredInsertSize() {
        return this.inferredInsertSize;
    }

    @Override
    public String getCigarString() {
        return this.cigarString;
    }

    @Override
    public int getReadLength() {
        return this.readSequence.length();
    }

    @Override
    public String getReadSequence() {
        return this.readSequence;
    }

    @Override
    protected String getAttributeString(boolean truncate) {
        StringBuffer buffer = new StringBuffer();
        for (Map.Entry<String, String> entry : this.tags.entrySet()) {
            buffer.append(entry.getKey() + ": " + entry.getValue());
        }
        return buffer.toString();
    }

    @Override
    public boolean isFirstOfPair() {
        return this.readNumber == 0;
    }

    @Override
    public boolean isSecondOfPair() {
        return this.readNumber > 0;
    }

    @Override
    public boolean isDuplicate() {
        return this.duplicateFragment;
    }

    @Override
    public boolean isMapped() {
        return this.mapped;
    }

    @Override
    public boolean isPaired() {
        return this.numberReads > 1;
    }

    @Override
    public boolean isProperPair() {
        return this.properPlacement;
    }

    @Override
    public boolean isSupplementary() {
        return this.supplementaryAlignment;
    }

    @Override
    public boolean isVendorFailedRead() {
        return this.failedVendorQualityChecks;
    }

    @Override
    public boolean isPrimary() {
        return !this.secondaryAlignment;
    }

    @Override
    public Object getAttribute(String key) {
        return this.tags.get(key);
    }

    public int getReferenceLength(String cigarString) {
        TextCigarCodec codec = new TextCigarCodec();
        Cigar cigar = codec.decode(cigarString);
        return cigar.getReferenceLength();
    }

    @Override
    public boolean isNegativeStrand() {
        return this.negativeStrand;
    }

    static {
        CigarMap.put("ALIGNMENT_MATCH", "M");
        CigarMap.put("INSERT", "I");
        CigarMap.put("DELETE", "D");
        CigarMap.put("SKIP", "N");
        CigarMap.put("CLIP_SOFT", "S");
        CigarMap.put("CLIP_HARD", "H");
        CigarMap.put("PAD", "P");
        CigarMap.put("SEQUENCE_MATCH", "=");
        CigarMap.put("SEQUENCE_MISMATCH", "X");
    }
}

