/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.Feature;
import htsjdk.tribble.exception.CodecLineParsingException;
import htsjdk.tribble.readers.LineIterator;
import org.broad.igv.feature.tribble.FeatureFileHeader;
import org.broad.igv.feature.tribble.GFFCodec;
import org.broad.igv.renderer.SpliceJunctionRenderer;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.TrackType;
import org.broad.igv.util.ParsingUtils;

public abstract class UCSCCodec<T extends Feature>
extends AsciiFeatureCodec<T> {
    GFFCodec.GFF3Helper tagHelper = new GFFCodec.GFF3Helper();
    protected boolean gffTags = false;
    protected boolean spliceJunctions;
    FeatureFileHeader header;

    protected UCSCCodec(Class myClass) {
        super(myClass);
    }

    @Override
    public Object readActualHeader(LineIterator reader) {
        try {
            String line;
            while (reader.hasNext() && ((line = reader.peek()).startsWith("#") || line.startsWith("track") || line.startsWith("browser"))) {
                this.readHeaderLine(line);
                reader.next();
            }
            return this.header;
        }
        catch (Exception e2) {
            throw new CodecLineParsingException("Error parsing header", e2);
        }
    }

    protected boolean readHeaderLine(String line) {
        if (this.header == null) {
            this.header = new FeatureFileHeader();
        }
        if (line.startsWith("#type")) {
            String[] tokens = line.split("=");
            if (tokens.length > 1) {
                try {
                    this.header.setTrackType(TrackType.valueOf(tokens[1]));
                }
                catch (Exception e2) {}
            }
        } else if (line.startsWith("#track") || line.startsWith("track")) {
            TrackProperties tp = new TrackProperties();
            ParsingUtils.parseTrackLine(line, tp);
            this.header.setTrackProperties(tp);
            this.gffTags = tp.isGffTags();
            Class rendererClass = tp.getRendererClass();
            if (rendererClass != null && rendererClass.isAssignableFrom(SpliceJunctionRenderer.class)) {
                this.spliceJunctions = true;
            }
        } else if (line.toLowerCase().contains("#gfftags")) {
            this.gffTags = true;
        } else {
            return false;
        }
        return true;
    }

    @Override
    public Feature decodeLoc(String line) {
        return this.decode(line);
    }

    public void setSpliceJunctions(boolean b2) {
        this.spliceJunctions = true;
    }
}

