/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.cursor;

import java.awt.Color;
import java.awt.Graphics;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.broad.igv.cursor.CursorModel;
import org.broad.igv.cursor.CursorRegion;
import org.broad.igv.cursor.CursorTrack;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.ui.color.ColorUtilities;

public class CursorIdeogramPanel
extends JComponent
implements Serializable {
    CursorModel model;
    List<CursorTrack> tracks = new ArrayList<CursorTrack>();
    boolean drawViewRect = true;

    public static double getAlpha(double minRange, double maxRange, double value) {
        double binWidth = (maxRange - minRange) / 9.0;
        int binNumber = (int)((value - minRange) / binWidth);
        return Math.min(1.0, 0.2 + (double)binNumber * 0.8 / 9.0);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.setColor(Color.gray);
        graphics.drawLine(0, 0, 0, this.getHeight());
        if (this.tracks.size() > 0) {
            this.paintBackground(graphics);
        }
        if (this.model != null && this.model.getFilteredRegions() != null && this.drawViewRect) {
            int length = this.model.getFilteredRegions().size();
            if (length == 0) {
                return;
            }
            int px = (int)(this.model.getOrigin() / (double)length * (double)this.getWidth());
            double nFrames = (double)this.getWidth() / this.model.getFramePixelWidth();
            int width = Math.max(1, (int)(nFrames / (double)length * (double)this.getWidth()));
            graphics.setColor(Color.black);
            graphics.drawRect(px, 0, width, this.getHeight() - 1);
            graphics.drawRect(px + 1, 1, width - 2, this.getHeight() - 2);
        }
    }

    public void setModel(CursorModel model) {
        this.model = model;
    }

    private void paintBackground(Graphics graphics) {
        if (this.model == null || this.tracks.isEmpty()) {
            return;
        }
        List<CursorRegion> frameList = this.model.getFilteredRegions();
        if (frameList == null) {
            return;
        }
        double sampleInterval = (double)frameList.size() / (double)this.getWidth();
        int bh = this.getHeight() - 2;
        double dh = (double)bh / (double)this.tracks.size();
        int px = 0;
        for (double frameNumber = 0.0; frameNumber < (double)frameList.size(); frameNumber += sampleInterval) {
            CursorRegion frame = frameList.get((int)frameNumber);
            String chr = frame.getChr();
            int maxFeatureHeight = (int)dh;
            graphics.setColor(Color.white);
            graphics.drawLine(px, 0, px, this.getHeight());
            double base = dh + 1.0;
            for (CursorTrack track : this.tracks) {
                CursorTrack.Range yScale = track.getScale();
                double min = yScale.getMin();
                double max = yScale.getMax();
                List<BasicFeature> features = track.getFeatures(chr);
                if (features == null) continue;
                int l2 = track.getLongestFeatureLength(chr);
                CursorRegion.FeatureIterator regionFeatures = frame.getFeatureIterator(features, l2, this.model.getFrameBPWidth());
                while (regionFeatures.hasNext()) {
                    BasicFeature f2 = (BasicFeature)regionFeatures.next();
                    Color c2 = track.getColor();
                    float score = track.getSignal(f2);
                    double alpha = Float.isNaN(score) ? 1.0 : CursorIdeogramPanel.getAlpha(min, max, score);
                    c2 = ColorUtilities.getCompositeColor(c2, (float)alpha);
                    graphics.setColor(c2);
                    graphics.drawLine(px, (int)base - maxFeatureHeight, px, (int)base);
                }
                base += dh;
            }
            ++px;
        }
    }

    public void addTrack(CursorTrack track) {
        this.tracks.add(track);
    }
}

