/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.cli_plugin;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMTextWriter;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.broad.igv.cli_plugin.Argument;
import org.broad.igv.cli_plugin.FeatureEncoder;
import org.broad.igv.sam.PicardAlignment;

public class SamAlignmentEncoder
implements FeatureEncoder<PicardAlignment> {
    private boolean headerSet = false;

    @Override
    public Map<String, Object> encodeAll(OutputStream stream, Iterator<? extends PicardAlignment> alignments) {
        SAMTextWriter writer = new SAMTextWriter(stream);
        while (alignments.hasNext()) {
            PicardAlignment samAl = alignments.next();
            if (!this.headerSet) {
                writer.setSortOrder(SAMFileHeader.SortOrder.unsorted, true);
                writer.setHeader(samAl.getRecord().getHeader());
                this.headerSet = true;
            }
            writer.addAlignment(samAl.getRecord());
        }
        writer.close();
        return null;
    }

    @Override
    public void setInputs(List<String> commands, Map<Argument, Object> argumentMap, Argument argument) {
    }
}

