/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECMultiplier;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.PreCompInfo;
import org.bouncycastle.math.ec.Tnaf;
import org.bouncycastle.math.ec.WTauNafPreCompInfo;
import org.bouncycastle.math.ec.ZTauElement;

class WTauNafMultiplier
implements ECMultiplier {
    WTauNafMultiplier() {
    }

    public ECPoint multiply(ECPoint point, BigInteger k2, PreCompInfo preCompInfo) {
        if (!(point instanceof ECPoint.F2m)) {
            throw new IllegalArgumentException("Only ECPoint.F2m can be used in WTauNafMultiplier");
        }
        ECPoint.F2m p2 = (ECPoint.F2m)point;
        ECCurve.F2m curve = (ECCurve.F2m)p2.getCurve();
        int m2 = curve.getM();
        byte a2 = curve.getA().toBigInteger().byteValue();
        byte mu = curve.getMu();
        BigInteger[] s2 = curve.getSi();
        ZTauElement rho = Tnaf.partModReduction(k2, m2, a2, s2, mu, (byte)10);
        return this.multiplyWTnaf(p2, rho, preCompInfo, a2, mu);
    }

    private ECPoint.F2m multiplyWTnaf(ECPoint.F2m p2, ZTauElement lambda, PreCompInfo preCompInfo, byte a2, byte mu) {
        ZTauElement[] alpha = a2 == 0 ? Tnaf.alpha0 : Tnaf.alpha1;
        BigInteger tw = Tnaf.getTw(mu, 4);
        byte[] u2 = Tnaf.tauAdicWNaf(mu, lambda, (byte)4, BigInteger.valueOf(16L), tw, alpha);
        return WTauNafMultiplier.multiplyFromWTnaf(p2, u2, preCompInfo);
    }

    private static ECPoint.F2m multiplyFromWTnaf(ECPoint.F2m p2, byte[] u2, PreCompInfo preCompInfo) {
        ECPoint.F2m[] pu;
        ECCurve.F2m curve = (ECCurve.F2m)p2.getCurve();
        byte a2 = curve.getA().toBigInteger().byteValue();
        if (preCompInfo == null || !(preCompInfo instanceof WTauNafPreCompInfo)) {
            pu = Tnaf.getPreComp(p2, a2);
            p2.setPreCompInfo(new WTauNafPreCompInfo(pu));
        } else {
            pu = ((WTauNafPreCompInfo)preCompInfo).getPreComp();
        }
        ECPoint.F2m q2 = (ECPoint.F2m)p2.getCurve().getInfinity();
        for (int i2 = u2.length - 1; i2 >= 0; --i2) {
            q2 = Tnaf.tau(q2);
            if (u2[i2] == 0) continue;
            q2 = u2[i2] > 0 ? q2.addSimple(pu[u2[i2]]) : q2.subtractSimple(pu[-u2[i2]]);
        }
        return q2;
    }
}

