/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.ECMultiplier;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.PreCompInfo;
import org.bouncycastle.math.ec.WNafPreCompInfo;

class WNafMultiplier
implements ECMultiplier {
    WNafMultiplier() {
    }

    public byte[] windowNaf(byte width, BigInteger k2) {
        byte[] wnaf = new byte[k2.bitLength() + 1];
        short pow2wB = (short)(1 << width);
        BigInteger pow2wBI = BigInteger.valueOf(pow2wB);
        int i2 = 0;
        int length = 0;
        while (k2.signum() > 0) {
            if (k2.testBit(0)) {
                BigInteger remainder = k2.mod(pow2wBI);
                wnaf[i2] = remainder.testBit(width - 1) ? (byte)(remainder.intValue() - pow2wB) : (byte)remainder.intValue();
                k2 = k2.subtract(BigInteger.valueOf(wnaf[i2]));
                length = i2;
            } else {
                wnaf[i2] = 0;
            }
            k2 = k2.shiftRight(1);
            ++i2;
        }
        byte[] wnafShort = new byte[++length];
        System.arraycopy(wnaf, 0, wnafShort, 0, length);
        return wnafShort;
    }

    public ECPoint multiply(ECPoint p2, BigInteger k2, PreCompInfo preCompInfo) {
        int reqPreCompLen;
        byte width;
        WNafPreCompInfo wnafPreCompInfo = preCompInfo != null && preCompInfo instanceof WNafPreCompInfo ? (WNafPreCompInfo)preCompInfo : new WNafPreCompInfo();
        int m2 = k2.bitLength();
        if (m2 < 13) {
            width = 2;
            reqPreCompLen = 1;
        } else if (m2 < 41) {
            width = 3;
            reqPreCompLen = 2;
        } else if (m2 < 121) {
            width = 4;
            reqPreCompLen = 4;
        } else if (m2 < 337) {
            width = 5;
            reqPreCompLen = 8;
        } else if (m2 < 897) {
            width = 6;
            reqPreCompLen = 16;
        } else if (m2 < 2305) {
            width = 7;
            reqPreCompLen = 32;
        } else {
            width = 8;
            reqPreCompLen = 127;
        }
        int preCompLen = 1;
        ECPoint[] preComp = wnafPreCompInfo.getPreComp();
        ECPoint twiceP = wnafPreCompInfo.getTwiceP();
        if (preComp == null) {
            preComp = new ECPoint[]{p2};
        } else {
            preCompLen = preComp.length;
        }
        if (twiceP == null) {
            twiceP = p2.twice();
        }
        if (preCompLen < reqPreCompLen) {
            ECPoint[] oldPreComp = preComp;
            preComp = new ECPoint[reqPreCompLen];
            System.arraycopy(oldPreComp, 0, preComp, 0, preCompLen);
            for (int i2 = preCompLen; i2 < reqPreCompLen; ++i2) {
                preComp[i2] = twiceP.add(preComp[i2 - 1]);
            }
        }
        byte[] wnaf = this.windowNaf(width, k2);
        int l2 = wnaf.length;
        ECPoint q2 = p2.getCurve().getInfinity();
        for (int i3 = l2 - 1; i3 >= 0; --i3) {
            q2 = q2.twice();
            if (wnaf[i3] == 0) continue;
            q2 = wnaf[i3] > 0 ? q2.add(preComp[(wnaf[i3] - 1) / 2]) : q2.subtract(preComp[(-wnaf[i3] - 1) / 2]);
        }
        wnafPreCompInfo.setPreComp(preComp);
        wnafPreCompInfo.setTwiceP(twiceP);
        p2.setPreCompInfo(wnafPreCompInfo);
        return q2;
    }
}

