/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.SimpleBigDecimal;
import org.bouncycastle.math.ec.ZTauElement;

class Tnaf {
    private static final BigInteger MINUS_ONE = ECConstants.ONE.negate();
    private static final BigInteger MINUS_TWO = ECConstants.TWO.negate();
    private static final BigInteger MINUS_THREE = ECConstants.THREE.negate();
    public static final byte WIDTH = 4;
    public static final byte POW_2_WIDTH = 16;
    public static final ZTauElement[] alpha0 = new ZTauElement[]{null, new ZTauElement(ECConstants.ONE, ECConstants.ZERO), null, new ZTauElement(MINUS_THREE, MINUS_ONE), null, new ZTauElement(MINUS_ONE, MINUS_ONE), null, new ZTauElement(ECConstants.ONE, MINUS_ONE), null};
    public static final byte[][] alpha0Tnaf = new byte[][]{null, {1}, null, {-1, 0, 1}, null, {1, 0, 1}, null, {-1, 0, 0, 1}};
    public static final ZTauElement[] alpha1 = new ZTauElement[]{null, new ZTauElement(ECConstants.ONE, ECConstants.ZERO), null, new ZTauElement(MINUS_THREE, ECConstants.ONE), null, new ZTauElement(MINUS_ONE, ECConstants.ONE), null, new ZTauElement(ECConstants.ONE, ECConstants.ONE), null};
    public static final byte[][] alpha1Tnaf = new byte[][]{null, {1}, null, {-1, 0, 1}, null, {1, 0, 1}, null, {-1, 0, 0, -1}};

    Tnaf() {
    }

    public static BigInteger norm(byte mu, ZTauElement lambda) {
        BigInteger norm;
        BigInteger s1 = lambda.u.multiply(lambda.u);
        BigInteger s2 = lambda.u.multiply(lambda.v);
        BigInteger s3 = lambda.v.multiply(lambda.v).shiftLeft(1);
        if (mu == 1) {
            norm = s1.add(s2).add(s3);
        } else if (mu == -1) {
            norm = s1.subtract(s2).add(s3);
        } else {
            throw new IllegalArgumentException("mu must be 1 or -1");
        }
        return norm;
    }

    public static SimpleBigDecimal norm(byte mu, SimpleBigDecimal u2, SimpleBigDecimal v2) {
        SimpleBigDecimal norm;
        SimpleBigDecimal s1 = u2.multiply(u2);
        SimpleBigDecimal s2 = u2.multiply(v2);
        SimpleBigDecimal s3 = v2.multiply(v2).shiftLeft(1);
        if (mu == 1) {
            norm = s1.add(s2).add(s3);
        } else if (mu == -1) {
            norm = s1.subtract(s2).add(s3);
        } else {
            throw new IllegalArgumentException("mu must be 1 or -1");
        }
        return norm;
    }

    public static ZTauElement round(SimpleBigDecimal lambda0, SimpleBigDecimal lambda1, byte mu) {
        SimpleBigDecimal check2;
        SimpleBigDecimal check1;
        int scale = lambda0.getScale();
        if (lambda1.getScale() != scale) {
            throw new IllegalArgumentException("lambda0 and lambda1 do not have same scale");
        }
        if (mu != 1 && mu != -1) {
            throw new IllegalArgumentException("mu must be 1 or -1");
        }
        BigInteger f0 = lambda0.round();
        BigInteger f1 = lambda1.round();
        SimpleBigDecimal eta0 = lambda0.subtract(f0);
        SimpleBigDecimal eta1 = lambda1.subtract(f1);
        SimpleBigDecimal eta = eta0.add(eta0);
        eta = mu == 1 ? eta.add(eta1) : eta.subtract(eta1);
        SimpleBigDecimal threeEta1 = eta1.add(eta1).add(eta1);
        SimpleBigDecimal fourEta1 = threeEta1.add(eta1);
        if (mu == 1) {
            check1 = eta0.subtract(threeEta1);
            check2 = eta0.add(fourEta1);
        } else {
            check1 = eta0.add(threeEta1);
            check2 = eta0.subtract(fourEta1);
        }
        int h0 = 0;
        byte h1 = 0;
        if (eta.compareTo(ECConstants.ONE) >= 0) {
            if (check1.compareTo(MINUS_ONE) < 0) {
                h1 = mu;
            } else {
                h0 = 1;
            }
        } else if (check2.compareTo(ECConstants.TWO) >= 0) {
            h1 = mu;
        }
        if (eta.compareTo(MINUS_ONE) < 0) {
            if (check1.compareTo(ECConstants.ONE) >= 0) {
                h1 = -mu;
            } else {
                h0 = -1;
            }
        } else if (check2.compareTo(MINUS_TWO) < 0) {
            h1 = -mu;
        }
        BigInteger q0 = f0.add(BigInteger.valueOf(h0));
        BigInteger q1 = f1.add(BigInteger.valueOf(h1));
        return new ZTauElement(q0, q1);
    }

    public static SimpleBigDecimal approximateDivisionByN(BigInteger k2, BigInteger s2, BigInteger vm, byte a2, int m2, int c2) {
        int _k = (m2 + 5) / 2 + c2;
        BigInteger ns = k2.shiftRight(m2 - _k - 2 + a2);
        BigInteger gs = s2.multiply(ns);
        BigInteger hs = gs.shiftRight(m2);
        BigInteger js = vm.multiply(hs);
        BigInteger gsPlusJs = gs.add(js);
        BigInteger ls = gsPlusJs.shiftRight(_k - c2);
        if (gsPlusJs.testBit(_k - c2 - 1)) {
            ls = ls.add(ECConstants.ONE);
        }
        return new SimpleBigDecimal(ls, c2);
    }

    public static byte[] tauAdicNaf(byte mu, ZTauElement lambda) {
        if (mu != 1 && mu != -1) {
            throw new IllegalArgumentException("mu must be 1 or -1");
        }
        BigInteger norm = Tnaf.norm(mu, lambda);
        int log2Norm = norm.bitLength();
        int maxLength = log2Norm > 30 ? log2Norm + 4 : 34;
        byte[] u2 = new byte[maxLength];
        int i2 = 0;
        int length = 0;
        BigInteger r0 = lambda.u;
        BigInteger r1 = lambda.v;
        while (!r0.equals(ECConstants.ZERO) || !r1.equals(ECConstants.ZERO)) {
            if (r0.testBit(0)) {
                u2[i2] = (byte)ECConstants.TWO.subtract(r0.subtract(r1.shiftLeft(1)).mod(ECConstants.FOUR)).intValue();
                r0 = u2[i2] == 1 ? r0.clearBit(0) : r0.add(ECConstants.ONE);
                length = i2;
            } else {
                u2[i2] = 0;
            }
            BigInteger t2 = r0;
            BigInteger s2 = r0.shiftRight(1);
            r0 = mu == 1 ? r1.add(s2) : r1.subtract(s2);
            r1 = t2.shiftRight(1).negate();
            ++i2;
        }
        byte[] tnaf = new byte[++length];
        System.arraycopy(u2, 0, tnaf, 0, length);
        return tnaf;
    }

    public static ECPoint.F2m tau(ECPoint.F2m p2) {
        if (p2.isInfinity()) {
            return p2;
        }
        ECFieldElement x2 = p2.getX();
        ECFieldElement y = p2.getY();
        return new ECPoint.F2m(p2.getCurve(), x2.square(), y.square(), p2.isCompressed());
    }

    public static byte getMu(ECCurve.F2m curve) {
        byte mu;
        BigInteger a2 = curve.getA().toBigInteger();
        if (a2.equals(ECConstants.ZERO)) {
            mu = -1;
        } else if (a2.equals(ECConstants.ONE)) {
            mu = 1;
        } else {
            throw new IllegalArgumentException("No Koblitz curve (ABC), TNAF multiplication not possible");
        }
        return mu;
    }

    public static BigInteger[] getLucas(byte mu, int k2, boolean doV) {
        BigInteger u1;
        BigInteger u0;
        if (mu != 1 && mu != -1) {
            throw new IllegalArgumentException("mu must be 1 or -1");
        }
        if (doV) {
            u0 = ECConstants.TWO;
            u1 = BigInteger.valueOf(mu);
        } else {
            u0 = ECConstants.ZERO;
            u1 = ECConstants.ONE;
        }
        for (int i2 = 1; i2 < k2; ++i2) {
            BigInteger s2 = null;
            s2 = mu == 1 ? u1 : u1.negate();
            BigInteger u2 = s2.subtract(u0.shiftLeft(1));
            u0 = u1;
            u1 = u2;
        }
        BigInteger[] retVal = new BigInteger[]{u0, u1};
        return retVal;
    }

    public static BigInteger getTw(byte mu, int w2) {
        if (w2 == 4) {
            if (mu == 1) {
                return BigInteger.valueOf(6L);
            }
            return BigInteger.valueOf(10L);
        }
        BigInteger[] us = Tnaf.getLucas(mu, w2, false);
        BigInteger twoToW = ECConstants.ZERO.setBit(w2);
        BigInteger u1invert = us[1].modInverse(twoToW);
        BigInteger tw = ECConstants.TWO.multiply(us[0]).multiply(u1invert).mod(twoToW);
        return tw;
    }

    public static BigInteger[] getSi(ECCurve.F2m curve) {
        BigInteger dividend1;
        BigInteger dividend0;
        if (!curve.isKoblitz()) {
            throw new IllegalArgumentException("si is defined for Koblitz curves only");
        }
        int m2 = curve.getM();
        int a2 = curve.getA().toBigInteger().intValue();
        byte mu = curve.getMu();
        int h2 = curve.getH().intValue();
        int index = m2 + 3 - a2;
        BigInteger[] ui = Tnaf.getLucas(mu, index, false);
        if (mu == 1) {
            dividend0 = ECConstants.ONE.subtract(ui[1]);
            dividend1 = ECConstants.ONE.subtract(ui[0]);
        } else if (mu == -1) {
            dividend0 = ECConstants.ONE.add(ui[1]);
            dividend1 = ECConstants.ONE.add(ui[0]);
        } else {
            throw new IllegalArgumentException("mu must be 1 or -1");
        }
        BigInteger[] si = new BigInteger[2];
        if (h2 == 2) {
            si[0] = dividend0.shiftRight(1);
            si[1] = dividend1.shiftRight(1).negate();
        } else if (h2 == 4) {
            si[0] = dividend0.shiftRight(2);
            si[1] = dividend1.shiftRight(2).negate();
        } else {
            throw new IllegalArgumentException("h (Cofactor) must be 2 or 4");
        }
        return si;
    }

    public static ZTauElement partModReduction(BigInteger k2, int m2, byte a2, BigInteger[] s2, byte mu, byte c2) {
        BigInteger d0 = mu == 1 ? s2[0].add(s2[1]) : s2[0].subtract(s2[1]);
        BigInteger[] v2 = Tnaf.getLucas(mu, m2, true);
        BigInteger vm = v2[1];
        SimpleBigDecimal lambda0 = Tnaf.approximateDivisionByN(k2, s2[0], vm, a2, m2, c2);
        SimpleBigDecimal lambda1 = Tnaf.approximateDivisionByN(k2, s2[1], vm, a2, m2, c2);
        ZTauElement q2 = Tnaf.round(lambda0, lambda1, mu);
        BigInteger r0 = k2.subtract(d0.multiply(q2.u)).subtract(BigInteger.valueOf(2L).multiply(s2[1]).multiply(q2.v));
        BigInteger r1 = s2[1].multiply(q2.u).subtract(s2[0].multiply(q2.v));
        return new ZTauElement(r0, r1);
    }

    public static ECPoint.F2m multiplyRTnaf(ECPoint.F2m p2, BigInteger k2) {
        ECCurve.F2m curve = (ECCurve.F2m)p2.getCurve();
        int m2 = curve.getM();
        byte a2 = (byte)curve.getA().toBigInteger().intValue();
        byte mu = curve.getMu();
        BigInteger[] s2 = curve.getSi();
        ZTauElement rho = Tnaf.partModReduction(k2, m2, a2, s2, mu, (byte)10);
        return Tnaf.multiplyTnaf(p2, rho);
    }

    public static ECPoint.F2m multiplyTnaf(ECPoint.F2m p2, ZTauElement lambda) {
        ECCurve.F2m curve = (ECCurve.F2m)p2.getCurve();
        byte mu = curve.getMu();
        byte[] u2 = Tnaf.tauAdicNaf(mu, lambda);
        ECPoint.F2m q2 = Tnaf.multiplyFromTnaf(p2, u2);
        return q2;
    }

    public static ECPoint.F2m multiplyFromTnaf(ECPoint.F2m p2, byte[] u2) {
        ECCurve.F2m curve = (ECCurve.F2m)p2.getCurve();
        ECPoint.F2m q2 = (ECPoint.F2m)curve.getInfinity();
        for (int i2 = u2.length - 1; i2 >= 0; --i2) {
            q2 = Tnaf.tau(q2);
            if (u2[i2] == 1) {
                q2 = q2.addSimple(p2);
                continue;
            }
            if (u2[i2] != -1) continue;
            q2 = q2.subtractSimple(p2);
        }
        return q2;
    }

    public static byte[] tauAdicWNaf(byte mu, ZTauElement lambda, byte width, BigInteger pow2w, BigInteger tw, ZTauElement[] alpha) {
        if (mu != 1 && mu != -1) {
            throw new IllegalArgumentException("mu must be 1 or -1");
        }
        BigInteger norm = Tnaf.norm(mu, lambda);
        int log2Norm = norm.bitLength();
        int maxLength = log2Norm > 30 ? log2Norm + 4 + width : 34 + width;
        byte[] u2 = new byte[maxLength];
        BigInteger pow2wMin1 = pow2w.shiftRight(1);
        BigInteger r0 = lambda.u;
        BigInteger r1 = lambda.v;
        int i2 = 0;
        while (!r0.equals(ECConstants.ZERO) || !r1.equals(ECConstants.ZERO)) {
            if (r0.testBit(0)) {
                BigInteger uUnMod = r0.add(r1.multiply(tw)).mod(pow2w);
                byte uLocal = uUnMod.compareTo(pow2wMin1) >= 0 ? (byte)uUnMod.subtract(pow2w).intValue() : (byte)uUnMod.intValue();
                u2[i2] = uLocal;
                boolean s2 = true;
                if (uLocal < 0) {
                    s2 = false;
                    uLocal = -uLocal;
                }
                if (s2) {
                    r0 = r0.subtract(alpha[uLocal].u);
                    r1 = r1.subtract(alpha[uLocal].v);
                } else {
                    r0 = r0.add(alpha[uLocal].u);
                    r1 = r1.add(alpha[uLocal].v);
                }
            } else {
                u2[i2] = 0;
            }
            BigInteger t2 = r0;
            r0 = mu == 1 ? r1.add(r0.shiftRight(1)) : r1.subtract(r0.shiftRight(1));
            r1 = t2.shiftRight(1).negate();
            ++i2;
        }
        return u2;
    }

    public static ECPoint.F2m[] getPreComp(ECPoint.F2m p2, byte a2) {
        ECPoint.F2m[] pu = new ECPoint.F2m[16];
        pu[1] = p2;
        byte[][] alphaTnaf = a2 == 0 ? alpha0Tnaf : alpha1Tnaf;
        int precompLen = alphaTnaf.length;
        for (int i2 = 3; i2 < precompLen; i2 += 2) {
            pu[i2] = Tnaf.multiplyFromTnaf(p2, alphaTnaf[i2]);
        }
        return pu;
    }
}

