/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.BEROutputStream;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.pkcs.AuthenticatedSafe;
import org.bouncycastle.asn1.pkcs.CertBag;
import org.bouncycastle.asn1.pkcs.ContentInfo;
import org.bouncycastle.asn1.pkcs.EncryptedData;
import org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.MacData;
import org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.Pfx;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.SafeBag;
import org.bouncycastle.asn1.util.ASN1Dump;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.jcajce.provider.symmetric.util.BCPBEKey;
import org.bouncycastle.jce.interfaces.BCKeyStore;
import org.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.JDKPKCS12StoreParameter;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

public class JDKPKCS12KeyStore
extends KeyStoreSpi
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers,
BCKeyStore {
    private static final int SALT_SIZE = 20;
    private static final int MIN_ITERATIONS = 1024;
    private static final Provider bcProvider = new BouncyCastleProvider();
    private IgnoresCaseHashtable keys = new IgnoresCaseHashtable();
    private Hashtable localIds = new Hashtable();
    private IgnoresCaseHashtable certs = new IgnoresCaseHashtable();
    private Hashtable chainCerts = new Hashtable();
    private Hashtable keyCerts = new Hashtable();
    static final int NULL = 0;
    static final int CERTIFICATE = 1;
    static final int KEY = 2;
    static final int SECRET = 3;
    static final int SEALED = 4;
    static final int KEY_PRIVATE = 0;
    static final int KEY_PUBLIC = 1;
    static final int KEY_SECRET = 2;
    protected SecureRandom random = new SecureRandom();
    private CertificateFactory certFact;
    private ASN1ObjectIdentifier keyAlgorithm;
    private ASN1ObjectIdentifier certAlgorithm;

    public JDKPKCS12KeyStore(Provider provider, ASN1ObjectIdentifier keyAlgorithm, ASN1ObjectIdentifier certAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
        this.certAlgorithm = certAlgorithm;
        try {
            this.certFact = provider != null ? CertificateFactory.getInstance("X.509", provider) : CertificateFactory.getInstance("X.509");
        }
        catch (Exception e2) {
            throw new IllegalArgumentException("can't create cert factory - " + e2.toString());
        }
    }

    private SubjectKeyIdentifier createSubjectKeyId(PublicKey pubKey) {
        try {
            SubjectPublicKeyInfo info = new SubjectPublicKeyInfo((ASN1Sequence)ASN1Primitive.fromByteArray(pubKey.getEncoded()));
            return new SubjectKeyIdentifier(info);
        }
        catch (Exception e2) {
            throw new RuntimeException("error creating key");
        }
    }

    public void setRandom(SecureRandom rand) {
        this.random = rand;
    }

    public Enumeration engineAliases() {
        Hashtable<Object, String> tab = new Hashtable<Object, String>();
        Enumeration e2 = this.certs.keys();
        while (e2.hasMoreElements()) {
            tab.put(e2.nextElement(), "cert");
        }
        e2 = this.keys.keys();
        while (e2.hasMoreElements()) {
            String a2 = (String)e2.nextElement();
            if (tab.get(a2) != null) continue;
            tab.put(a2, "key");
        }
        return tab.keys();
    }

    public boolean engineContainsAlias(String alias) {
        return this.certs.get(alias) != null || this.keys.get(alias) != null;
    }

    public void engineDeleteEntry(String alias) throws KeyStoreException {
        Key k2 = (Key)this.keys.remove(alias);
        Certificate c2 = (Certificate)this.certs.remove(alias);
        if (c2 != null) {
            this.chainCerts.remove(new CertId(c2.getPublicKey()));
        }
        if (k2 != null) {
            String id = (String)this.localIds.remove(alias);
            if (id != null) {
                c2 = (Certificate)this.keyCerts.remove(id);
            }
            if (c2 != null) {
                this.chainCerts.remove(new CertId(c2.getPublicKey()));
            }
        }
        if (c2 == null && k2 == null) {
            throw new KeyStoreException("no such entry as " + alias);
        }
    }

    public Certificate engineGetCertificate(String alias) {
        if (alias == null) {
            throw new IllegalArgumentException("null alias passed to getCertificate.");
        }
        Certificate c2 = (Certificate)this.certs.get(alias);
        if (c2 == null) {
            String id = (String)this.localIds.get(alias);
            c2 = id != null ? (Certificate)this.keyCerts.get(id) : (Certificate)this.keyCerts.get(alias);
        }
        return c2;
    }

    public String engineGetCertificateAlias(Certificate cert) {
        String ta;
        Certificate tc;
        Enumeration c2 = this.certs.elements();
        Enumeration k2 = this.certs.keys();
        while (c2.hasMoreElements()) {
            tc = (Certificate)c2.nextElement();
            ta = (String)k2.nextElement();
            if (!tc.equals(cert)) continue;
            return ta;
        }
        c2 = this.keyCerts.elements();
        k2 = this.keyCerts.keys();
        while (c2.hasMoreElements()) {
            tc = (Certificate)c2.nextElement();
            ta = (String)k2.nextElement();
            if (!tc.equals(cert)) continue;
            return ta;
        }
        return null;
    }

    public Certificate[] engineGetCertificateChain(String alias) {
        if (alias == null) {
            throw new IllegalArgumentException("null alias passed to getCertificateChain.");
        }
        if (!this.engineIsKeyEntry(alias)) {
            return null;
        }
        Certificate c2 = this.engineGetCertificate(alias);
        if (c2 != null) {
            Vector<Certificate> cs = new Vector<Certificate>();
            while (c2 != null) {
                Principal s2;
                Principal i2;
                X509Certificate x509c = (X509Certificate)c2;
                Certificate nextC = null;
                byte[] bytes = x509c.getExtensionValue(X509Extensions.AuthorityKeyIdentifier.getId());
                if (bytes != null) {
                    try {
                        ASN1InputStream aIn = new ASN1InputStream(bytes);
                        byte[] authBytes = ((ASN1OctetString)aIn.readObject()).getOctets();
                        aIn = new ASN1InputStream(authBytes);
                        AuthorityKeyIdentifier id = AuthorityKeyIdentifier.getInstance((ASN1Sequence)aIn.readObject());
                        if (id.getKeyIdentifier() != null) {
                            nextC = (Certificate)this.chainCerts.get(new CertId(id.getKeyIdentifier()));
                        }
                    }
                    catch (IOException e2) {
                        throw new RuntimeException(e2.toString());
                    }
                }
                if (nextC == null && !((Object)(i2 = x509c.getIssuerDN())).equals(s2 = x509c.getSubjectDN())) {
                    Enumeration e3 = this.chainCerts.keys();
                    while (e3.hasMoreElements()) {
                        X509Certificate crt = (X509Certificate)this.chainCerts.get(e3.nextElement());
                        Principal sub = crt.getSubjectDN();
                        if (!((Object)sub).equals(i2)) continue;
                        try {
                            x509c.verify(crt.getPublicKey());
                            nextC = crt;
                            break;
                        }
                        catch (Exception ex) {
                        }
                    }
                }
                cs.addElement(c2);
                if (nextC != c2) {
                    c2 = nextC;
                    continue;
                }
                c2 = null;
            }
            Certificate[] certChain = new Certificate[cs.size()];
            for (int i3 = 0; i3 != certChain.length; ++i3) {
                certChain[i3] = (Certificate)cs.elementAt(i3);
            }
            return certChain;
        }
        return null;
    }

    public Date engineGetCreationDate(String alias) {
        return new Date();
    }

    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (alias == null) {
            throw new IllegalArgumentException("null alias passed to getKey.");
        }
        return (Key)this.keys.get(alias);
    }

    public boolean engineIsCertificateEntry(String alias) {
        return this.certs.get(alias) != null && this.keys.get(alias) == null;
    }

    public boolean engineIsKeyEntry(String alias) {
        return this.keys.get(alias) != null;
    }

    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        if (this.keys.get(alias) != null) {
            throw new KeyStoreException("There is a key entry with the name " + alias + ".");
        }
        this.certs.put(alias, cert);
        this.chainCerts.put(new CertId(cert.getPublicKey()), cert);
    }

    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        throw new RuntimeException("operation not supported");
    }

    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        if (key instanceof PrivateKey && chain == null) {
            throw new KeyStoreException("no certificate chain for private key");
        }
        if (this.keys.get(alias) != null) {
            this.engineDeleteEntry(alias);
        }
        this.keys.put(alias, key);
        this.certs.put(alias, chain[0]);
        for (int i2 = 0; i2 != chain.length; ++i2) {
            this.chainCerts.put(new CertId(chain[i2].getPublicKey()), chain[i2]);
        }
    }

    public int engineSize() {
        Hashtable<Object, String> tab = new Hashtable<Object, String>();
        Enumeration e2 = this.certs.keys();
        while (e2.hasMoreElements()) {
            tab.put(e2.nextElement(), "cert");
        }
        e2 = this.keys.keys();
        while (e2.hasMoreElements()) {
            String a2 = (String)e2.nextElement();
            if (tab.get(a2) != null) continue;
            tab.put(a2, "key");
        }
        return tab.size();
    }

    protected PrivateKey unwrapKey(AlgorithmIdentifier algId, byte[] data, char[] password, boolean wrongPKCS12Zero) throws IOException {
        PrivateKey out;
        String algorithm = algId.getAlgorithm().getId();
        PKCS12PBEParams pbeParams = PKCS12PBEParams.getInstance(algId.getParameters());
        PBEKeySpec pbeSpec = new PBEKeySpec(password);
        try {
            SecretKeyFactory keyFact = SecretKeyFactory.getInstance(algorithm, bcProvider);
            PBEParameterSpec defParams = new PBEParameterSpec(pbeParams.getIV(), pbeParams.getIterations().intValue());
            SecretKey k2 = keyFact.generateSecret(pbeSpec);
            ((BCPBEKey)k2).setTryWrongPKCS12Zero(wrongPKCS12Zero);
            Cipher cipher = Cipher.getInstance(algorithm, bcProvider);
            cipher.init(4, (Key)k2, defParams);
            out = (PrivateKey)cipher.unwrap(data, "", 2);
        }
        catch (Exception e2) {
            throw new IOException("exception unwrapping private key - " + e2.toString());
        }
        return out;
    }

    protected byte[] wrapKey(String algorithm, Key key, PKCS12PBEParams pbeParams, char[] password) throws IOException {
        byte[] out;
        PBEKeySpec pbeSpec = new PBEKeySpec(password);
        try {
            SecretKeyFactory keyFact = SecretKeyFactory.getInstance(algorithm, bcProvider);
            PBEParameterSpec defParams = new PBEParameterSpec(pbeParams.getIV(), pbeParams.getIterations().intValue());
            Cipher cipher = Cipher.getInstance(algorithm, bcProvider);
            cipher.init(3, (Key)keyFact.generateSecret(pbeSpec), defParams);
            out = cipher.wrap(key);
        }
        catch (Exception e2) {
            throw new IOException("exception encrypting data - " + e2.toString());
        }
        return out;
    }

    protected byte[] cryptData(boolean forEncryption, AlgorithmIdentifier algId, char[] password, boolean wrongPKCS12Zero, byte[] data) throws IOException {
        String algorithm = algId.getAlgorithm().getId();
        PKCS12PBEParams pbeParams = PKCS12PBEParams.getInstance(algId.getParameters());
        PBEKeySpec pbeSpec = new PBEKeySpec(password);
        try {
            SecretKeyFactory keyFact = SecretKeyFactory.getInstance(algorithm, bcProvider);
            PBEParameterSpec defParams = new PBEParameterSpec(pbeParams.getIV(), pbeParams.getIterations().intValue());
            BCPBEKey key = (BCPBEKey)keyFact.generateSecret(pbeSpec);
            key.setTryWrongPKCS12Zero(wrongPKCS12Zero);
            Cipher cipher = Cipher.getInstance(algorithm, bcProvider);
            int mode = forEncryption ? 1 : 2;
            cipher.init(mode, (Key)key, defParams);
            return cipher.doFinal(data);
        }
        catch (Exception e2) {
            throw new IOException("exception decrypting data - " + e2.toString());
        }
    }

    public void engineLoad(InputStream stream, char[] password) throws IOException {
        PKCS12BagAttributeCarrier bagAttr;
        if (stream == null) {
            return;
        }
        if (password == null) {
            throw new NullPointerException("No password supplied for PKCS#12 KeyStore.");
        }
        BufferedInputStream bufIn = new BufferedInputStream(stream);
        bufIn.mark(10);
        int head = bufIn.read();
        if (head != 48) {
            throw new IOException("stream does not represent a PKCS12 key store");
        }
        bufIn.reset();
        ASN1InputStream bIn = new ASN1InputStream(bufIn);
        ASN1Sequence obj = (ASN1Sequence)bIn.readObject();
        Pfx bag = Pfx.getInstance(obj);
        ContentInfo info = bag.getAuthSafe();
        Vector<SafeBag> chain = new Vector<SafeBag>();
        boolean unmarkedKey = false;
        boolean wrongPKCS12Zero = false;
        if (bag.getMacData() != null) {
            MacData mData = bag.getMacData();
            DigestInfo dInfo = mData.getMac();
            AlgorithmIdentifier algId = dInfo.getAlgorithmId();
            byte[] salt = mData.getSalt();
            int itCount = mData.getIterationCount().intValue();
            byte[] data = ((ASN1OctetString)info.getContent()).getOctets();
            try {
                byte[] res = JDKPKCS12KeyStore.calculatePbeMac(algId.getObjectId(), salt, itCount, password, false, data);
                byte[] dig = dInfo.getDigest();
                if (!Arrays.constantTimeAreEqual(res, dig)) {
                    if (password.length > 0) {
                        throw new IOException("PKCS12 key store mac invalid - wrong password or corrupted file.");
                    }
                    res = JDKPKCS12KeyStore.calculatePbeMac(algId.getObjectId(), salt, itCount, password, true, data);
                    if (!Arrays.constantTimeAreEqual(res, dig)) {
                        throw new IOException("PKCS12 key store mac invalid - wrong password or corrupted file.");
                    }
                    wrongPKCS12Zero = true;
                }
            }
            catch (IOException e2) {
                throw e2;
            }
            catch (Exception e3) {
                throw new IOException("error constructing MAC: " + e3.toString());
            }
        }
        this.keys = new IgnoresCaseHashtable();
        this.localIds = new Hashtable();
        if (info.getContentType().equals(data)) {
            bIn = new ASN1InputStream(((ASN1OctetString)info.getContent()).getOctets());
            AuthenticatedSafe authSafe = AuthenticatedSafe.getInstance(bIn.readObject());
            ContentInfo[] c2 = authSafe.getContentInfo();
            for (int i2 = 0; i2 != c2.length; ++i2) {
                if (c2[i2].getContentType().equals(data)) {
                    ASN1InputStream dIn = new ASN1InputStream(((ASN1OctetString)c2[i2].getContent()).getOctets());
                    ASN1Sequence seq = (ASN1Sequence)dIn.readObject();
                    for (int j2 = 0; j2 != seq.size(); ++j2) {
                        SafeBag b2 = SafeBag.getInstance(seq.getObjectAt(j2));
                        if (b2.getBagId().equals(pkcs8ShroudedKeyBag)) {
                            EncryptedPrivateKeyInfo eIn = EncryptedPrivateKeyInfo.getInstance(b2.getBagValue());
                            PrivateKey privKey = this.unwrapKey(eIn.getEncryptionAlgorithm(), eIn.getEncryptedData(), password, wrongPKCS12Zero);
                            PKCS12BagAttributeCarrier bagAttr2 = (PKCS12BagAttributeCarrier)((Object)privKey);
                            String alias = null;
                            ASN1OctetString localId = null;
                            if (b2.getBagAttributes() != null) {
                                Enumeration e4 = b2.getBagAttributes().getObjects();
                                while (e4.hasMoreElements()) {
                                    ASN1Sequence sq = (ASN1Sequence)e4.nextElement();
                                    ASN1ObjectIdentifier aOid = (ASN1ObjectIdentifier)sq.getObjectAt(0);
                                    ASN1Set attrSet = (ASN1Set)sq.getObjectAt(1);
                                    ASN1Primitive attr = null;
                                    if (attrSet.size() > 0) {
                                        attr = (ASN1Primitive)attrSet.getObjectAt(0);
                                        ASN1Encodable existing = bagAttr2.getBagAttribute(aOid);
                                        if (existing != null) {
                                            if (!existing.toASN1Primitive().equals(attr)) {
                                                throw new IOException("attempt to add existing attribute with different value");
                                            }
                                        } else {
                                            bagAttr2.setBagAttribute(aOid, attr);
                                        }
                                    }
                                    if (aOid.equals(pkcs_9_at_friendlyName)) {
                                        alias = ((DERBMPString)attr).getString();
                                        this.keys.put(alias, privKey);
                                        continue;
                                    }
                                    if (!aOid.equals(pkcs_9_at_localKeyId)) continue;
                                    localId = (ASN1OctetString)attr;
                                }
                            }
                            if (localId != null) {
                                String name = new String(Hex.encode(localId.getOctets()));
                                if (alias == null) {
                                    this.keys.put(name, privKey);
                                    continue;
                                }
                                this.localIds.put(alias, name);
                                continue;
                            }
                            unmarkedKey = true;
                            this.keys.put("unmarked", privKey);
                            continue;
                        }
                        if (b2.getBagId().equals(certBag)) {
                            chain.addElement(b2);
                            continue;
                        }
                        System.out.println("extra in data " + b2.getBagId());
                        System.out.println(ASN1Dump.dumpAsString(b2));
                    }
                    continue;
                }
                if (c2[i2].getContentType().equals(encryptedData)) {
                    EncryptedData d2 = EncryptedData.getInstance(c2[i2].getContent());
                    byte[] octets = this.cryptData(false, d2.getEncryptionAlgorithm(), password, wrongPKCS12Zero, d2.getContent().getOctets());
                    ASN1Sequence seq = (ASN1Sequence)ASN1Primitive.fromByteArray(octets);
                    for (int j3 = 0; j3 != seq.size(); ++j3) {
                        String name;
                        ASN1Encodable existing;
                        ASN1Primitive attr;
                        ASN1Set attrSet;
                        ASN1ObjectIdentifier aOid;
                        ASN1Sequence sq;
                        Enumeration e5;
                        ASN1OctetString localId;
                        String alias;
                        PrivateKey privKey;
                        SafeBag b3 = SafeBag.getInstance(seq.getObjectAt(j3));
                        if (b3.getBagId().equals(certBag)) {
                            chain.addElement(b3);
                            continue;
                        }
                        if (b3.getBagId().equals(pkcs8ShroudedKeyBag)) {
                            EncryptedPrivateKeyInfo eIn = EncryptedPrivateKeyInfo.getInstance(b3.getBagValue());
                            privKey = this.unwrapKey(eIn.getEncryptionAlgorithm(), eIn.getEncryptedData(), password, wrongPKCS12Zero);
                            bagAttr = (PKCS12BagAttributeCarrier)((Object)privKey);
                            alias = null;
                            localId = null;
                            e5 = b3.getBagAttributes().getObjects();
                            while (e5.hasMoreElements()) {
                                sq = (ASN1Sequence)e5.nextElement();
                                aOid = (ASN1ObjectIdentifier)sq.getObjectAt(0);
                                attrSet = (ASN1Set)sq.getObjectAt(1);
                                attr = null;
                                if (attrSet.size() > 0) {
                                    attr = (ASN1Primitive)attrSet.getObjectAt(0);
                                    existing = bagAttr.getBagAttribute(aOid);
                                    if (existing != null) {
                                        if (!existing.toASN1Primitive().equals(attr)) {
                                            throw new IOException("attempt to add existing attribute with different value");
                                        }
                                    } else {
                                        bagAttr.setBagAttribute(aOid, attr);
                                    }
                                }
                                if (aOid.equals(pkcs_9_at_friendlyName)) {
                                    alias = ((DERBMPString)attr).getString();
                                    this.keys.put(alias, privKey);
                                    continue;
                                }
                                if (!aOid.equals(pkcs_9_at_localKeyId)) continue;
                                localId = (ASN1OctetString)attr;
                            }
                            name = new String(Hex.encode(localId.getOctets()));
                            if (alias == null) {
                                this.keys.put(name, privKey);
                                continue;
                            }
                            this.localIds.put(alias, name);
                            continue;
                        }
                        if (b3.getBagId().equals(keyBag)) {
                            PrivateKeyInfo kInfo = new PrivateKeyInfo((ASN1Sequence)b3.getBagValue());
                            privKey = BouncyCastleProvider.getPrivateKey(kInfo);
                            bagAttr = (PKCS12BagAttributeCarrier)((Object)privKey);
                            alias = null;
                            localId = null;
                            e5 = b3.getBagAttributes().getObjects();
                            while (e5.hasMoreElements()) {
                                sq = (ASN1Sequence)e5.nextElement();
                                aOid = (ASN1ObjectIdentifier)sq.getObjectAt(0);
                                attrSet = (ASN1Set)sq.getObjectAt(1);
                                attr = null;
                                if (attrSet.size() > 0) {
                                    attr = (ASN1Primitive)attrSet.getObjectAt(0);
                                    existing = bagAttr.getBagAttribute(aOid);
                                    if (existing != null) {
                                        if (!existing.toASN1Primitive().equals(attr)) {
                                            throw new IOException("attempt to add existing attribute with different value");
                                        }
                                    } else {
                                        bagAttr.setBagAttribute(aOid, attr);
                                    }
                                }
                                if (aOid.equals(pkcs_9_at_friendlyName)) {
                                    alias = ((DERBMPString)attr).getString();
                                    this.keys.put(alias, privKey);
                                    continue;
                                }
                                if (!aOid.equals(pkcs_9_at_localKeyId)) continue;
                                localId = (ASN1OctetString)attr;
                            }
                            name = new String(Hex.encode(localId.getOctets()));
                            if (alias == null) {
                                this.keys.put(name, privKey);
                                continue;
                            }
                            this.localIds.put(alias, name);
                            continue;
                        }
                        System.out.println("extra in encryptedData " + b3.getBagId());
                        System.out.println(ASN1Dump.dumpAsString(b3));
                    }
                    continue;
                }
                System.out.println("extra " + c2[i2].getContentType().getId());
                System.out.println("extra " + ASN1Dump.dumpAsString(c2[i2].getContent()));
            }
        }
        this.certs = new IgnoresCaseHashtable();
        this.chainCerts = new Hashtable();
        this.keyCerts = new Hashtable();
        for (int i3 = 0; i3 != chain.size(); ++i3) {
            String name;
            Certificate cert;
            SafeBag b4 = (SafeBag)chain.elementAt(i3);
            CertBag cb = CertBag.getInstance(b4.getBagValue());
            if (!cb.getCertId().equals(x509Certificate)) {
                throw new RuntimeException("Unsupported certificate type: " + cb.getCertId());
            }
            try {
                ByteArrayInputStream cIn = new ByteArrayInputStream(((ASN1OctetString)cb.getCertValue()).getOctets());
                cert = this.certFact.generateCertificate(cIn);
            }
            catch (Exception e6) {
                throw new RuntimeException(e6.toString());
            }
            ASN1OctetString localId = null;
            String alias = null;
            if (b4.getBagAttributes() != null) {
                Enumeration e7 = b4.getBagAttributes().getObjects();
                while (e7.hasMoreElements()) {
                    ASN1Sequence sq = (ASN1Sequence)e7.nextElement();
                    ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)sq.getObjectAt(0);
                    ASN1Primitive attr = (ASN1Primitive)((ASN1Set)sq.getObjectAt(1)).getObjectAt(0);
                    bagAttr = null;
                    if (cert instanceof PKCS12BagAttributeCarrier) {
                        bagAttr = (PKCS12BagAttributeCarrier)((Object)cert);
                        ASN1Encodable existing = bagAttr.getBagAttribute(oid);
                        if (existing != null) {
                            if (!existing.toASN1Primitive().equals(attr)) {
                                throw new IOException("attempt to add existing attribute with different value");
                            }
                        } else {
                            bagAttr.setBagAttribute(oid, attr);
                        }
                    }
                    if (oid.equals(pkcs_9_at_friendlyName)) {
                        alias = ((DERBMPString)attr).getString();
                        continue;
                    }
                    if (!oid.equals(pkcs_9_at_localKeyId)) continue;
                    localId = (ASN1OctetString)attr;
                }
            }
            this.chainCerts.put(new CertId(cert.getPublicKey()), cert);
            if (unmarkedKey) {
                if (!this.keyCerts.isEmpty()) continue;
                name = new String(Hex.encode(this.createSubjectKeyId(cert.getPublicKey()).getKeyIdentifier()));
                this.keyCerts.put(name, cert);
                this.keys.put(name, this.keys.remove("unmarked"));
                continue;
            }
            if (localId != null) {
                name = new String(Hex.encode(localId.getOctets()));
                this.keyCerts.put(name, cert);
            }
            if (alias == null) continue;
            this.certs.put(alias, cert);
        }
    }

    public void engineStore(KeyStore.LoadStoreParameter param) throws IOException, NoSuchAlgorithmException, CertificateException {
        char[] password;
        if (param == null) {
            throw new IllegalArgumentException("'param' arg cannot be null");
        }
        if (!(param instanceof JDKPKCS12StoreParameter)) {
            throw new IllegalArgumentException("No support for 'param' of type " + param.getClass().getName());
        }
        JDKPKCS12StoreParameter bcParam = (JDKPKCS12StoreParameter)param;
        KeyStore.ProtectionParameter protParam = param.getProtectionParameter();
        if (protParam == null) {
            password = null;
        } else if (protParam instanceof KeyStore.PasswordProtection) {
            password = ((KeyStore.PasswordProtection)protParam).getPassword();
        } else {
            throw new IllegalArgumentException("No support for protection parameter of type " + protParam.getClass().getName());
        }
        this.doStore(bcParam.getOutputStream(), password, bcParam.isUseDEREncoding());
    }

    public void engineStore(OutputStream stream, char[] password) throws IOException {
        this.doStore(stream, password, false);
    }

    private void doStore(OutputStream stream, char[] password, boolean useDEREncoding) throws IOException {
        MacData mData;
        Object certId;
        SafeBag sBag;
        ASN1EncodableVector fSeq;
        ASN1EncodableVector fSeq2;
        ASN1ObjectIdentifier oid;
        Enumeration e2;
        DERBMPString nm;
        PKCS12BagAttributeCarrier bagAttrs;
        ASN1EncodableVector fName;
        CertBag cBag;
        Certificate cert;
        if (password == null) {
            throw new NullPointerException("No password supplied for PKCS#12 KeyStore.");
        }
        ASN1EncodableVector keyS = new ASN1EncodableVector();
        Enumeration ks = this.keys.keys();
        while (ks.hasMoreElements()) {
            byte[] kSalt = new byte[20];
            this.random.nextBytes(kSalt);
            String name = (String)ks.nextElement();
            PrivateKey privKey = (PrivateKey)this.keys.get(name);
            PKCS12PBEParams kParams = new PKCS12PBEParams(kSalt, 1024);
            byte[] kBytes = this.wrapKey(this.keyAlgorithm.getId(), privKey, kParams, password);
            AlgorithmIdentifier kAlgId = new AlgorithmIdentifier(this.keyAlgorithm, (ASN1Encodable)kParams.toASN1Primitive());
            EncryptedPrivateKeyInfo kInfo = new EncryptedPrivateKeyInfo(kAlgId, kBytes);
            boolean attrSet = false;
            ASN1EncodableVector kName = new ASN1EncodableVector();
            if (privKey instanceof PKCS12BagAttributeCarrier) {
                PKCS12BagAttributeCarrier bagAttrs2 = (PKCS12BagAttributeCarrier)((Object)privKey);
                DERBMPString nm2 = (DERBMPString)bagAttrs2.getBagAttribute(pkcs_9_at_friendlyName);
                if (nm2 == null || !nm2.getString().equals(name)) {
                    bagAttrs2.setBagAttribute(pkcs_9_at_friendlyName, new DERBMPString(name));
                }
                if (bagAttrs2.getBagAttribute(pkcs_9_at_localKeyId) == null) {
                    Certificate ct = this.engineGetCertificate(name);
                    bagAttrs2.setBagAttribute(pkcs_9_at_localKeyId, this.createSubjectKeyId(ct.getPublicKey()));
                }
                Enumeration e3 = bagAttrs2.getBagAttributeKeys();
                while (e3.hasMoreElements()) {
                    ASN1ObjectIdentifier oid2 = (ASN1ObjectIdentifier)e3.nextElement();
                    ASN1EncodableVector kSeq = new ASN1EncodableVector();
                    kSeq.add(oid2);
                    kSeq.add(new DERSet(bagAttrs2.getBagAttribute(oid2)));
                    attrSet = true;
                    kName.add(new DERSequence(kSeq));
                }
            }
            if (!attrSet) {
                ASN1EncodableVector kSeq = new ASN1EncodableVector();
                Certificate ct = this.engineGetCertificate(name);
                kSeq.add(pkcs_9_at_localKeyId);
                kSeq.add(new DERSet(this.createSubjectKeyId(ct.getPublicKey())));
                kName.add(new DERSequence(kSeq));
                kSeq = new ASN1EncodableVector();
                kSeq.add(pkcs_9_at_friendlyName);
                kSeq.add(new DERSet(new DERBMPString(name)));
                kName.add(new DERSequence(kSeq));
            }
            SafeBag kBag = new SafeBag(pkcs8ShroudedKeyBag, kInfo.toASN1Primitive(), new DERSet(kName));
            keyS.add(kBag);
        }
        byte[] keySEncoded = new DERSequence(keyS).getEncoded("DER");
        BERConstructedOctetString keyString = new BERConstructedOctetString(keySEncoded);
        byte[] cSalt = new byte[20];
        this.random.nextBytes(cSalt);
        ASN1EncodableVector certSeq = new ASN1EncodableVector();
        PKCS12PBEParams cParams = new PKCS12PBEParams(cSalt, 1024);
        AlgorithmIdentifier cAlgId = new AlgorithmIdentifier(this.certAlgorithm, (ASN1Encodable)cParams.toASN1Primitive());
        Hashtable<Certificate, Certificate> doneCerts = new Hashtable<Certificate, Certificate>();
        Enumeration cs = this.keys.keys();
        while (cs.hasMoreElements()) {
            try {
                String name = (String)cs.nextElement();
                cert = this.engineGetCertificate(name);
                boolean cAttrSet = false;
                cBag = new CertBag(x509Certificate, new DEROctetString(cert.getEncoded()));
                fName = new ASN1EncodableVector();
                if (cert instanceof PKCS12BagAttributeCarrier) {
                    bagAttrs = (PKCS12BagAttributeCarrier)((Object)cert);
                    nm = (DERBMPString)bagAttrs.getBagAttribute(pkcs_9_at_friendlyName);
                    if (nm == null || !nm.getString().equals(name)) {
                        bagAttrs.setBagAttribute(pkcs_9_at_friendlyName, new DERBMPString(name));
                    }
                    if (bagAttrs.getBagAttribute(pkcs_9_at_localKeyId) == null) {
                        bagAttrs.setBagAttribute(pkcs_9_at_localKeyId, this.createSubjectKeyId(cert.getPublicKey()));
                    }
                    e2 = bagAttrs.getBagAttributeKeys();
                    while (e2.hasMoreElements()) {
                        oid = (ASN1ObjectIdentifier)e2.nextElement();
                        fSeq2 = new ASN1EncodableVector();
                        fSeq2.add(oid);
                        fSeq2.add(new DERSet(bagAttrs.getBagAttribute(oid)));
                        fName.add(new DERSequence(fSeq2));
                        cAttrSet = true;
                    }
                }
                if (!cAttrSet) {
                    fSeq = new ASN1EncodableVector();
                    fSeq.add(pkcs_9_at_localKeyId);
                    fSeq.add(new DERSet(this.createSubjectKeyId(cert.getPublicKey())));
                    fName.add(new DERSequence(fSeq));
                    fSeq = new ASN1EncodableVector();
                    fSeq.add(pkcs_9_at_friendlyName);
                    fSeq.add(new DERSet(new DERBMPString(name)));
                    fName.add(new DERSequence(fSeq));
                }
                sBag = new SafeBag(certBag, cBag.toASN1Primitive(), new DERSet(fName));
                certSeq.add(sBag);
                doneCerts.put(cert, cert);
            }
            catch (CertificateEncodingException e4) {
                throw new IOException("Error encoding certificate: " + e4.toString());
            }
        }
        cs = this.certs.keys();
        while (cs.hasMoreElements()) {
            try {
                certId = (String)cs.nextElement();
                cert = (Certificate)this.certs.get((String)certId);
                boolean cAttrSet = false;
                if (this.keys.get((String)certId) != null) continue;
                cBag = new CertBag(x509Certificate, new DEROctetString(cert.getEncoded()));
                fName = new ASN1EncodableVector();
                if (cert instanceof PKCS12BagAttributeCarrier) {
                    bagAttrs = (PKCS12BagAttributeCarrier)((Object)cert);
                    nm = (DERBMPString)bagAttrs.getBagAttribute(pkcs_9_at_friendlyName);
                    if (nm == null || !nm.getString().equals(certId)) {
                        bagAttrs.setBagAttribute(pkcs_9_at_friendlyName, new DERBMPString((String)certId));
                    }
                    e2 = bagAttrs.getBagAttributeKeys();
                    while (e2.hasMoreElements()) {
                        oid = (ASN1ObjectIdentifier)e2.nextElement();
                        if (oid.equals(PKCSObjectIdentifiers.pkcs_9_at_localKeyId)) continue;
                        fSeq2 = new ASN1EncodableVector();
                        fSeq2.add(oid);
                        fSeq2.add(new DERSet(bagAttrs.getBagAttribute(oid)));
                        fName.add(new DERSequence(fSeq2));
                        cAttrSet = true;
                    }
                }
                if (!cAttrSet) {
                    fSeq = new ASN1EncodableVector();
                    fSeq.add(pkcs_9_at_friendlyName);
                    fSeq.add(new DERSet(new DERBMPString((String)certId)));
                    fName.add(new DERSequence(fSeq));
                }
                sBag = new SafeBag(certBag, cBag.toASN1Primitive(), new DERSet(fName));
                certSeq.add(sBag);
                doneCerts.put(cert, cert);
            }
            catch (CertificateEncodingException e5) {
                throw new IOException("Error encoding certificate: " + e5.toString());
            }
        }
        cs = this.chainCerts.keys();
        while (cs.hasMoreElements()) {
            try {
                certId = (CertId)cs.nextElement();
                cert = (Certificate)this.chainCerts.get(certId);
                if (doneCerts.get(cert) != null) continue;
                CertBag cBag2 = new CertBag(x509Certificate, new DEROctetString(cert.getEncoded()));
                ASN1EncodableVector fName2 = new ASN1EncodableVector();
                if (cert instanceof PKCS12BagAttributeCarrier) {
                    PKCS12BagAttributeCarrier bagAttrs3 = (PKCS12BagAttributeCarrier)((Object)cert);
                    Enumeration e6 = bagAttrs3.getBagAttributeKeys();
                    while (e6.hasMoreElements()) {
                        ASN1ObjectIdentifier oid3 = (ASN1ObjectIdentifier)e6.nextElement();
                        if (oid3.equals(PKCSObjectIdentifiers.pkcs_9_at_localKeyId)) continue;
                        ASN1EncodableVector fSeq3 = new ASN1EncodableVector();
                        fSeq3.add(oid3);
                        fSeq3.add(new DERSet(bagAttrs3.getBagAttribute(oid3)));
                        fName2.add(new DERSequence(fSeq3));
                    }
                }
                SafeBag sBag2 = new SafeBag(certBag, cBag2.toASN1Primitive(), new DERSet(fName2));
                certSeq.add(sBag2);
            }
            catch (CertificateEncodingException e7) {
                throw new IOException("Error encoding certificate: " + e7.toString());
            }
        }
        byte[] certSeqEncoded = new DERSequence(certSeq).getEncoded("DER");
        byte[] certBytes = this.cryptData(true, cAlgId, password, false, certSeqEncoded);
        EncryptedData cInfo = new EncryptedData(data, cAlgId, new BERConstructedOctetString(certBytes));
        ContentInfo[] info = new ContentInfo[]{new ContentInfo(data, keyString), new ContentInfo(encryptedData, cInfo.toASN1Primitive())};
        AuthenticatedSafe auth = new AuthenticatedSafe(info);
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream asn1Out = useDEREncoding ? new DEROutputStream(bOut) : new BEROutputStream(bOut);
        asn1Out.writeObject(auth);
        byte[] pkg = bOut.toByteArray();
        ContentInfo mainInfo = new ContentInfo(data, new BERConstructedOctetString(pkg));
        byte[] mSalt = new byte[20];
        int itCount = 1024;
        this.random.nextBytes(mSalt);
        byte[] data = ((ASN1OctetString)mainInfo.getContent()).getOctets();
        try {
            byte[] res = JDKPKCS12KeyStore.calculatePbeMac(id_SHA1, mSalt, itCount, password, false, data);
            AlgorithmIdentifier algId = new AlgorithmIdentifier(id_SHA1, (ASN1Encodable)new DERNull());
            DigestInfo dInfo = new DigestInfo(algId, res);
            mData = new MacData(dInfo, mSalt, itCount);
        }
        catch (Exception e8) {
            throw new IOException("error constructing MAC: " + e8.toString());
        }
        Pfx pfx = new Pfx(mainInfo, mData);
        asn1Out = useDEREncoding ? new DEROutputStream(stream) : new BEROutputStream(stream);
        asn1Out.writeObject(pfx);
    }

    private static byte[] calculatePbeMac(ASN1ObjectIdentifier oid, byte[] salt, int itCount, char[] password, boolean wrongPkcs12Zero, byte[] data) throws Exception {
        SecretKeyFactory keyFact = SecretKeyFactory.getInstance(oid.getId(), bcProvider);
        PBEParameterSpec defParams = new PBEParameterSpec(salt, itCount);
        PBEKeySpec pbeSpec = new PBEKeySpec(password);
        BCPBEKey key = (BCPBEKey)keyFact.generateSecret(pbeSpec);
        key.setTryWrongPKCS12Zero(wrongPkcs12Zero);
        Mac mac = Mac.getInstance(oid.getId(), bcProvider);
        mac.init(key, defParams);
        mac.update(data);
        return mac.doFinal();
    }

    public static class BCPKCS12KeyStore
    extends JDKPKCS12KeyStore {
        public BCPKCS12KeyStore() {
            super(bcProvider, pbeWithSHAAnd3_KeyTripleDES_CBC, pbeWithSHAAnd40BitRC2_CBC);
        }
    }

    public static class BCPKCS12KeyStore3DES
    extends JDKPKCS12KeyStore {
        public BCPKCS12KeyStore3DES() {
            super(bcProvider, pbeWithSHAAnd3_KeyTripleDES_CBC, pbeWithSHAAnd3_KeyTripleDES_CBC);
        }
    }

    private class CertId {
        byte[] id;

        CertId(PublicKey key) {
            this.id = JDKPKCS12KeyStore.this.createSubjectKeyId(key).getKeyIdentifier();
        }

        CertId(byte[] id) {
            this.id = id;
        }

        public int hashCode() {
            return Arrays.hashCode(this.id);
        }

        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof CertId)) {
                return false;
            }
            CertId cId = (CertId)o2;
            return Arrays.areEqual(this.id, cId.id);
        }
    }

    public static class DefPKCS12KeyStore
    extends JDKPKCS12KeyStore {
        public DefPKCS12KeyStore() {
            super(null, pbeWithSHAAnd3_KeyTripleDES_CBC, pbeWithSHAAnd40BitRC2_CBC);
        }
    }

    public static class DefPKCS12KeyStore3DES
    extends JDKPKCS12KeyStore {
        public DefPKCS12KeyStore3DES() {
            super(null, pbeWithSHAAnd3_KeyTripleDES_CBC, pbeWithSHAAnd3_KeyTripleDES_CBC);
        }
    }

    private static class IgnoresCaseHashtable {
        private Hashtable orig = new Hashtable();
        private Hashtable keys = new Hashtable();

        private IgnoresCaseHashtable() {
        }

        public void put(String key, Object value) {
            String lower = Strings.toLowerCase(key);
            String k2 = (String)this.keys.get(lower);
            if (k2 != null) {
                this.orig.remove(k2);
            }
            this.keys.put(lower, key);
            this.orig.put(key, value);
        }

        public Enumeration keys() {
            return this.orig.keys();
        }

        public Object remove(String alias) {
            String k2 = (String)this.keys.remove(Strings.toLowerCase(alias));
            if (k2 == null) {
                return null;
            }
            return this.orig.remove(k2);
        }

        public Object get(String alias) {
            String k2 = (String)this.keys.get(Strings.toLowerCase(alias));
            if (k2 == null) {
                return null;
            }
            return this.orig.get(k2);
        }

        public Enumeration elements() {
            return this.orig.elements();
        }
    }
}

