/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.crypto.tls.TlsUtils;

public class Certificate {
    public static final Certificate EMPTY_CHAIN = new Certificate(new X509CertificateStructure[0]);
    protected X509CertificateStructure[] certs;

    protected static Certificate parse(InputStream is) throws IOException {
        int left = TlsUtils.readUint24(is);
        if (left == 0) {
            return EMPTY_CHAIN;
        }
        Vector<X509CertificateStructure> tmp = new Vector<X509CertificateStructure>();
        while (left > 0) {
            int size = TlsUtils.readUint24(is);
            left -= 3 + size;
            byte[] buf = new byte[size];
            TlsUtils.readFully(buf, is);
            ByteArrayInputStream bis = new ByteArrayInputStream(buf);
            ASN1InputStream ais = new ASN1InputStream(bis);
            ASN1Primitive o2 = ais.readObject();
            tmp.addElement(X509CertificateStructure.getInstance(o2));
            if (bis.available() <= 0) continue;
            throw new IllegalArgumentException("Sorry, there is garbage data left after the certificate");
        }
        X509CertificateStructure[] certs = new X509CertificateStructure[tmp.size()];
        for (int i2 = 0; i2 < tmp.size(); ++i2) {
            certs[i2] = (X509CertificateStructure)tmp.elementAt(i2);
        }
        return new Certificate(certs);
    }

    protected void encode(OutputStream os) throws IOException {
        byte[] encCert;
        int i2;
        Vector<byte[]> encCerts = new Vector<byte[]>();
        int totalSize = 0;
        for (i2 = 0; i2 < this.certs.length; ++i2) {
            encCert = this.certs[i2].getEncoded("DER");
            encCerts.addElement(encCert);
            totalSize += encCert.length + 3;
        }
        TlsUtils.writeUint24(totalSize, os);
        for (i2 = 0; i2 < encCerts.size(); ++i2) {
            encCert = (byte[])encCerts.elementAt(i2);
            TlsUtils.writeOpaque24(encCert, os);
        }
    }

    public Certificate(X509CertificateStructure[] certs) {
        if (certs == null) {
            throw new IllegalArgumentException("'certs' cannot be null");
        }
        this.certs = certs;
    }

    public X509CertificateStructure[] getCerts() {
        X509CertificateStructure[] result = new X509CertificateStructure[this.certs.length];
        System.arraycopy(this.certs, 0, result, 0, this.certs.length);
        return result;
    }

    public boolean isEmpty() {
        return this.certs.length == 0;
    }
}

