/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.signers;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DSA;
import org.bouncycastle.crypto.params.ECKeyParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECPoint;

public class ECGOST3410Signer
implements DSA {
    ECKeyParameters key;
    SecureRandom random;

    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.random = rParam.getRandom();
                this.key = (ECPrivateKeyParameters)rParam.getParameters();
            } else {
                this.random = new SecureRandom();
                this.key = (ECPrivateKeyParameters)param;
            }
        } else {
            this.key = (ECPublicKeyParameters)param;
        }
    }

    public BigInteger[] generateSignature(byte[] message) {
        BigInteger d2;
        BigInteger k2;
        byte[] mRev = new byte[message.length];
        for (int i2 = 0; i2 != mRev.length; ++i2) {
            mRev[i2] = message[mRev.length - 1 - i2];
        }
        BigInteger e2 = new BigInteger(1, mRev);
        BigInteger n2 = this.key.getParameters().getN();
        BigInteger r2 = null;
        BigInteger s2 = null;
        do {
            ECPoint p2;
            BigInteger x2;
            k2 = null;
            while ((k2 = new BigInteger(n2.bitLength(), this.random)).equals(ECConstants.ZERO) || (r2 = (x2 = (p2 = this.key.getParameters().getG().multiply(k2)).getX().toBigInteger()).mod(n2)).equals(ECConstants.ZERO)) {
            }
            d2 = ((ECPrivateKeyParameters)this.key).getD();
        } while ((s2 = k2.multiply(e2).add(d2.multiply(r2)).mod(n2)).equals(ECConstants.ZERO));
        BigInteger[] res = new BigInteger[]{r2, s2};
        return res;
    }

    public boolean verifySignature(byte[] message, BigInteger r2, BigInteger s2) {
        byte[] mRev = new byte[message.length];
        for (int i2 = 0; i2 != mRev.length; ++i2) {
            mRev[i2] = message[mRev.length - 1 - i2];
        }
        BigInteger e2 = new BigInteger(1, mRev);
        BigInteger n2 = this.key.getParameters().getN();
        if (r2.compareTo(ECConstants.ONE) < 0 || r2.compareTo(n2) >= 0) {
            return false;
        }
        if (s2.compareTo(ECConstants.ONE) < 0 || s2.compareTo(n2) >= 0) {
            return false;
        }
        BigInteger v2 = e2.modInverse(n2);
        BigInteger z1 = s2.multiply(v2).mod(n2);
        BigInteger z2 = n2.subtract(r2).multiply(v2).mod(n2);
        ECPoint G = this.key.getParameters().getG();
        ECPoint Q = ((ECPublicKeyParameters)this.key).getQ();
        ECPoint point = ECAlgorithms.sumOfTwoMultiplies(G, z1, Q, z2);
        BigInteger R = point.getX().toBigInteger().mod(n2);
        return R.equals(r2);
    }
}

