/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.params;

import java.math.BigInteger;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.DHValidationParameters;

public class DHParameters
implements CipherParameters {
    private static final int DEFAULT_MINIMUM_LENGTH = 160;
    private BigInteger g;
    private BigInteger p;
    private BigInteger q;
    private BigInteger j;
    private int m;
    private int l;
    private DHValidationParameters validation;

    private static int getDefaultMParam(int lParam) {
        if (lParam == 0) {
            return 160;
        }
        return lParam < 160 ? lParam : 160;
    }

    public DHParameters(BigInteger p2, BigInteger g2) {
        this(p2, g2, null, 0);
    }

    public DHParameters(BigInteger p2, BigInteger g2, BigInteger q2) {
        this(p2, g2, q2, 0);
    }

    public DHParameters(BigInteger p2, BigInteger g2, BigInteger q2, int l2) {
        this(p2, g2, q2, DHParameters.getDefaultMParam(l2), l2, null, null);
    }

    public DHParameters(BigInteger p2, BigInteger g2, BigInteger q2, int m2, int l2) {
        this(p2, g2, q2, m2, l2, null, null);
    }

    public DHParameters(BigInteger p2, BigInteger g2, BigInteger q2, BigInteger j2, DHValidationParameters validation) {
        this(p2, g2, q2, 160, 0, j2, validation);
    }

    public DHParameters(BigInteger p2, BigInteger g2, BigInteger q2, int m2, int l2, BigInteger j2, DHValidationParameters validation) {
        if (l2 != 0) {
            BigInteger bigL = BigInteger.valueOf(2L ^ (long)(l2 - 1));
            if (bigL.compareTo(p2) == 1) {
                throw new IllegalArgumentException("when l value specified, it must satisfy 2^(l-1) <= p");
            }
            if (l2 < m2) {
                throw new IllegalArgumentException("when l value specified, it may not be less than m value");
            }
        }
        this.g = g2;
        this.p = p2;
        this.q = q2;
        this.m = m2;
        this.l = l2;
        this.j = j2;
        this.validation = validation;
    }

    public BigInteger getP() {
        return this.p;
    }

    public BigInteger getG() {
        return this.g;
    }

    public BigInteger getQ() {
        return this.q;
    }

    public BigInteger getJ() {
        return this.j;
    }

    public int getM() {
        return this.m;
    }

    public int getL() {
        return this.l;
    }

    public DHValidationParameters getValidationParameters() {
        return this.validation;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DHParameters)) {
            return false;
        }
        DHParameters pm = (DHParameters)obj;
        if (this.getQ() != null ? !this.getQ().equals(pm.getQ()) : pm.getQ() != null) {
            return false;
        }
        return pm.getP().equals(this.p) && pm.getG().equals(this.g);
    }

    public int hashCode() {
        return this.getP().hashCode() ^ this.getG().hashCode() ^ (this.getQ() != null ? this.getQ().hashCode() : 0);
    }
}

