/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes.gcm;

import org.bouncycastle.crypto.util.Pack;
import org.bouncycastle.util.Arrays;

abstract class GCMUtil {
    GCMUtil() {
    }

    static byte[] oneAsBytes() {
        byte[] tmp = new byte[16];
        tmp[0] = -128;
        return tmp;
    }

    static int[] oneAsInts() {
        int[] tmp = new int[4];
        tmp[0] = Integer.MIN_VALUE;
        return tmp;
    }

    static int[] asInts(byte[] bs) {
        int[] us = new int[]{Pack.bigEndianToInt(bs, 0), Pack.bigEndianToInt(bs, 4), Pack.bigEndianToInt(bs, 8), Pack.bigEndianToInt(bs, 12)};
        return us;
    }

    static void multiply(byte[] block, byte[] val) {
        byte[] tmp = Arrays.clone(block);
        byte[] c2 = new byte[16];
        for (int i2 = 0; i2 < 16; ++i2) {
            byte bits = val[i2];
            for (int j2 = 7; j2 >= 0; --j2) {
                if ((bits & 1 << j2) != 0) {
                    GCMUtil.xor(c2, tmp);
                }
                boolean lsb = (tmp[15] & 1) != 0;
                GCMUtil.shiftRight(tmp);
                if (!lsb) continue;
                tmp[0] = (byte)(tmp[0] ^ 0xFFFFFFE1);
            }
        }
        System.arraycopy(c2, 0, block, 0, 16);
    }

    static void multiplyP(int[] x2) {
        boolean lsb = (x2[3] & 1) != 0;
        GCMUtil.shiftRight(x2);
        if (lsb) {
            x2[0] = x2[0] ^ 0xE1000000;
        }
    }

    static void multiplyP8(int[] x2) {
        int lsw = x2[3];
        GCMUtil.shiftRightN(x2, 8);
        for (int i2 = 7; i2 >= 0; --i2) {
            if ((lsw & 1 << i2) == 0) continue;
            x2[0] = x2[0] ^ -520093696 >>> 7 - i2;
        }
    }

    static void shiftRight(byte[] block) {
        int i2 = 0;
        int bit = 0;
        while (true) {
            int b2 = block[i2] & 0xFF;
            block[i2] = (byte)(b2 >>> 1 | bit);
            if (++i2 == 16) break;
            bit = (b2 & 1) << 7;
        }
    }

    static void shiftRight(int[] block) {
        int i2 = 0;
        int bit = 0;
        while (true) {
            int b2 = block[i2];
            block[i2] = b2 >>> 1 | bit;
            if (++i2 == 4) break;
            bit = b2 << 31;
        }
    }

    static void shiftRightN(int[] block, int n2) {
        int i2 = 0;
        int bits = 0;
        while (true) {
            int b2 = block[i2];
            block[i2] = b2 >>> n2 | bits;
            if (++i2 == 4) break;
            bits = b2 << 32 - n2;
        }
    }

    static void xor(byte[] block, byte[] val) {
        for (int i2 = 15; i2 >= 0; --i2) {
            int n2 = i2;
            block[n2] = (byte)(block[n2] ^ val[i2]);
        }
    }

    static void xor(int[] block, int[] val) {
        for (int i2 = 3; i2 >= 0; --i2) {
            int n2 = i2;
            block[n2] = block[n2] ^ val[i2];
        }
    }
}

