/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.params.DHParameters;
import org.bouncycastle.util.BigIntegers;

class DHKeyGeneratorHelper {
    static final DHKeyGeneratorHelper INSTANCE = new DHKeyGeneratorHelper();
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);

    private DHKeyGeneratorHelper() {
    }

    BigInteger calculatePrivate(DHParameters dhParams, SecureRandom random) {
        BigInteger p2 = dhParams.getP();
        int limit = dhParams.getL();
        if (limit != 0) {
            return new BigInteger(limit, random).setBit(limit - 1);
        }
        BigInteger min = TWO;
        int m2 = dhParams.getM();
        if (m2 != 0) {
            min = ONE.shiftLeft(m2 - 1);
        }
        BigInteger max = p2.subtract(TWO);
        BigInteger q2 = dhParams.getQ();
        if (q2 != null) {
            max = q2.subtract(TWO);
        }
        return BigIntegers.createRandomInRange(min, max, random);
    }

    BigInteger calculatePublic(DHParameters dhParams, BigInteger x2) {
        return dhParams.getG().modPow(x2, dhParams.getP());
    }
}

