/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.params.KeyParameter;

public class NoekeonEngine
implements BlockCipher {
    private static final int genericSize = 16;
    private static final int[] nullVector = new int[]{0, 0, 0, 0};
    private static final int[] roundConstants = new int[]{128, 27, 54, 108, 216, 171, 77, 154, 47, 94, 188, 99, 198, 151, 53, 106, 212};
    private int[] state = new int[4];
    private int[] subKeys = new int[4];
    private int[] decryptKeys = new int[4];
    private boolean _initialised = false;
    private boolean _forEncryption;

    public String getAlgorithmName() {
        return "Noekeon";
    }

    public int getBlockSize() {
        return 16;
    }

    public void init(boolean forEncryption, CipherParameters params) {
        if (!(params instanceof KeyParameter)) {
            throw new IllegalArgumentException("invalid parameter passed to Noekeon init - " + params.getClass().getName());
        }
        this._forEncryption = forEncryption;
        this._initialised = true;
        KeyParameter p2 = (KeyParameter)params;
        this.setKey(p2.getKey());
    }

    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) {
        if (!this._initialised) {
            throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
        }
        if (inOff + 16 > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + 16 > out.length) {
            throw new DataLengthException("output buffer too short");
        }
        return this._forEncryption ? this.encryptBlock(in, inOff, out, outOff) : this.decryptBlock(in, inOff, out, outOff);
    }

    public void reset() {
    }

    private void setKey(byte[] key) {
        this.subKeys[0] = this.bytesToIntBig(key, 0);
        this.subKeys[1] = this.bytesToIntBig(key, 4);
        this.subKeys[2] = this.bytesToIntBig(key, 8);
        this.subKeys[3] = this.bytesToIntBig(key, 12);
    }

    private int encryptBlock(byte[] in, int inOff, byte[] out, int outOff) {
        int i2;
        this.state[0] = this.bytesToIntBig(in, inOff);
        this.state[1] = this.bytesToIntBig(in, inOff + 4);
        this.state[2] = this.bytesToIntBig(in, inOff + 8);
        this.state[3] = this.bytesToIntBig(in, inOff + 12);
        for (i2 = 0; i2 < 16; ++i2) {
            this.state[0] = this.state[0] ^ roundConstants[i2];
            this.theta(this.state, this.subKeys);
            this.pi1(this.state);
            this.gamma(this.state);
            this.pi2(this.state);
        }
        this.state[0] = this.state[0] ^ roundConstants[i2];
        this.theta(this.state, this.subKeys);
        this.intToBytesBig(this.state[0], out, outOff);
        this.intToBytesBig(this.state[1], out, outOff + 4);
        this.intToBytesBig(this.state[2], out, outOff + 8);
        this.intToBytesBig(this.state[3], out, outOff + 12);
        return 16;
    }

    private int decryptBlock(byte[] in, int inOff, byte[] out, int outOff) {
        int i2;
        this.state[0] = this.bytesToIntBig(in, inOff);
        this.state[1] = this.bytesToIntBig(in, inOff + 4);
        this.state[2] = this.bytesToIntBig(in, inOff + 8);
        this.state[3] = this.bytesToIntBig(in, inOff + 12);
        System.arraycopy(this.subKeys, 0, this.decryptKeys, 0, this.subKeys.length);
        this.theta(this.decryptKeys, nullVector);
        for (i2 = 16; i2 > 0; --i2) {
            this.theta(this.state, this.decryptKeys);
            this.state[0] = this.state[0] ^ roundConstants[i2];
            this.pi1(this.state);
            this.gamma(this.state);
            this.pi2(this.state);
        }
        this.theta(this.state, this.decryptKeys);
        this.state[0] = this.state[0] ^ roundConstants[i2];
        this.intToBytesBig(this.state[0], out, outOff);
        this.intToBytesBig(this.state[1], out, outOff + 4);
        this.intToBytesBig(this.state[2], out, outOff + 8);
        this.intToBytesBig(this.state[3], out, outOff + 12);
        return 16;
    }

    private void gamma(int[] a2) {
        a2[1] = a2[1] ^ ~a2[3] & ~a2[2];
        a2[0] = a2[0] ^ a2[2] & a2[1];
        int tmp = a2[3];
        a2[3] = a2[0];
        a2[0] = tmp;
        a2[2] = a2[2] ^ (a2[0] ^ a2[1] ^ a2[3]);
        a2[1] = a2[1] ^ ~a2[3] & ~a2[2];
        a2[0] = a2[0] ^ a2[2] & a2[1];
    }

    private void theta(int[] a2, int[] k2) {
        int tmp = a2[0] ^ a2[2];
        tmp ^= this.rotl(tmp, 8) ^ this.rotl(tmp, 24);
        a2[1] = a2[1] ^ tmp;
        a2[3] = a2[3] ^ tmp;
        for (int i2 = 0; i2 < 4; ++i2) {
            int n2 = i2;
            a2[n2] = a2[n2] ^ k2[i2];
        }
        tmp = a2[1] ^ a2[3];
        tmp ^= this.rotl(tmp, 8) ^ this.rotl(tmp, 24);
        a2[0] = a2[0] ^ tmp;
        a2[2] = a2[2] ^ tmp;
    }

    private void pi1(int[] a2) {
        a2[1] = this.rotl(a2[1], 1);
        a2[2] = this.rotl(a2[2], 5);
        a2[3] = this.rotl(a2[3], 2);
    }

    private void pi2(int[] a2) {
        a2[1] = this.rotl(a2[1], 31);
        a2[2] = this.rotl(a2[2], 27);
        a2[3] = this.rotl(a2[3], 30);
    }

    private int bytesToIntBig(byte[] in, int off) {
        return in[off++] << 24 | (in[off++] & 0xFF) << 16 | (in[off++] & 0xFF) << 8 | in[off] & 0xFF;
    }

    private void intToBytesBig(int x2, byte[] out, int off) {
        out[off++] = (byte)(x2 >>> 24);
        out[off++] = (byte)(x2 >>> 16);
        out[off++] = (byte)(x2 >>> 8);
        out[off] = (byte)x2;
    }

    private int rotl(int x2, int y) {
        return x2 << y | x2 >>> 32 - y;
    }
}

