/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.util.Pack;

public abstract class LongDigest
implements ExtendedDigest {
    private static final int BYTE_LENGTH = 128;
    private byte[] xBuf;
    private int xBufOff;
    private long byteCount1;
    private long byteCount2;
    protected long H1;
    protected long H2;
    protected long H3;
    protected long H4;
    protected long H5;
    protected long H6;
    protected long H7;
    protected long H8;
    private long[] W = new long[80];
    private int wOff;
    static final long[] K = new long[]{4794697086780616226L, 8158064640168781261L, -5349999486874862801L, -1606136188198331460L, 4131703408338449720L, 6480981068601479193L, -7908458776815382629L, -6116909921290321640L, -2880145864133508542L, 1334009975649890238L, 2608012711638119052L, 6128411473006802146L, 8268148722764581231L, -9160688886553864527L, -7215885187991268811L, -4495734319001033068L, -1973867731355612462L, -1171420211273849373L, 1135362057144423861L, 2597628984639134821L, 3308224258029322869L, 5365058923640841347L, 6679025012923562964L, 8573033837759648693L, -7476448914759557205L, -6327057829258317296L, -5763719355590565569L, -4658551843659510044L, -4116276920077217854L, -3051310485924567259L, 489312712824947311L, 1452737877330783856L, 2861767655752347644L, 3322285676063803686L, 5560940570517711597L, 5996557281743188959L, 7280758554555802590L, 8532644243296465576L, -9096487096722542874L, -7894198246740708037L, -6719396339535248540L, -6333637450476146687L, -4446306890439682159L, -4076793802049405392L, -3345356375505022440L, -2983346525034927856L, -860691631967231958L, 1182934255886127544L, 1847814050463011016L, 2177327727835720531L, 2830643537854262169L, 3796741975233480872L, 4115178125766777443L, 5681478168544905931L, 6601373596472566643L, 7507060721942968483L, 8399075790359081724L, 8693463985226723168L, -8878714635349349518L, -8302665154208450068L, -8016688836872298968L, -6606660893046293015L, -4685533653050689259L, -4147400797238176981L, -3880063495543823972L, -3348786107499101689L, -1523767162380948706L, -757361751448694408L, 500013540394364858L, 748580250866718886L, 1242879168328830382L, 1977374033974150939L, 2944078676154940804L, 3659926193048069267L, 4368137639120453308L, 4836135668995329356L, 5532061633213252278L, 6448918945643986474L, 6902733635092675308L, 7801388544844847127L};

    protected LongDigest() {
        this.xBuf = new byte[8];
        this.xBufOff = 0;
        this.reset();
    }

    protected LongDigest(LongDigest t2) {
        this.xBuf = new byte[t2.xBuf.length];
        System.arraycopy(t2.xBuf, 0, this.xBuf, 0, t2.xBuf.length);
        this.xBufOff = t2.xBufOff;
        this.byteCount1 = t2.byteCount1;
        this.byteCount2 = t2.byteCount2;
        this.H1 = t2.H1;
        this.H2 = t2.H2;
        this.H3 = t2.H3;
        this.H4 = t2.H4;
        this.H5 = t2.H5;
        this.H6 = t2.H6;
        this.H7 = t2.H7;
        this.H8 = t2.H8;
        System.arraycopy(t2.W, 0, this.W, 0, t2.W.length);
        this.wOff = t2.wOff;
    }

    public void update(byte in) {
        this.xBuf[this.xBufOff++] = in;
        if (this.xBufOff == this.xBuf.length) {
            this.processWord(this.xBuf, 0);
            this.xBufOff = 0;
        }
        ++this.byteCount1;
    }

    public void update(byte[] in, int inOff, int len) {
        while (this.xBufOff != 0 && len > 0) {
            this.update(in[inOff]);
            ++inOff;
            --len;
        }
        while (len > this.xBuf.length) {
            this.processWord(in, inOff);
            inOff += this.xBuf.length;
            len -= this.xBuf.length;
            this.byteCount1 += (long)this.xBuf.length;
        }
        while (len > 0) {
            this.update(in[inOff]);
            ++inOff;
            --len;
        }
    }

    public void finish() {
        this.adjustByteCounts();
        long lowBitLength = this.byteCount1 << 3;
        long hiBitLength = this.byteCount2;
        this.update((byte)-128);
        while (this.xBufOff != 0) {
            this.update((byte)0);
        }
        this.processLength(lowBitLength, hiBitLength);
        this.processBlock();
    }

    public void reset() {
        int i2;
        this.byteCount1 = 0L;
        this.byteCount2 = 0L;
        this.xBufOff = 0;
        for (i2 = 0; i2 < this.xBuf.length; ++i2) {
            this.xBuf[i2] = 0;
        }
        this.wOff = 0;
        for (i2 = 0; i2 != this.W.length; ++i2) {
            this.W[i2] = 0L;
        }
    }

    public int getByteLength() {
        return 128;
    }

    protected void processWord(byte[] in, int inOff) {
        this.W[this.wOff] = Pack.bigEndianToLong(in, inOff);
        if (++this.wOff == 16) {
            this.processBlock();
        }
    }

    private void adjustByteCounts() {
        if (this.byteCount1 > 0x1FFFFFFFFFFFFFFFL) {
            this.byteCount2 += this.byteCount1 >>> 61;
            this.byteCount1 &= 0x1FFFFFFFFFFFFFFFL;
        }
    }

    protected void processLength(long lowW, long hiW) {
        if (this.wOff > 14) {
            this.processBlock();
        }
        this.W[14] = hiW;
        this.W[15] = lowW;
    }

    protected void processBlock() {
        int i2;
        this.adjustByteCounts();
        for (int t2 = 16; t2 <= 79; ++t2) {
            this.W[t2] = this.Sigma1(this.W[t2 - 2]) + this.W[t2 - 7] + this.Sigma0(this.W[t2 - 15]) + this.W[t2 - 16];
        }
        long a2 = this.H1;
        long b2 = this.H2;
        long c2 = this.H3;
        long d2 = this.H4;
        long e2 = this.H5;
        long f2 = this.H6;
        long g2 = this.H7;
        long h2 = this.H8;
        int t3 = 0;
        for (i2 = 0; i2 < 10; ++i2) {
            long l2 = this.Sum1(e2) + this.Ch(e2, f2, g2) + K[t3];
            int n2 = t3++;
            h2 += this.Sum0(a2) + this.Maj(a2, b2, c2);
            long l3 = this.Sum1(d2 += (h2 += l2 + this.W[n2])) + this.Ch(d2, e2, f2) + K[t3];
            int n3 = t3++;
            g2 += this.Sum0(h2) + this.Maj(h2, a2, b2);
            long l4 = this.Sum1(c2 += (g2 += l3 + this.W[n3])) + this.Ch(c2, d2, e2) + K[t3];
            int n4 = t3++;
            f2 += this.Sum0(g2) + this.Maj(g2, h2, a2);
            long l5 = this.Sum1(b2 += (f2 += l4 + this.W[n4])) + this.Ch(b2, c2, d2) + K[t3];
            int n5 = t3++;
            e2 += this.Sum0(f2) + this.Maj(f2, g2, h2);
            long l6 = this.Sum1(a2 += (e2 += l5 + this.W[n5])) + this.Ch(a2, b2, c2) + K[t3];
            int n6 = t3++;
            d2 += this.Sum0(e2) + this.Maj(e2, f2, g2);
            long l7 = this.Sum1(h2 += (d2 += l6 + this.W[n6])) + this.Ch(h2, a2, b2) + K[t3];
            int n7 = t3++;
            c2 += this.Sum0(d2) + this.Maj(d2, e2, f2);
            long l8 = this.Sum1(g2 += (c2 += l7 + this.W[n7])) + this.Ch(g2, h2, a2) + K[t3];
            int n8 = t3++;
            b2 += this.Sum0(c2) + this.Maj(c2, d2, e2);
            e2 += (a2 += this.Sum1(f2 += (b2 += l8 + this.W[n8])) + this.Ch(f2, g2, h2) + K[t3] + this.W[t3++]);
            a2 += this.Sum0(b2) + this.Maj(b2, c2, d2);
        }
        this.H1 += a2;
        this.H2 += b2;
        this.H3 += c2;
        this.H4 += d2;
        this.H5 += e2;
        this.H6 += f2;
        this.H7 += g2;
        this.H8 += h2;
        this.wOff = 0;
        for (i2 = 0; i2 < 16; ++i2) {
            this.W[i2] = 0L;
        }
    }

    private long Ch(long x2, long y, long z) {
        return x2 & y ^ (x2 ^ 0xFFFFFFFFFFFFFFFFL) & z;
    }

    private long Maj(long x2, long y, long z) {
        return x2 & y ^ x2 & z ^ y & z;
    }

    private long Sum0(long x2) {
        return (x2 << 36 | x2 >>> 28) ^ (x2 << 30 | x2 >>> 34) ^ (x2 << 25 | x2 >>> 39);
    }

    private long Sum1(long x2) {
        return (x2 << 50 | x2 >>> 14) ^ (x2 << 46 | x2 >>> 18) ^ (x2 << 23 | x2 >>> 41);
    }

    private long Sigma0(long x2) {
        return (x2 << 63 | x2 >>> 1) ^ (x2 << 56 | x2 >>> 8) ^ x2 >>> 7;
    }

    private long Sigma1(long x2) {
        return (x2 << 45 | x2 >>> 19) ^ (x2 << 3 | x2 >>> 61) ^ x2 >>> 6;
    }
}

