/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.StreamCipher;

public class StreamBlockCipher
implements StreamCipher {
    private BlockCipher cipher;
    private byte[] oneByte = new byte[1];

    public StreamBlockCipher(BlockCipher cipher) {
        if (cipher.getBlockSize() != 1) {
            throw new IllegalArgumentException("block cipher block size != 1.");
        }
        this.cipher = cipher;
    }

    public void init(boolean forEncryption, CipherParameters params) {
        this.cipher.init(forEncryption, params);
    }

    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName();
    }

    public byte returnByte(byte in) {
        this.oneByte[0] = in;
        this.cipher.processBlock(this.oneByte, 0, this.oneByte, 0);
        return this.oneByte[0];
    }

    public void processBytes(byte[] in, int inOff, int len, byte[] out, int outOff) throws DataLengthException {
        if (outOff + len > out.length) {
            throw new DataLengthException("output buffer too small in processBytes()");
        }
        for (int i2 = 0; i2 != len; ++i2) {
            this.cipher.processBlock(in, inOff + i2, out, outOff + i2);
        }
    }

    public void reset() {
        this.cipher.reset();
    }
}

